/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.ibm.malamut.newsmail.ActiveData;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.NNTPServerData;
import net.ibm.malamut.newsmail.database.GenericDatabase;

public final class NewsserverBase
extends GenericDatabase {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(String string, String string2) throws IOException {
        Object object;
        int n = 0;
        this.sync.startRead();
        Object object2 = this.data.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (string.equals(object)) {
                this.sync.endRead();
                return;
            }
            Object v = this.data.get(object);
            if (v instanceof NNTPServerData) {
                NNTPServerData nNTPServerData = (NNTPServerData)v;
                if (nNTPServerData.activeFile <= n) continue;
                n = nNTPServerData.activeFile;
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        object2 = new NNTPServerData();
        ((NNTPServerData)object2).activeFile = ++n;
        ((NNTPServerData)object2).title = string2;
        super.put(string, object2);
        this.sync.startWrite();
        try {
            object = new FileOutputStream(this.basis.dataDir() + "a" + String.valueOf(n));
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            this.sync.endWrite();
            throw iOException;
        }
        this.sync.endWrite();
    }

    public boolean exists(String string) {
        return this.containsKey(string);
    }

    private final NNTPServerData get(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof NNTPServerData) {
            return (NNTPServerData)object;
        }
        this.error();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable getActiveGroups(String string) throws IOException {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            return null;
        }
        Hashtable hashtable = null;
        this.sync.startRead();
        try {
            hashtable = this.basis.scanHashtableFile("a" + String.valueOf(nNTPServerData.activeFile), false);
        }
        catch (IOException iOException) {
            this.sync.endRead();
            throw iOException;
        }
        this.sync.endRead();
        return hashtable;
    }

    public Date getListDate(String string) {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            return null;
        }
        return nNTPServerData.newslistDate;
    }

    public boolean hasGroupList(String string) {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            return false;
        }
        this.sync.startRead();
        File file = new File(this.basis.dataDir() + "n" + nNTPServerData.activeFile);
        boolean bl = file.exists();
        this.sync.endRead();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putActiveGroups(String string, Hashtable hashtable) throws IOException {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            throw new IOException("Can't write active list for unknown server '" + string + "'.");
        }
        this.sync.startWrite();
        try {
            this.basis.saveHashtableFile(hashtable, "a" + String.valueOf(nNTPServerData.activeFile), false);
        }
        catch (IOException iOException) {
            this.sync.endWrite();
            throw iOException;
        }
        this.sync.endWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeNode readGroupList(String string) throws IOException {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            throw new IOException("Couldn't read Group List: No valid data available for server '" + string + "'.");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        BufferedReader bufferedReader = null;
        this.sync.startRead();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new ProgressMonitorInputStream(null, "Scanning newsgroup list", new FileInputStream(this.basis.dataDir() + "n" + nNTPServerData.activeFile))));
        }
        catch (Exception exception) {
            this.sync.endRead();
            return new DefaultMutableTreeNode("no list available");
        }
        int n = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
            defaultMutableTreeNode = NewsserverBase.readNode(bufferedReader);
            bufferedReader.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().setPriority(n);
            this.sync.endRead();
            return new DefaultMutableTreeNode("user aborted scanning");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            defaultMutableTreeNode = null;
            Thread.currentThread().setPriority(n);
            this.sync.endRead();
            Basis.memoryFullAlert("Scanning newsgroup list for server: " + string);
            return new DefaultMutableTreeNode("not enough memory");
        }
        catch (Exception exception) {
            Thread.currentThread().setPriority(n);
            this.sync.endRead();
            throw new IOException("Something went wrong reading file '" + this.basis.dataDir() + "n" + nNTPServerData.activeFile + ". Details:" + ErrorTools.redirect(exception));
        }
        Thread.currentThread().setPriority(n);
        this.sync.endRead();
        return defaultMutableTreeNode;
    }

    private static final DefaultMutableTreeNode readNode(BufferedReader bufferedReader) throws IOException {
        int n = Integer.parseInt(bufferedReader.readLine());
        if (n != 0) {
            throw new IOException("Bad file format - expected 0");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(bufferedReader.readLine());
        n = Integer.parseInt(bufferedReader.readLine());
        if (n == 1 ? NewsserverBase.readNode(defaultMutableTreeNode, bufferedReader, 1) != -1 : n != -1) {
            throw new IOException("Bad file format - expected -1");
        }
        return defaultMutableTreeNode;
    }

    private static final int readNode(DefaultMutableTreeNode defaultMutableTreeNode, BufferedReader bufferedReader, int n) throws IOException {
        if (n == 3) {
            Thread.yield();
        }
        int n2 = n;
        while (n2 == n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(bufferedReader.readLine());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            n = Integer.parseInt(bufferedReader.readLine());
            if (n <= n2) continue;
            n = NewsserverBase.readNode(defaultMutableTreeNode2, bufferedReader, n);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String string) {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            return;
        }
        File file = new File(this.basis.dataDir() + "a" + String.valueOf(nNTPServerData.activeFile));
        this.sync.startWrite();
        try {
            file.delete();
        }
        catch (SecurityException securityException) {
        }
        this.data.remove(string);
        this.sync.endWrite();
    }

    public void rename(String string, String string2) {
        if (this.exists(string)) {
            this.sync.startWrite();
            Object v = this.data.get(string);
            if (v instanceof NNTPServerData) {
                ((NNTPServerData)v).title = string2;
            } else {
                this.error();
            }
            this.sync.endWrite();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetRemote(String string, String string2) {
        this.sync.startRead();
        Hashtable hashtable = null;
        try {
            hashtable = this.getActiveGroups(string);
        }
        catch (IOException iOException) {
            this.sync.endRead();
            return;
        }
        Object v = hashtable.get(string2);
        if (!(v instanceof ActiveData)) {
            this.sync.endRead();
            return;
        }
        ((ActiveData)v).lastArticle = 0L;
        try {
            this.putActiveGroups(string, hashtable);
        }
        catch (IOException iOException) {
        }
        this.sync.endRead();
    }

    public Vector servers() {
        Vector vector = new Vector();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                vector.addElement(k);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public String title(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof NNTPServerData) {
            return ((NNTPServerData)object).title;
        }
        this.error();
        return null;
    }

    public Vector titles() {
        Vector<String> vector = new Vector<String>();
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof NNTPServerData) {
                vector.addElement(((NNTPServerData)v).title);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeGroupList(String string, TreeNode treeNode) throws IOException {
        NNTPServerData nNTPServerData = this.get(string);
        if (nNTPServerData == null) {
            throw new IOException("Group List couldn't be saved: No valid data available for server '" + string + "'.");
        }
        this.sync.startWrite();
        try {
            nNTPServerData.newslistDate = Calendar.getInstance().getTime();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.basis.dataDir() + "n" + nNTPServerData.activeFile));
            if (treeNode instanceof DefaultMutableTreeNode) {
                this.writeNode((DefaultMutableTreeNode)treeNode, bufferedWriter);
            } else {
                this.error();
            }
            bufferedWriter.close();
            this.sync.endWrite();
            return;
        }
        catch (Exception exception) {
            this.sync.endWrite();
            throw new IOException("Something went wrong writing file '" + this.basis.dataDir() + "n" + nNTPServerData.activeFile + ". Details:" + ErrorTools.redirect(exception));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeNode(DefaultMutableTreeNode defaultMutableTreeNode, BufferedWriter bufferedWriter) throws IOException {
        int n = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(1);
        try {
            this.writeNode(defaultMutableTreeNode, bufferedWriter, 0);
        }
        catch (IOException iOException) {
            Thread.currentThread().setPriority(n);
            throw iOException;
        }
        Thread.currentThread().setPriority(n);
        bufferedWriter.write("-1\n");
        bufferedWriter.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeNode(DefaultMutableTreeNode defaultMutableTreeNode, BufferedWriter bufferedWriter, int n) throws IOException {
        if (n == 3) {
            Thread.yield();
        }
        bufferedWriter.write(String.valueOf(n) + "\n");
        bufferedWriter.write((String)defaultMutableTreeNode.getUserObject() + "\n");
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 <= 0) return;
        try {
            Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            vector.addElement(defaultMutableTreeNode2);
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement((String)defaultMutableTreeNode2.getUserObject());
            int n3 = 1;
            while (n3 < n2) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3);
                String string = (String)defaultMutableTreeNode2.getUserObject();
                int n4 = 0;
                n4 = 0;
                while (n4 < n3) {
                    if (string.compareTo((String)vector2.elementAt(n4)) < 0) break;
                    ++n4;
                }
                vector.insertElementAt(defaultMutableTreeNode2, n4);
                vector2.insertElementAt(string, n4);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                this.writeNode((DefaultMutableTreeNode)vector.elementAt(n3), bufferedWriter, n + 1);
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            Basis.log("Internal error in NewsserverBase.writeNode()", exception);
            this.error();
        }
    }

    public NewsserverBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

