/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.database.GenericDatabase;
import net.ibm.malamut.newsmail.database.GroupBase;

public final class MsgidBase
extends GenericDatabase {
    public boolean exists(String string) {
        return super.containsKey(string);
    }

    public ArticleData get(String string) {
        Object object = super.get(string);
        if (!(object instanceof ArticleData) && object != null) {
            this.error();
            return null;
        }
        return (ArticleData)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getExpired(Vector vector, Date date, GroupBase groupBase) {
        Vector<String> vector2 = new Vector<String>();
        if (vector.size() == 0) {
            return vector2;
        }
        boolean bl = date == null;
        groupBase.sync().startRead();
        this.sync.startRead();
        Vector vector3 = groupBase.groups();
        Enumeration enumeration = this.data.keys();
        block2: while (enumeration.hasMoreElements()) {
            String string = null;
            ArticleData articleData = null;
            try {
                string = (String)enumeration.nextElement();
                articleData = this.get(string);
            }
            catch (ClassCastException classCastException) {
                this.error();
                continue;
            }
            boolean bl2 = bl;
            if (!bl2) {
                bl2 = articleData.received.before(date);
            }
            if (articleData.hold || !bl2) continue;
            long l = articleData.file;
            int n = 0;
            while (n < vector3.size()) {
                if (!vector.contains(vector3.elementAt(n))) continue block2;
                ++n;
            }
            vector2.addElement(string);
        }
        this.sync.endRead();
        groupBase.sync().endRead();
        return vector2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws IOException {
        if (!new File(this.basis.dataDir() + this.filename + "2").exists()) {
            this.data = this.basis.scanHashtableFile(this.filename, this.echoToScreen);
            return;
        }
        if (this.echoToScreen) {
            System.out.print("..." + this.filename + "2");
        }
        this.sync.startWrite();
        try {
            this.data = new Hashtable();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.basis.dataDir() + this.filename + "2"), 16384));
            while (true) {
                if (dataInputStream.available() <= 0) {
                    dataInputStream.close();
                    break;
                }
                String string = dataInputStream.readUTF();
                ArticleData articleData = new ArticleData();
                articleData.file = dataInputStream.readLong();
                articleData.received = new Date(dataInputStream.readLong());
                articleData.hold = dataInputStream.readBoolean();
                this.put(string, articleData);
            }
        }
        catch (IOException iOException) {
            this.sync.endWrite();
            throw iOException;
        }
        this.sync.endWrite();
    }

    public ArticleData put(String string, ArticleData articleData) {
        Object object = super.put(string, articleData);
        if (!(object instanceof ArticleData) && object != null) {
            this.error();
            return null;
        }
        return (ArticleData)object;
    }

    public void removeArticle(String string, GroupBase groupBase) {
        groupBase.sync().startWrite();
        this.sync.startWrite();
        if (this.containsKey(string)) {
            long l = this.get((String)string).file;
            this.data.remove(string);
            this.basis.repository().delete(l);
            groupBase.removeArticlesByMsgid(string);
        }
        this.sync.endWrite();
        groupBase.sync().endWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(boolean bl) throws IOException {
        if (bl) {
            System.out.print("..." + this.filename + "2");
        }
        this.sync.startRead();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.basis.dataDir() + this.filename + "2"), 16384));
            Enumeration enumeration = this.data.keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    dataOutputStream.close();
                    break;
                }
                String string = (String)enumeration.nextElement();
                ArticleData articleData = this.get(string);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeLong(articleData.file);
                dataOutputStream.writeLong(articleData.received.getTime());
                dataOutputStream.writeBoolean(articleData.hold);
            }
        }
        catch (IOException iOException) {
            this.sync.endRead();
            throw iOException;
        }
        this.sync.endRead();
    }

    public void tidyUp(GroupBase groupBase, Hashtable hashtable, TidyUpData tidyUpData) {
        groupBase.sync().startRead();
        this.sync.startWrite();
        Object object = new Object();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) {
                this.data.remove(k);
                this.error();
                continue;
            }
            String string = (String)k;
            long l = this.get((String)string).file;
            if (!this.basis.repository().exists(l)) {
                this.data.remove(string);
                ++tidyUpData.unavailable;
                continue;
            }
            if (!groupBase.containsMsgid(string)) continue;
            hashtable.put(new Long(l), object);
        }
        this.sync.endWrite();
        groupBase.sync().endRead();
    }

    public MsgidBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

