/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.database.GenericDatabase;

public final class GroupBase
extends GenericDatabase {
    public void add(String string, String string2) {
        this.sync.startRead();
        if (!this.data.containsKey(string)) {
            this.sync.startWrite();
            GroupData groupData = new GroupData();
            groupData.serverName = string2;
            groupData.added = Calendar.getInstance().getTime();
            this.put(string, groupData);
            this.sync.endWrite();
        } else if (string2 != null) {
            Object object = this.get(string);
            if (!(object instanceof GroupData)) {
                this.error();
                this.sync.endRead();
                return;
            }
            GroupData groupData = (GroupData)object;
            if (groupData.serverName == null) {
                this.sync.startWrite();
                groupData.serverName = string2;
                this.sync.endWrite();
            }
        }
        this.sync.endRead();
    }

    public void adjustPointers() {
        this.sync.startWrite();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof GroupData)) {
                this.error();
                break;
            }
            GroupData groupData = (GroupData)object;
            long l = groupData.lastArticle + 1L;
            Enumeration enumeration2 = groupData.articles.keys();
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                if (!(object instanceof Long)) {
                    this.error();
                    break;
                }
                long l2 = (Long)object;
                if (l2 >= l) continue;
                l = l2;
            }
            groupData.firstArticle = l;
        }
        this.sync.endWrite();
    }

    public boolean containsMsgid(String string) {
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof GroupData)) {
                this.error();
                break;
            }
            Hashtable hashtable = ((GroupData)v).articles;
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                if (!string.equals(enumeration2.nextElement())) continue;
                this.sync.endRead();
                return true;
            }
        }
        this.sync.endRead();
        return false;
    }

    public boolean exists(String string) {
        return this.containsKey(string);
    }

    public GroupData getData(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof GroupData) {
            return (GroupData)object;
        }
        this.error();
        return null;
    }

    public Vector groups() {
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        int n = this.data.size();
        this.sync.endRead();
        Vector vector = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) {
                this.error();
            } else {
                vector.addElement(k);
            }
            ++n2;
        }
        return vector;
    }

    public Vector isInGroups(String string) {
        this.sync.startRead();
        Vector vector = new Vector();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) {
                this.error();
                break;
            }
            Object v = this.data.get(k);
            if (!(v instanceof GroupData)) {
                this.error();
                break;
            }
            if (!((GroupData)v).articles.contains(string)) continue;
            vector.addElement(k);
        }
        this.sync.endRead();
        return vector;
    }

    public boolean isReadOnly(String string) {
        this.sync.startRead();
        GroupData groupData = this.getData(string);
        boolean bl = groupData == null ? false : !groupData.mayWrite;
        this.sync.endRead();
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws IOException {
        if (!new File(this.basis.dataDir() + this.filename + "2").exists()) {
            this.data = this.basis.scanHashtableFile(this.filename, this.echoToScreen);
            return;
        }
        if (this.echoToScreen) {
            System.out.print("..." + this.filename + "2");
        }
        this.sync.startWrite();
        try {
            this.data = new Hashtable<K, V>();
            var1_1 = new DataInputStream(new BufferedInputStream(new FileInputStream(this.basis.dataDir() + this.filename + "2"), 16384));
            block2: while (true) {
                block9: {
                    if (var1_1.available() <= 0) {
                        var1_1.close();
                        break;
                    }
                    var2_3 = var1_1.readUTF();
                    var3_4 = new GroupData();
                    var3_4.articles = new Hashtable<K, V>();
                    var3_4.serverName = var1_1.readUTF();
                    var3_4.lastArticle = var1_1.readLong();
                    var3_4.firstArticle = var1_1.readLong();
                    var3_4.holdTime = var1_1.readInt();
                    var3_4.holdNumber = var1_1.readInt();
                    var3_4.mayWrite = var1_1.readBoolean();
                    var3_4.added = new Date(var1_1.readLong());
                    var4_5 = var1_1.readInt();
                    if (var4_5 <= 0) break block9;
                    var3_4.articles = new Hashtable<K, V>(var4_5);
                    var5_6 = 0;
                    if (true) ** GOTO lbl47
                }
                var3_4.articles = new Hashtable<K, V>();
lbl31:
                // 2 sources

                while (true) {
                    this.put(var2_3, var3_4);
                    continue block2;
                    break;
                }
                break;
            }
        }
        catch (IOException var1_2) {
            this.sync.endWrite();
            throw var1_2;
        }
        this.sync.endWrite();
        return;
        do {
            var6_7 = new Long(var1_1.readLong());
            var7_8 = var1_1.readUTF();
            var3_4.articles.put(var6_7, var7_8);
            ++var5_6;
lbl47:
            // 2 sources

        } while (var5_6 < var4_5);
        ** while (true)
    }

    public void remove(String string) {
        super.remove(string);
    }

    public void removeArticlesByMsgid(String string) {
        this.sync.startWrite();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof GroupData)) {
                this.error();
                continue;
            }
            Hashtable hashtable = ((GroupData)v).articles;
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Object k = enumeration2.nextElement();
                if (!string.equals(hashtable.get(k))) continue;
                hashtable.remove(k);
            }
        }
        this.sync.endWrite();
    }

    public void removeServer(String string) {
        this.sync.startWrite();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof GroupData)) {
                this.error();
                break;
            }
            GroupData groupData = (GroupData)v;
            if (!string.equals(groupData.serverName)) continue;
            groupData.serverName = null;
        }
        this.sync.endWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(boolean bl) throws IOException {
        if (bl) {
            System.out.print("..." + this.filename + "2");
        }
        this.sync.startRead();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.basis.dataDir() + this.filename + "2"), 16384));
            Enumeration enumeration = this.data.keys();
            block2: while (true) {
                if (!enumeration.hasMoreElements()) {
                    dataOutputStream.close();
                    break;
                }
                String string = (String)enumeration.nextElement();
                GroupData groupData = (GroupData)this.get(string);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(groupData.serverName);
                dataOutputStream.writeLong(groupData.lastArticle);
                dataOutputStream.writeLong(groupData.firstArticle);
                dataOutputStream.writeInt(groupData.holdTime);
                dataOutputStream.writeInt(groupData.holdNumber);
                dataOutputStream.writeBoolean(groupData.mayWrite);
                dataOutputStream.writeLong(groupData.added.getTime());
                dataOutputStream.writeInt(groupData.articles.size());
                Enumeration enumeration2 = groupData.articles.keys();
                while (true) {
                    if (!enumeration2.hasMoreElements()) continue block2;
                    Long l = (Long)enumeration2.nextElement();
                    String string2 = (String)groupData.articles.get(l);
                    dataOutputStream.writeLong(l);
                    dataOutputStream.writeUTF(string2);
                }
                break;
            }
        }
        catch (IOException iOException) {
            this.sync.endRead();
            throw iOException;
        }
        this.sync.endRead();
    }

    public void setReadOnly(String string, boolean bl) {
        GroupData groupData = this.getData(string);
        if (groupData == null) {
            return;
        }
        this.sync.startWrite();
        groupData.mayWrite = !bl;
        this.sync.endWrite();
    }

    public void tidyUp(TidyUpData tidyUpData) {
        this.sync.startWrite();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof GroupData)) {
                this.error();
                break;
            }
            Hashtable hashtable = ((GroupData)v).articles;
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Long l = (Long)enumeration2.nextElement();
                String string = (String)hashtable.get(l);
                if (!this.basis.msgid().containsKey(string)) {
                    hashtable.remove(l);
                    ++tidyUpData.errors;
                    continue;
                }
                if (this.basis.repository().exists(this.basis.msgid().get((String)string).file)) continue;
                hashtable.remove(l);
            }
        }
        this.sync.endWrite();
    }

    public GroupBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

