/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Hashtable;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.WriteSynchronizer;

class GenericDatabase {
    protected Hashtable data;
    protected WriteSynchronizer sync;
    protected Basis basis;
    protected boolean echoToScreen;
    protected String filename;

    protected boolean containsKey(Object object) {
        this.sync.startRead();
        boolean bl = this.data.containsKey(object);
        this.sync.endRead();
        return bl;
    }

    protected void error() {
        Basis.log("Internal error: database inconsistence encountered in entity: " + this.filename + "\n" + ErrorTools.redirect(new Throwable()));
    }

    protected Object get(Object object) {
        this.sync.startRead();
        Object v = this.data.get(object);
        this.sync.endRead();
        return v;
    }

    public void load() throws IOException {
        this.data = this.basis.scanHashtableFile(this.filename, this.echoToScreen);
    }

    protected Object put(Object object, Object object2) {
        this.sync.startWrite();
        Object object3 = this.data.put(object, object2);
        this.sync.endWrite();
        return object3;
    }

    protected void remove(Object object) {
        this.sync.startWrite();
        this.data.remove(object);
        this.sync.endWrite();
    }

    public void save() throws IOException {
        this.save(this.echoToScreen);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(boolean bl) throws IOException {
        this.sync.startRead();
        try {
            this.basis.saveHashtableFile(this.data, this.filename, bl);
        }
        catch (IOException iOException) {
            this.sync.endRead();
            throw iOException;
        }
        this.sync.endRead();
    }

    public int size() {
        this.sync.startRead();
        int n = this.data.size();
        this.sync.endRead();
        return n;
    }

    public WriteSynchronizer sync() {
        return this.sync;
    }

    protected GenericDatabase() {
    }

    public GenericDatabase(Basis basis, String string, boolean bl) throws IOException {
        this.basis = basis;
        this.echoToScreen = bl;
        this.filename = string;
        this.sync = new WriteSynchronizer(basis);
        this.load();
    }
}

