/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.GatewayData;
import net.ibm.malamut.newsmail.database.GenericDatabase;
import net.ibm.malamut.newsmail.gateways.Gateway;

public final class GateBase
extends GenericDatabase {
    private Hashtable gatewayObjects = new Hashtable();

    public void create(String string, String string2) {
        GatewayData gatewayData = new GatewayData();
        gatewayData.type = string2;
        gatewayData.data = new Hashtable();
        this.put(string, gatewayData);
    }

    public boolean exists(String string) {
        return this.containsKey(string);
    }

    public Vector names() {
        Vector vector = new Vector();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                vector.addElement(k);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Gateway object(String string) {
        this.sync.startRead();
        if (!this.gatewayObjects.containsKey(string)) {
            Object v = this.data.get(string);
            if (!(v instanceof GatewayData)) {
                this.error();
                this.sync.endRead();
                return null;
            }
            GatewayData gatewayData = (GatewayData)v;
            Gateway gateway = null;
            this.sync.startWrite();
            try {
                gateway = (Gateway)Class.forName(gatewayData.type).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.sync.endWrite();
                this.sync.endRead();
                Basis.log("Internal error: Gateways Class '" + gatewayData.type + "' not found.");
                return null;
            }
            catch (Exception exception) {
                this.sync.endWrite();
                this.sync.endRead();
                Basis.log("Internal error: Class '" + gatewayData.type + "' is not a valid Gateway.");
                return null;
            }
            gateway.init(string, this.basis, gatewayData.data);
            this.gatewayObjects.put(string, gateway);
            this.sync.endWrite();
            this.sync.endRead();
            return gateway;
        }
        Object v = this.gatewayObjects.get(string);
        this.sync.endRead();
        if (v instanceof Gateway) {
            return (Gateway)v;
        }
        this.error();
        return null;
    }

    public void prepack() {
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = null;
            if (!(k instanceof String)) {
                this.error();
                break;
            }
            string = (String)k;
            Gateway gateway = this.object(string);
            gateway.prepack();
        }
        this.sync.endRead();
    }

    public void relaxObjects() {
        this.sync.startWrite();
        Enumeration enumeration = this.gatewayObjects.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof Gateway) {
                ((Gateway)v).relax();
                continue;
            }
            this.error();
        }
        this.gatewayObjects.clear();
        this.sync.endWrite();
    }

    public void remove(String string) {
        super.remove(string);
    }

    public void rename(String string, String string2) {
        if (this.exists(string2)) {
            this.sync.startWrite();
            this.data.put(string, this.data.get(string2));
            this.data.remove(string2);
            this.sync.endWrite();
        }
    }

    public GateBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

