/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.version.CommonConstants;

public final class WriteSynchronizer {
    private Basis basis;
    private Object lock = new Object();
    private Vector waiting = new Vector();
    private int writing = 0;
    private Thread writingThread = null;
    private Vector readers = new Vector();
    private int timeout = CommonConstants.debugL ? 30000 : 300000;

    private final void deadlockWarning() {
        Basis.log("Possible deadlock detected! Current stack:", new Throwable());
    }

    public void endRead() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            this.readers.removeElement(thread);
            this.lock.notifyAll();
        }
    }

    public void endWrite() {
        Object object = this.lock;
        synchronized (object) {
            --this.writing;
            if (this.writing == 0) {
                this.writingThread = null;
            }
            this.lock.notifyAll();
        }
    }

    private final boolean otherReaders(Thread thread) {
        int n = 0;
        while (n < this.readers.size()) {
            if (thread != this.readers.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRead() {
        var1_1 = this.lock;
        synchronized (var1_1) {
            var3_2 = Thread.currentThread();
            if (this.writing <= 0 || this.writingThread == var3_2) {
                this.readers.addElement(var3_2);
lbl7:
                // 2 sources

                return;
            }
            this.waiting.addElement(var3_2);
            var4_3 = Calendar.getInstance().getTime();
            if (true) ** GOTO lbl23
            do {
                try {
                    this.lock.wait(this.timeout);
                }
                catch (InterruptedException var5_5) {
                }
                var5_4 = Calendar.getInstance().getTime();
                if (var5_4.getTime() - var4_3.getTime() <= (long)this.timeout) continue;
                this.deadlockWarning();
lbl23:
                // 3 sources

            } while (this.writing > 0 || this.waiting.elementAt(0) != var3_2);
            this.waiting.removeElementAt(0);
            this.readers.addElement(var3_2);
            this.lock.notifyAll();
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startWrite() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.writingThread == thread) {
                ++this.writing;
            } else if (this.writing == 0 && !this.otherReaders(thread)) {
                this.writingThread = thread;
                this.writing = 1;
            } else {
                this.waiting.addElement(thread);
                Date date = Calendar.getInstance().getTime();
                while (true) {
                    Date date2;
                    if (this.writing <= 0 && !this.otherReaders(thread) && this.waiting.elementAt(0) == thread) {
                        this.waiting.removeElementAt(0);
                        this.writing = 1;
                        this.writingThread = thread;
                        this.lock.notifyAll();
                        break;
                    }
                    try {
                        this.lock.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    if ((date2 = Calendar.getInstance().getTime()).getTime() - date.getTime() <= (long)this.timeout) continue;
                    this.deadlockWarning();
                }
            }
            return;
        }
    }

    public WriteSynchronizer(Basis basis) {
        this.basis = basis;
    }
}

