/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.Connection;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.TextWaiter;

public final class SMTPCommand {
    public static final int UNKNOWN = 0;
    public static final int HELO = 1;
    public static final int MAIL = 2;
    public static final int RCPT = 3;
    public static final int DATA = 4;
    public static final int RSET = 5;
    public static final int NOOP = 6;
    public static final int QUIT = 7;
    public static final int HELP = 8;
    public static final int SEND = 9;
    public static final int SOML = 10;
    public static final int SAML = 11;
    public static final int VRFY = 12;
    public static final int EXPN = 13;
    public static final int TURN = 14;
    public static final int OK = 0;
    public static final int SYNTAX = 1;
    public static final int PARAMETER = 2;
    public static final int BAD_SEQUENCE = 3;
    public static final int UNIMPLEMENTED = 4;
    public static final int PARAMETER_UNIMPLEMENTED = 5;
    public static final int INIT_STATE = 0;
    public static final int MAIL_FROM_ACCEPTED = 1;
    public static final int MAIL_TO_ACCEPTED = 2;
    private Basis basis;
    private Connection conn;
    private String contents;
    private int code = 0;
    private int error = 0;
    private String domain = null;
    private int phase = 0;
    private String mailFrom = null;
    private Vector mailTo = new Vector();
    private String currentMailFrom = null;
    private String currentMailTo = null;

    public int code() {
        return this.code;
    }

    public void complain() throws IOException {
        switch (this.error) {
            case 1: {
                this.conn.writer().write("500 I did not recognize your command - probably a syntax error.\r\n");
                break;
            }
            case 2: {
                this.conn.writer().write("501 I had problems scanning the parameter(s) - probably a syntax error.\r\n");
                break;
            }
            case 4: {
                this.conn.writer().write("502 This command is not implemented. Sorry.\r\n");
                break;
            }
            case 3: {
                this.conn.writer().write("503 I didn't expect this command at this time.\r\n");
                break;
            }
            case 5: {
                this.conn.writer().write("504 This kind of parameter for this command is not implemented. Sorry.\r\n");
                break;
            }
        }
        this.conn.writer().flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException {
        BufferedWriter bufferedWriter = this.conn.writer();
        if (this.error != 0) {
            this.complain();
            return;
        }
        switch (this.code) {
            case 7: {
                bufferedWriter.write("221 " + Basis.hostname() + " Goodbye! Please do visit us again!\r\n");
                bufferedWriter.flush();
                return;
            }
            case 8: {
                bufferedWriter.write("214-This server implements the SMTP minimum standard.\r\n" + "214 Please consult RFC821 for details.\r\n");
                bufferedWriter.flush();
                return;
            }
            case 6: {
                bufferedWriter.write("250 Seems you have too much time. :)\r\n");
                bufferedWriter.flush();
                return;
            }
            case 5: {
                this.phase = 0;
                this.mailFrom = null;
                this.mailTo = new Vector();
                bufferedWriter.write("250 RESET command successfully executed.\r\n");
                bufferedWriter.flush();
                return;
            }
            case 1: {
                bufferedWriter.write("250 " + Basis.hostname() + " says hello! How can I help you?\r\n");
                bufferedWriter.flush();
                return;
            }
            case 2: {
                this.mailFrom = this.currentMailFrom;
                this.phase = 1;
                bufferedWriter.write("250 Please name the recipients.\r\n");
                bufferedWriter.flush();
                return;
            }
            case 3: {
                if (this.phase != 1 && this.phase != 2) {
                    this.error = 3;
                    this.complain();
                    return;
                }
                this.mailTo.addElement(this.currentMailTo);
                this.phase = 2;
                bufferedWriter.write("250 Whoever that is, we'll try to deliver the mail.\r\n");
                bufferedWriter.flush();
                return;
            }
            case 4: {
                if (this.phase != 2) {
                    this.error = 3;
                    this.complain();
                    return;
                }
                bufferedWriter.write("354 Please send your article now. End with <cr><lf>.<cr><lf>.\r\n");
                bufferedWriter.flush();
                ArticleData articleData = new ArticleData();
                articleData.file = this.basis.getNextArticleFile();
                articleData.received = Calendar.getInstance().getTime();
                MailDataWriter mailDataWriter = new MailDataWriter(this.basis.repository(), articleData.file);
                BufferedWriter bufferedWriter2 = mailDataWriter.getWriter();
                TextWaiter textWaiter = this.conn.textWaiter();
                boolean bl = textWaiter.getText(bufferedWriter2);
                mailDataWriter.close();
                try {
                    if (!bl) {
                        throw new IOException();
                    }
                    this.basis.addToOutmail(articleData.file, this.domain, this.mailFrom, this.mailTo);
                    bufferedWriter.write("250 Article successfully posted.\r\n");
                }
                catch (IOException iOException) {
                    this.basis.repository().delete(articleData.file);
                    bufferedWriter.write("554 Something went wrong. Sorry.\r\n");
                }
                bufferedWriter.flush();
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.error = 4;
                this.complain();
                return;
            }
        }
    }

    public SMTPCommand(SMTPCommand sMTPCommand, String string, Connection connection, Basis basis) {
        this.basis = basis;
        this.conn = connection;
        if (sMTPCommand != null) {
            this.phase = sMTPCommand.phase;
            this.mailFrom = sMTPCommand.mailFrom;
            this.mailTo = sMTPCommand.mailTo;
        }
        this.contents = string;
        if (string == null) {
            this.code = 7;
            return;
        }
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            string2 = string.toUpperCase();
        } else {
            string2 = string.substring(0, n).toUpperCase();
            string3 = string.substring(n + 1);
        }
        this.code = string2.equals("HELO") ? 1 : (string2.equals("MAIL") ? 2 : (string2.equals("RCPT") ? 3 : (string2.equals("DATA") ? 4 : (string2.equals("RSET") ? 5 : (string2.equals("NOOP") ? 6 : (string2.equals("QUIT") ? 7 : (string2.equals("HELP") ? 8 : (string2.equals("SEND") ? 9 : (string2.equals("SOML") ? 10 : (string2.equals("SAML") ? 11 : (string2.equals("VRFY") ? 12 : (string2.equals("EXPN") ? 13 : (string2.equals("TURN") ? 14 : 0)))))))))))));
        this.error = 0;
        switch (this.code) {
            case 0: {
                this.error = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (string3 == null) break;
                this.error = 2;
                break;
            }
            case 8: {
                if (string3 == null) break;
                this.error = 5;
                break;
            }
            case 1: {
                string3 = string3.trim();
                if (string3.indexOf(32) != -1) {
                    this.error = 2;
                    break;
                }
                this.domain = string3;
                break;
            }
            case 2: {
                string3 = string3.trim();
                if (string3.length() < "FROM:<>".length()) {
                    this.error = 2;
                    break;
                }
                if (string3.toUpperCase().startsWith("FROM:")) {
                    String string4 = string3.substring("FROM:".length()).trim();
                    if (string4.startsWith("<") && string4.endsWith(">")) {
                        this.currentMailFrom = string4.substring(1, string4.length() - 1);
                        break;
                    }
                    this.error = 2;
                    break;
                }
                this.error = 2;
                break;
            }
            case 3: {
                string3 = string3.trim();
                if (string3.length() < "TO:<>".length()) {
                    this.error = 2;
                    break;
                }
                if (string3.toUpperCase().startsWith("TO:")) {
                    String string5 = string3.substring("TO:".length()).trim();
                    if (string5.startsWith("<") && string5.endsWith(">")) {
                        this.currentMailTo = string5.substring(1, string5.length() - 1);
                        break;
                    }
                    this.error = 2;
                    break;
                }
                this.error = 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.error = 4;
                break;
            }
        }
    }
}

