/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.Connection;
import net.ibm.malamut.newsmail.MailDataReader;
import net.ibm.malamut.newsmail.database.PopMailboxBase;

public final class POPCommand {
    public static final int UNKNOWN = 0;
    public static final int QUIT = 1;
    public static final int USER = 2;
    public static final int PASS = 3;
    public static final int STAT = 4;
    public static final int LIST = 5;
    public static final int RETR = 6;
    public static final int DELE = 7;
    public static final int NOOP = 8;
    public static final int RSET = 9;
    public static final int APOP = 10;
    public static final int TOP = 11;
    public static final int UIDL = 12;
    private static final int AUTH = 1;
    private static final int TRANS = 2;
    private int code = 0;
    private int messageNumber = 0;
    private Basis basis;
    private Connection conn;
    private String contents;
    private boolean error = false;
    private int state = 1;
    private Vector deleted = new Vector();
    private String userName = null;
    private String passWord = null;
    private boolean lock = false;
    private PopMailboxBase mails;
    private int numberOfMails = 0;
    private long[] mailSizes;
    private long[] mailFiles;
    private long mailboxSize = 0L;

    public int code() {
        return this.code;
    }

    public void execute() throws IOException {
        BufferedWriter bufferedWriter = this.conn.writer();
        if (this.error) {
            bufferedWriter.write("-ERR I did not recognize your command - probably a syntax error.\r\n");
            bufferedWriter.flush();
            return;
        }
        switch (this.code) {
            case 1: {
                while (this.deleted.size() > 0) {
                    long l = this.mailFiles[(Integer)this.deleted.firstElement() - 1];
                    this.mails.remove(l);
                    this.basis.repository().delete(l);
                    this.deleted.removeElementAt(0);
                }
                if (this.mails.size() == 0 && this.userName != null) {
                    this.basis.removeUserFromPopmail(this.userName);
                }
                bufferedWriter.write("+OK Goodbye! Please do visit us again!\r\n");
                bufferedWriter.flush();
                break;
            }
            case 8: {
                bufferedWriter.write("+OK Doing nothing (as requested).\r\n");
                bufferedWriter.flush();
                break;
            }
            case 2: {
                if (this.state == 1) {
                    bufferedWriter.write("+OK User " + this.userName + ", please enter PASS password\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("-ERR Server isn't in AUTHENTICATION state anymore.\r\n");
                bufferedWriter.flush();
                break;
            }
            case 3: {
                if (this.state == 1) {
                    if (this.userName == null) {
                        bufferedWriter.write("-ERR Please identify yourself first.\r\n");
                        bufferedWriter.flush();
                        break;
                    }
                    if (!this.basis.lockPOPUserName(this.userName)) {
                        bufferedWriter.write("-ERR Your mailbox can't currently be accessed.\r\n");
                        bufferedWriter.flush();
                        break;
                    }
                    this.lock = true;
                    String string = this.basis.getPOPPassword(this.userName);
                    if (this.passWord.equals(string)) {
                        this.state = 2;
                        this.getMailboxInfo();
                        bufferedWriter.write("+OK Welcome user " + this.userName + ". You have " + this.numberOfMails + " mails (" + this.mailboxSize + " bytes).\r\n");
                        bufferedWriter.flush();
                        break;
                    }
                    bufferedWriter.write("-ERR You entered the wrong password.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("-ERR Server isn't in AUTHENTICATION state anymore.\r\n");
                bufferedWriter.flush();
                break;
            }
            case 9: {
                this.deleted.removeAllElements();
                bufferedWriter.write("+OK Server state reset.\r\n");
                bufferedWriter.flush();
                break;
            }
            case 7: {
                if (this.state != 2) {
                    bufferedWriter.write("-ERR Server is still in AUTHENTICATION state.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber < 1 || this.messageNumber > this.numberOfMails) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " doesn't exist.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.deleted.contains(new Integer(this.messageNumber))) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " has already been deleted.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                this.deleted.addElement(new Integer(this.messageNumber));
                bufferedWriter.write("+OK Message " + this.messageNumber + " deleted.\r\n");
                bufferedWriter.flush();
                break;
            }
            case 4: {
                if (this.state != 2) {
                    bufferedWriter.write("-ERR Server is still in AUTHENTICATION state.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("+OK " + this.numberOfMails + " " + this.mailboxSize + "\r\n");
                bufferedWriter.flush();
                break;
            }
            case 5: {
                if (this.state != 2) {
                    bufferedWriter.write("-ERR Server is still in AUTHENTICATION state.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber == 0) {
                    bufferedWriter.write("+OK " + this.numberOfMails + " messages are in your mailbox (" + this.mailboxSize + ")\r\n");
                    int n = 0;
                    while (n < this.numberOfMails) {
                        if (!this.deleted.contains(new Integer(this.messageNumber))) {
                            bufferedWriter.write(n + 1 + " " + this.mailSizes[n] + "\r\n");
                        }
                        ++n;
                    }
                    bufferedWriter.write(".\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber < 1 || this.messageNumber > this.numberOfMails) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " doesn't exist.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.deleted.contains(new Integer(this.messageNumber))) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " has been deleted.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("+OK " + this.messageNumber + " " + this.mailSizes[this.messageNumber - 1] + "\r\n");
                bufferedWriter.flush();
                break;
            }
            case 12: {
                if (this.state != 2) {
                    bufferedWriter.write("-ERR Server is still in AUTHENTICATION state.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber == 0) {
                    bufferedWriter.write("+OK " + this.numberOfMails + " messages are in your mailbox (" + this.mailboxSize + ")\r\n");
                    int n = 0;
                    while (n < this.numberOfMails) {
                        if (!this.deleted.contains(new Integer(this.messageNumber))) {
                            bufferedWriter.write(n + 1 + " " + this.mailFiles[n] + "\r\n");
                        }
                        ++n;
                    }
                    bufferedWriter.write(".\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber < 1 || this.messageNumber > this.numberOfMails) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " doesn't exist.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.deleted.contains(new Integer(this.messageNumber))) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " has been deleted.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("+OK " + this.messageNumber + " " + this.mailFiles[this.messageNumber - 1] + "\r\n");
                bufferedWriter.flush();
                break;
            }
            case 6: {
                if (this.state != 2) {
                    bufferedWriter.write("-ERR Server is still in AUTHENTICATION state.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.messageNumber < 1 || this.messageNumber > this.numberOfMails) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " doesn't exist.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                if (this.deleted.contains(new Integer(this.messageNumber))) {
                    bufferedWriter.write("-ERR Message " + this.messageNumber + " has been deleted.\r\n");
                    bufferedWriter.flush();
                    break;
                }
                bufferedWriter.write("+OK Message " + this.messageNumber + " (" + this.mailSizes[this.messageNumber - 1] + " bytes) follows.\r\n");
                bufferedWriter.flush();
                MailDataReader mailDataReader = new MailDataReader(this.basis.repository(), this.mailFiles[this.messageNumber - 1]);
                BufferedReader bufferedReader = mailDataReader.getReader();
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (string.startsWith(".")) {
                        bufferedWriter.write(".");
                    }
                    bufferedWriter.write(string + "\r\n");
                    string = bufferedReader.readLine();
                }
                bufferedWriter.write(".\r\n");
                bufferedWriter.flush();
                mailDataReader.close();
                break;
            }
        }
    }

    private final void getMailboxInfo() {
        this.mails = this.basis.getPOPMailboxForUser(this.userName);
        if (this.mails == null) {
            this.mails = PopMailboxBase.getEmptyMailbox(this.basis, this.userName);
        }
        this.mailFiles = this.mails.mails();
        this.numberOfMails = this.mailFiles.length;
        this.mailSizes = new long[this.numberOfMails];
        this.mailboxSize = 0L;
        int n = 0;
        while (n < this.numberOfMails) {
            this.mailSizes[n] = this.basis.repository().size(this.mailFiles[n]);
            this.mailboxSize += this.mailSizes[n];
            ++n;
        }
    }

    public void unlockMailbox() {
        if (this.lock) {
            this.lock = false;
            this.basis.unlockPOPUserName(this.userName);
        }
    }

    public String userName() {
        return this.userName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public POPCommand(Basis basis, String string, Connection connection, POPCommand pOPCommand) {
        this.basis = basis;
        if (pOPCommand != null) {
            this.deleted = pOPCommand.deleted;
            this.state = pOPCommand.state;
            this.userName = pOPCommand.userName;
            this.passWord = pOPCommand.passWord;
            this.lock = pOPCommand.lock;
            this.mails = pOPCommand.mails;
            this.numberOfMails = pOPCommand.numberOfMails;
            this.mailSizes = pOPCommand.mailSizes;
            this.mailFiles = pOPCommand.mailFiles;
            this.mailboxSize = pOPCommand.mailboxSize;
        }
        this.conn = connection;
        this.contents = string;
        if (string == null) {
            this.code = 1;
            return;
        }
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            string2 = string.toUpperCase();
        } else {
            string2 = string.substring(0, n).toUpperCase();
            string3 = string.substring(n + 1);
        }
        this.code = string2.equals("QUIT") ? 1 : (string2.equals("USER") ? 2 : (string2.equals("PASS") ? 3 : (string2.equals("LIST") ? 5 : (string2.equals("STAT") ? 4 : (string2.equals("RETR") ? 6 : (string2.equals("DELE") ? 7 : (string2.equals("NOOP") ? 8 : (string2.equals("RSET") ? 9 : (string2.equals("APOP") ? 10 : (string2.equals("TOP") ? 11 : (string2.equals("UIDL") ? 12 : 0)))))))))));
        switch (this.code) {
            case 0: {
                this.error = true;
                return;
            }
            case 10: {
                this.error = true;
                return;
            }
            case 11: {
                this.error = true;
                return;
            }
            case 2: {
                this.userName = string3;
                if (this.userName != null) return;
                this.error = true;
                return;
            }
            case 3: {
                this.passWord = string3;
                if (this.passWord != null) return;
                this.error = true;
                return;
            }
            case 6: 
            case 7: {
                try {
                    this.messageNumber = Integer.parseInt(string3);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    this.error = true;
                    return;
                }
            }
            case 5: 
            case 12: {
                if (string3 == null) {
                    this.messageNumber = 0;
                    return;
                }
                try {
                    this.messageNumber = Integer.parseInt(string3);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    this.error = true;
                    return;
                }
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                if (string3 == null) return;
                this.error = true;
                return;
            }
        }
    }
}

