/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.MailDataEntry;
import net.ibm.malamut.newsmail.WriteSynchronizer;

public final class MailDataRepository {
    private String basename;
    private String dataDir;
    private Basis basis;
    private Hashtable positions;
    private int repFileName = 0;
    private long maxFileSize;
    private boolean doRelax = false;
    private boolean automatic;
    private WriteSynchronizer sync;

    public Enumeration allFiles() {
        this.sync.startRead();
        Enumeration enumeration = this.positions.keys();
        this.sync.endRead();
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void backup(long l, File file) {
        if (file == null) {
            return;
        }
        File file2 = new File(file.getAbsolutePath(), this.basename + Long.toString(l));
        byte[] byArray = this.get(l);
        if (byArray == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            Basis.log("Couldn't backup file No." + l + ". Reason: " + ErrorTools.redirect(iOException));
        }
    }

    public Basis basis() {
        return this.basis;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compress() {
        this.sync.startWrite();
        this.doRelax = true;
        try {
            File file = new File(this.dataDir);
            String[] stringArray = file.list();
            Vector<Integer> vector = new Vector<Integer>();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.toLowerCase().startsWith(this.basename.toLowerCase())) {
                    vector.addElement(new Integer(string.substring(3)));
                }
                ++n;
            }
            Hashtable hashtable = new Hashtable();
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                Object object;
                int n5 = (Integer)vector.elementAt(n3);
                Vector<MailDataEntry> vector2 = new Vector<MailDataEntry>();
                Vector vector3 = new Vector();
                int n6 = 0;
                Object object2 = this.positions.keys();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    MailDataEntry mailDataEntry = (MailDataEntry)this.positions.get(object);
                    if (mailDataEntry.repository != n5) continue;
                    n4 = 0;
                    while (n4 < n6 && mailDataEntry.start > ((MailDataEntry)vector2.elementAt((int)n4)).start) {
                        ++n4;
                    }
                    vector2.insertElementAt(mailDataEntry, n4);
                    vector3.insertElementAt(object, n4);
                    ++n6;
                }
                new File(this.dataDir + this.basename + n5).renameTo(new File(this.dataDir + this.basename + "temp"));
                object2 = new FileOutputStream(this.dataDir + this.basename + n5);
                object = new FileInputStream(this.dataDir + this.basename + "temp");
                int n7 = 0;
                n4 = 0;
                int n8 = 0;
                while (n8 < n6) {
                    MailDataEntry mailDataEntry = (MailDataEntry)vector2.elementAt(n8);
                    ((FileInputStream)object).skip(mailDataEntry.start - n4);
                    byte[] byArray = new byte[mailDataEntry.length];
                    ((FileInputStream)object).read(byArray);
                    ((FileOutputStream)object2).write(byArray);
                    n4 = mailDataEntry.start + mailDataEntry.length;
                    mailDataEntry.start = n7;
                    n7 += mailDataEntry.length;
                    hashtable.put(vector3.elementAt(n8), mailDataEntry);
                    ++n8;
                }
                ((FileOutputStream)object2).close();
                ((FileInputStream)object).close();
                new File(this.dataDir + this.basename + "temp").delete();
                ++n3;
            }
            this.positions = hashtable;
            this.updateRepFile();
        }
        catch (IOException iOException) {
            Basis.log("Database error while compressing repository: " + ErrorTools.redirect(iOException));
        }
        this.sync.endWrite();
    }

    public long databaseSize() {
        this.sync.startRead();
        long l = 0L;
        File file = new File(this.dataDir);
        String[] stringArray = file.list();
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.toLowerCase().startsWith(this.basename.toLowerCase())) {
                l += new File(this.dataDir + string).length();
            }
            ++n;
        }
        this.sync.endRead();
        return l;
    }

    public void delete(long l) {
        this.sync.startWrite();
        this.positions.remove(new Long(l));
        this.doRelax = true;
        this.sync.endWrite();
    }

    public boolean exists(long l) {
        this.sync.startRead();
        boolean bl = this.positions.containsKey(new Long(l));
        this.sync.endRead();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            if (this.doRelax) {
                this.relax();
            }
        }
        catch (IOException iOException) {
            Basis.log("An eror occurred while saving the database repository", iOException);
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] get(long l) {
        this.sync.startRead();
        Object v = this.positions.get(new Long(l));
        if (v == null) {
            this.sync.endRead();
            return null;
        }
        MailDataEntry mailDataEntry = (MailDataEntry)v;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.dataDir + this.basename + mailDataEntry.repository);
            fileInputStream.skip(mailDataEntry.start);
            byte[] byArray = new byte[mailDataEntry.length];
            fileInputStream.read(byArray);
            fileInputStream.close();
            this.sync.endRead();
            return byArray;
        }
        catch (IOException iOException) {
            this.sync.endRead();
            Basis.log("Database error: couldn't read file No." + l);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadPositions(boolean bl) throws IOException {
        String string = "m-" + this.basename + "re2";
        if (bl) {
            System.out.print("..." + string);
        }
        this.positions = new Hashtable();
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.dataDir + string), 16384));
            while (true) {
                if (dataInputStream.available() <= 0) {
                    dataInputStream.close();
                    return;
                }
                Long l = new Long(dataInputStream.readLong());
                MailDataEntry mailDataEntry = new MailDataEntry();
                mailDataEntry.repository = dataInputStream.readInt();
                mailDataEntry.start = dataInputStream.readInt();
                mailDataEntry.length = dataInputStream.readInt();
                this.positions.put(l, mailDataEntry);
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong reading file '" + this.dataDir + string + "':\n" + ErrorTools.redirect(exception));
        }
    }

    public int numberOfMails() {
        this.sync.startRead();
        int n = this.positions.size();
        this.sync.endRead();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean put(long l, byte[] byArray) {
        this.sync.startWrite();
        if (this.exists(l)) {
            this.sync.endWrite();
            return false;
        }
        this.doRelax = true;
        MailDataEntry mailDataEntry = new MailDataEntry();
        File file = new File(this.dataDir + this.basename + this.repFileName);
        mailDataEntry.repository = this.repFileName;
        mailDataEntry.start = (int)file.length();
        mailDataEntry.length = byArray.length;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.dataDir + this.basename + this.repFileName, true);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            this.positions.put(new Long(l), mailDataEntry);
            this.updateRepFile();
            this.sync.endWrite();
            return true;
        }
        catch (IOException iOException) {
            this.sync.endWrite();
            Basis.log("Database error: couldn't write to file No." + l);
            return false;
        }
    }

    public void relax() throws IOException {
        this.relax(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void relax(boolean bl) {
        this.sync.startWrite();
        if (!this.doRelax) {
            this.sync.endWrite();
            return;
        }
        this.doRelax = false;
        try {
            this.savePositions(!bl);
        }
        catch (IOException iOException) {
            Basis.log("Database error: couldn't save Repository '" + this.basename + "'. Reason: " + ErrorTools.redirect(iOException));
        }
        this.sync.endWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void savePositions(boolean bl) throws IOException {
        String string = "m-" + this.basename + "re2";
        if (bl) {
            System.out.print("..." + string);
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataDir + string), 16384));
            Enumeration enumeration = this.positions.keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    dataOutputStream.close();
                    return;
                }
                Long l = (Long)enumeration.nextElement();
                MailDataEntry mailDataEntry = (MailDataEntry)this.positions.get(l);
                dataOutputStream.writeLong(l);
                dataOutputStream.writeInt(mailDataEntry.repository);
                dataOutputStream.writeInt(mailDataEntry.start);
                dataOutputStream.writeInt(mailDataEntry.length);
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong writing file '" + this.dataDir + string + "':\n" + ErrorTools.redirect(exception));
        }
    }

    public long size(long l) {
        this.sync.startRead();
        Object v = this.positions.get(new Long(l));
        this.sync.endRead();
        if (v == null) {
            return 0;
        }
        return ((MailDataEntry)v).length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateRepFile() {
        File file;
        do {
            if (!(file = new File(this.dataDir + this.basename + this.repFileName)).exists()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                }
                catch (IOException iOException) {
                }
            }
            ++this.repFileName;
        } while (file.length() > this.maxFileSize);
        --this.repFileName;
    }

    public MailDataRepository(String string, Basis basis, long l, boolean bl) throws IOException {
        this.basename = string;
        this.automatic = bl;
        this.basis = basis;
        this.sync = new WriteSynchronizer(basis);
        this.dataDir = basis.dataDir();
        this.maxFileSize = l;
        if (new File(this.dataDir + "m-" + string + "re2").exists()) {
            this.loadPositions(!bl);
        } else {
            this.positions = basis.scanHashtableFile("m-" + string + "rep", !bl);
        }
        this.updateRepFile();
    }
}

