/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.IOException;
import java.net.SocketException;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ui.Shell;

public abstract class GenericServer
extends Thread {
    protected Basis basis;
    protected boolean doFinalize = true;
    protected Object readyMonitor = new Object();
    protected boolean ready = false;
    protected boolean ok = false;
    protected Object continueMonitor = new Object();
    protected boolean doContinue = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() throws Throwable {
        if (this.doFinalize) {
            try {
                this.basis.relax();
            }
            catch (IOException iOException) {
            }
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initSucceeded() {
        Object object = this.readyMonitor;
        synchronized (object) {
            try {
                while (!this.ready) {
                    this.readyMonitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            return this.ok;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        try {
            object = this.readyMonitor;
            synchronized (object) {
                this.ready = true;
                this.ok = true;
                this.readyMonitor.notifyAll();
            }
            this.serve();
        }
        catch (IOException iOException) {
            Shell.error("Starting Server", "Couldn't establish connection, shutting down", iOException);
        }
        object = this.readyMonitor;
        synchronized (object) {
            this.ready = true;
            this.ok = false;
            this.readyMonitor.notifyAll();
            return;
        }
    }

    public abstract void serve() throws IOException, SocketException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        Object object = this.continueMonitor;
        synchronized (object) {
            this.doContinue = false;
        }
        object = this.readyMonitor;
        synchronized (object) {
            while (this.ready) {
                if (!this.ok) {
                    return;
                }
                try {
                    this.readyMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }

    public GenericServer() throws IOException {
        this.basis = new Basis();
    }

    public GenericServer(String string) throws IOException {
        this.basis = new Basis(string);
    }

    public GenericServer(Basis basis) {
        this.basis = basis;
        this.doFinalize = false;
    }
}

