/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.IOException;
import java.net.Socket;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.TriggerWaiter;

public final class ConnectionFactory
extends Thread {
    private String server;
    private int port;
    private int timeout;
    private boolean abort = false;
    private Socket socket = null;
    private Exception error = null;
    private TriggerWaiter tw = new TriggerWaiter();

    public void abort() {
        this.abort = true;
        this.stop();
        this.tw.abort();
    }

    public Socket connect() throws IOException {
        this.start();
        this.tw.waitForTrigger(this.timeout);
        TriggerWaiter triggerWaiter = this.tw;
        synchronized (triggerWaiter) {
            if (this.error != null) {
                throw new IOException("Could not connect to Server: " + this.server + ". Reason: " + ErrorTools.redirect(this.error));
            }
            if (this.socket == null && !this.abort) {
                throw new IOException("Attempt to connect to Server: " + this.server + " aborted due to timeout");
            }
            Socket socket = this.socket;
            Object var2_3 = null;
            return socket;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Socket socket = new Socket(this.server, this.port);
            TriggerWaiter triggerWaiter = this.tw;
            synchronized (triggerWaiter) {
                this.socket = socket;
            }
        }
        catch (Exception exception) {
            this.error = exception;
        }
        this.tw.doTrigger();
    }

    public ConnectionFactory(String string, int n, int n2) {
        this.server = string;
        this.port = n;
        this.timeout = n2 * 1000;
    }
}

