/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.ibm.malamut.newsmail.ActiveData;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.ArticleRetriever;
import net.ibm.malamut.newsmail.Connection;
import net.ibm.malamut.newsmail.ConnectionData;
import net.ibm.malamut.newsmail.EchoWriter;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.ExtendedConnectionInterruptor;
import net.ibm.malamut.newsmail.GenericAnswer;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.GroupEntry;
import net.ibm.malamut.newsmail.IntWrapper;
import net.ibm.malamut.newsmail.LineWaiter;
import net.ibm.malamut.newsmail.MailDataReader;
import net.ibm.malamut.newsmail.MailDataRepository;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.NNTPAnswer;
import net.ibm.malamut.newsmail.OptionsData;
import net.ibm.malamut.newsmail.OutmailData;
import net.ibm.malamut.newsmail.POPUserData;
import net.ibm.malamut.newsmail.RFCAnalyzer;
import net.ibm.malamut.newsmail.SMTPAnswer;
import net.ibm.malamut.newsmail.StartStop;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.database.ConnectionBase;
import net.ibm.malamut.newsmail.database.GateBase;
import net.ibm.malamut.newsmail.database.GroupBase;
import net.ibm.malamut.newsmail.database.MsgidBase;
import net.ibm.malamut.newsmail.database.NewsserverBase;
import net.ibm.malamut.newsmail.database.OutgoingBase;
import net.ibm.malamut.newsmail.database.OutmailBase;
import net.ibm.malamut.newsmail.database.PopMailboxBase;
import net.ibm.malamut.newsmail.database.PopServerBase;
import net.ibm.malamut.newsmail.database.PopUserBase;
import net.ibm.malamut.newsmail.database.PopmailBase;
import net.ibm.malamut.newsmail.database.SmtpServerBase;
import net.ibm.malamut.newsmail.database.WindowBase;
import net.ibm.malamut.newsmail.gateways.JanusGate;
import net.ibm.malamut.newsmail.ui.CommProgressWindow;
import net.ibm.malamut.newsmail.ui.ProgressBarPanel;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.version.CommonConstants;

public final class Basis
implements ExtendedConnectionInterruptor {
    private static final String CONFIG_FILE_HEADER = "Kroni's News & Mail - config file";
    private static long memoryUsed = 0L;
    public static final int ALL = 0;
    public static final int NNTP = 1;
    public static final int POP = 2;
    public static final int SMTP = 3;
    public static final int GATE = 4;
    public static final int SOLO = 5;
    public static final String FILE_NEWSSERVER = "newsserver";
    public static final String FILE_REPOSITORY_PREFIX = "mdr";
    public static final String FILE_PREPACK_PREFIX = "ppk";
    public static final String FILE_OUTMAIL = "outmail";
    public static final String FILE_POPMAIL = "popmail";
    public static final String FILE_OUTGOING = "outgoing";
    public static final String FILE_GROUPS = "groups";
    public static final String FILE_LAST = "last";
    public static final String FILE_LOCK = "lock";
    public static final String FILE_MSGID = "msgid";
    public static final String FILE_SMTPSERVER = "smtpserver";
    public static final String FILE_POPSERVER = "popserver";
    public static final String FILE_GATEWAYS = "gateways";
    public static final String FILE_WINDOWS = "winpos";
    public static final String FILE_CONFIG = ".knewsmail";
    public static final String DIR_CONFIG = ".knewsmaildir";
    public static final String FILE_NEWSGROUPLISTTEMP = "nlist.temp";
    private static String hostname;
    private static BufferedWriter logWriter;
    private String dataDir;
    private int readThreads;
    private int artRetries;
    private int timeout;
    private int failureAllowed;
    private int maxRepositoryFileSize;
    private MailDataRepository repository;
    private MailDataRepository prepack;
    private NewsserverBase newsserver;
    private SmtpServerBase smtpserver;
    private PopServerBase popserver;
    private GateBase gateways;
    private GroupBase groups;
    private MsgidBase msgid;
    private OutgoingBase outgoing;
    private OutmailBase outmail;
    private PopmailBase popmail;
    private WindowBase windowData;
    private long lastNumber;
    private boolean sendToAll;
    private boolean forwardAll;
    private boolean saveWindowPos;
    private boolean deleteWindowPos;
    private int defaultFont;
    private String configFileName;
    private String superuserAddress;
    private String superuserPassword;
    private FileOutputStream lock;
    private boolean doRelax;
    private Vector lockedPOPUserNames;
    private ConnectionBase connections;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addGroupsToNode(TreeNode treeNode, BufferedReader bufferedReader, ProgressBarPanel progressBarPanel, int n) {
        int n2 = Shell.progressGranularity();
        int n3 = 0;
        progressBarPanel.setArea(0, n);
        progressBarPanel.setText("Analyzing newsgroup list...");
        try {
            String string = bufferedReader.readLine();
            progressBarPanel.setValue(1);
            while (string != null) {
                int n4 = string.indexOf(" ");
                if (n4 != -1) {
                    Object object;
                    String string2 = string.substring(0, n4);
                    TreeNode treeNode2 = treeNode;
                    while ((n4 = string2.indexOf(".")) != -1) {
                        TreeNode treeNode3;
                        object = string2.substring(0, n4) + ".*";
                        string2 = string2.substring(n4 + 1);
                        Enumeration<? extends TreeNode> enumeration = treeNode2.children();
                        boolean bl = false;
                        while (enumeration.hasMoreElements()) {
                            treeNode3 = enumeration.nextElement();
                            if (!((String)object).equals(treeNode3.toString())) continue;
                            bl = true;
                            treeNode2 = treeNode3;
                        }
                        if (bl) continue;
                        treeNode3 = new DefaultMutableTreeNode(object);
                        ((DefaultMutableTreeNode)treeNode2).add((MutableTreeNode)treeNode3);
                        treeNode2 = treeNode3;
                    }
                    object = new GroupEntry(string2, string.charAt(string.length() - 1) == 'y');
                    ((DefaultMutableTreeNode)treeNode2).add(new DefaultMutableTreeNode(string2));
                }
                string = bufferedReader.readLine();
                if (++n3 % n2 != 0) continue;
                progressBarPanel.setValue(n3);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("This can't happen: IOException while reading from a StreamReader.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ((DefaultMutableTreeNode)treeNode).removeAllChildren();
            ((DefaultMutableTreeNode)treeNode).setUserObject("Out of Memory");
            Basis.memoryFullAlert("While scanning newgroup list");
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This can't happen: ClassCastException while building TreeList.");
        }
        Basis.memoryAlert("After scanning newsgroup list");
    }

    public void addMsgid(String string, ArticleData articleData) {
        this.msgid.put(string, articleData);
    }

    public void addNewsgroup(String string, String string2, boolean bl) throws IOException {
        string = string.toLowerCase();
        this.groups.add(string, string2);
        if (string2 != null) {
            if (!this.newsserver.exists(string2)) {
                throw new IOException("Internal Error: Newsserver '" + string2 + "' doesn't exist.");
            }
            Hashtable hashtable = this.getActiveGroups(string2);
            if (!hashtable.containsKey(string)) {
                ActiveData activeData = new ActiveData();
                activeData.writeAllowed = bl;
                activeData.lastArticle = 0L;
                hashtable.put(string, activeData);
                this.putActiveGroups(string2, hashtable);
            }
        }
    }

    public void addToOutmail(long l, String string, String string2, Vector vector) {
        String string3;
        Hashtable hashtable = new Hashtable();
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            string3 = (String)vector.elementAt(n2);
            String string4 = this.getSMTPServerForPath(string3);
            if (string4 == null) {
                vector2.addElement("No route to path: " + string3);
            } else if (hashtable.containsKey(string4)) {
                ((Vector)hashtable.get(string4)).addElement(string3);
            } else {
                Vector<String> vector3 = new Vector<String>();
                vector3.addElement(string3);
                hashtable.put(string4, vector3);
            }
            ++n2;
        }
        if (vector2.size() > 0) {
            this.outmailFailure(l, string, string2, vector2);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            this.addToOutmail(l, string, string2, (Vector)hashtable.get(string3), string3);
        }
    }

    private final void addToOutmail(long l, String string, String string2, Vector vector, String string3) {
        Date date = Calendar.getInstance().getTime();
        OutmailData outmailData = new OutmailData();
        outmailData.date = Calendar.getInstance().getTime();
        outmailData.server = string3;
        outmailData.from = string2;
        outmailData.to = vector;
        outmailData.fromHost = string;
        this.outmail.add(outmailData, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addToOutnews(String string, String string2) {
        Vector vector = this.groups.isInGroups(string);
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = this.newsserver.servers();
        int n = 0;
        while (n < vector3.size()) {
            boolean bl;
            String string3 = (String)vector3.elementAt(n);
            boolean bl2 = bl = string2 == null;
            if (!bl) {
                bl = string2.equals(string3);
            }
            if (bl) {
                try {
                    Hashtable hashtable = this.getActiveGroups(string3);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        if (hashtable.containsKey(vector.elementAt(n2)) && ((ActiveData)hashtable.get(vector.elementAt((int)n2))).writeAllowed) {
                            vector2.addElement(string3);
                            n2 = vector.size();
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    Basis.log("Database error:\n" + ErrorTools.redirect(exception));
                }
            }
            ++n;
        }
        if (vector2.size() > 0) {
            this.outgoing.put(string, vector2);
        }
    }

    public boolean addToReplyPath(long l) throws IOException {
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        MailDataReader mailDataReader = new MailDataReader(this.repository, l);
        BufferedReader bufferedReader = mailDataReader.getReader();
        String string = bufferedReader.readLine();
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            string = bufferedReader.readLine();
        }
        bufferedWriter.close();
        mailDataReader.close();
        bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
        bufferedWriter = mailDataWriter.getWriter();
        string = bufferedReader.readLine();
        if (string == null) {
            string = "";
        }
        while (!string.equals("")) {
            if (string.startsWith("Path: ")) {
                bl = true;
                if (string.equals("Path: ")) {
                    bufferedWriter.write("Path: " + hostname);
                } else {
                    bufferedWriter.write("Path: " + hostname + "!" + string.substring("Path: ".length()));
                }
                bufferedWriter.newLine();
            } else {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            string = bufferedReader.readLine();
            if (string != null) continue;
            string = "";
        }
        if (!bl) {
            bufferedWriter.write("Path: " + hostname + "!not-for-mail");
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        string = bufferedReader.readLine();
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            string = bufferedReader.readLine();
        }
        mailDataWriter.close();
        bufferedReader.close();
        return bl;
    }

    private final Vector analyzeAddress(String string) {
        int n;
        int n2;
        Vector<String> vector = new Vector<String>();
        do {
            int n3;
            int n4 = n2 = (n3 = string.lastIndexOf(46)) > (n = string.lastIndexOf(64)) ? n3 : n;
            if (n2 == -1) {
                if (string.length() > 0) {
                    vector.addElement(string);
                }
                return vector;
            }
            if (n2 == string.length() - 1) {
                vector.addElement("");
            } else {
                vector.addElement(string.substring(n2 + 1));
            }
            string = string.substring(0, n2);
        } while (n2 != n);
        vector.addElement("@");
        vector.addElement(string);
        return vector;
    }

    public void changeXrefLine(long l, String string) throws IOException {
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        MailDataReader mailDataReader = new MailDataReader(this.repository, l);
        BufferedReader bufferedReader = mailDataReader.getReader();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            string2 = bufferedReader.readLine();
        }
        bufferedWriter.close();
        mailDataReader.close();
        bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
        bufferedWriter = mailDataWriter.getWriter();
        string2 = bufferedReader.readLine();
        if (string2 == null) {
            string2 = "";
        }
        while (!string2.equals("")) {
            if (!string2.toLowerCase().startsWith("xref: ")) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            if ((string2 = bufferedReader.readLine()) != null) continue;
            string2 = "";
        }
        if (!bl) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            string2 = bufferedReader.readLine();
        }
        mailDataWriter.close();
        bufferedReader.close();
    }

    private final int compareDomains(Vector vector, Vector vector2) {
        int n = 0;
        while (vector.size() > n && vector2.size() > n) {
            if (!((String)vector.elementAt(n)).equals((String)vector2.elementAt(n))) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public void contactGate(CommProgressWindow commProgressWindow, String string) {
        this.gateways.object(string).contact(commProgressWindow);
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    public void contactGates(CommProgressWindow commProgressWindow) {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 3);
            n = this.gateways.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.gateways.names();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Sending mail to gateway: " + string);
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.contactGate(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    private final void createConfigFile(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        this.dataDir = System.getProperty("user.home") + System.getProperty("file.separator") + ".knewsmaildata" + System.getProperty("file.separator");
        File file = new File(this.dataDir);
        file.mkdirs();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataDir + FILE_LAST));
        objectOutputStream.writeObject(new Long(0L));
        objectOutputStream.writeObject(new Boolean(false));
        objectOutputStream.close();
        this.writeConfigFile();
    }

    public void createGateway(String string, String string2) {
        if (this.gateways.exists(string)) {
            Shell.info("Create new Gateway", "A gateway with the title " + string + " already exists.");
            return;
        }
        this.gateways.create(string, string2);
    }

    public void createNewsserver(String string, String string2) throws IOException {
        if (this.newsserver.titles().contains(string2)) {
            throw new IOException("There already exists a newsserver titled '" + string2 + "'.");
        }
        this.newsserver.create(string, string2);
    }

    public void createPOPServer(String string, String string2) throws IOException {
        if (this.popserver.titles().contains(string2)) {
            throw new IOException("There already exists a pop server titled '" + string2 + "'.");
        }
        if (this.popserver.exists(string)) {
            return;
        }
        this.popserver.create(string, string2);
    }

    public void createSMTPServer(String string, String string2) throws IOException {
        if (this.smtpserver.titles().contains(string2)) {
            throw new IOException("There already exists an smtp server titled '" + string2 + "'.");
        }
        if (this.smtpserver.exists(string)) {
            return;
        }
        this.smtpserver.create(string, string2);
    }

    public String dataDir() {
        return this.dataDir;
    }

    public void editGateway(String string, String string2) {
        if (this.gateways.exists(string2)) {
            Shell.info("Edit Gateway", "A gateway with the title " + string2 + " already exists.");
            return;
        }
        if (!this.gateways.exists(string)) {
            Shell.info("Edit Gateway", "A gateway with the title " + string + " doesn't exist.");
            return;
        }
        this.gateways.rename(string2, string);
    }

    public void editNewsserver(String string, String string2) throws IOException {
        if (this.newsserver.title(string).equals(string2)) {
            return;
        }
        if (this.newsserver.titles().contains(string2)) {
            throw new IOException("There already exists another newsserver titled '" + string2 + "'.");
        }
        this.newsserver.rename(string, string2);
    }

    public void editPOPServer(String string, String string2) throws IOException {
        if (this.popserver.titles().contains(string2)) {
            throw new IOException("There already exists another pop server titled '" + string2 + "'.");
        }
        this.popserver.newTitle(string, string2);
    }

    public void editPOPUser(String string, String string2, POPUserData pOPUserData, PopUserBase popUserBase) {
        this.popmail.changeUserName(string, string2);
        popUserBase.remove(string);
        popUserBase.addUser(string2, pOPUserData);
    }

    public void editSMTPServer(String string, String string2) throws IOException {
        if (this.smtpserver.titles().contains(string2)) {
            throw new IOException("There already exists another smtp server titled '" + string2 + "'.");
        }
        this.smtpserver.newTitle(string, string2);
    }

    public boolean existsMsgid(String string) {
        return this.msgid.exists(string);
    }

    public boolean existsNewsgroup(String string) {
        return this.groups.exists(string.toLowerCase());
    }

    private final void extractNewsgroups(Vector vector, String string) {
        int n;
        String string2 = string;
        while ((n = string2.indexOf(44)) != -1) {
            String string3 = string2.substring(0, n).trim();
            string2 = string2.substring(n + 1);
            if (string3.equals("")) continue;
            vector.addElement(string3);
        }
        if (!(string2 = string2.trim()).equals("")) {
            vector.addElement(string2);
        }
    }

    public String fakeMsgid(boolean bl) {
        String string = new Long(Math.abs(Calendar.getInstance().getTime().getTime())).toString();
        string = string + "." + new Long(Math.abs(new Random(this.lastNumber).nextLong())).toString();
        string = bl ? string + "@knm-MID-fill-in." + hostname : string + "@knm." + hostname;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.doRelax) return;
            this.relax();
            return;
        }
        catch (IOException iOException) {
            Basis.log("An error occurred while saving the database", iOException);
        }
    }

    public GateBase gates() {
        return this.gateways;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gatewayHasMail(long l, Hashtable hashtable) {
        String string;
        String string2;
        Vector<Object> vector;
        Object object;
        if (hashtable.containsKey("To")) {
            object = hashtable.get("To");
            if (object instanceof Vector) {
                vector = (Vector)object;
            } else {
                vector = new Vector<Object>();
                vector.addElement(object);
            }
            string2 = this.superuserAddress.toLowerCase();
            int n = 0;
            while (n < vector.size()) {
                if (((String)vector.elementAt(n)).toLowerCase().trim().startsWith(string2)) {
                    this.popmail.newMail("postmaster", l);
                    break;
                }
                ++n;
            }
            string = hostname;
            String string3 = (String)hashtable.get("From");
            if (hashtable.containsKey("X-ZC-" + "ERR") || hashtable.containsKey("X-ZC-" + "Stat")) {
                string3 = "";
            }
            this.addToOutmail(l, string, string3, vector);
        }
        if (!hashtable.containsKey("Newsgroups")) return;
        vector = this.getGroupsForArticle(l);
        object = new Vector();
        string2 = null;
        try {
            string2 = this.getMsgId(l, false, false);
        }
        catch (IOException iOException) {
            Basis.log("Unexpected Exception on Message-ID while sorting file No. " + l + " from gateway into newsserver database:\n" + ErrorTools.redirect(iOException));
        }
        if (this.msgid.exists(string2)) return;
        string = "Xref: " + Basis.hostname() + " ";
        int n = 0;
        while (n < vector.size()) {
            String string4 = (String)vector.elementAt(n);
            GroupData groupData = this.getGroupData(string4);
            if (groupData != null) {
                this.groups.sync().startWrite();
                ++groupData.lastArticle;
                groupData.articles.put(new Long(groupData.lastArticle), string2);
                this.groups.sync().endWrite();
                string = string + string4 + ":" + groupData.lastArticle;
            } else {
                ((Vector)object).addElement(string4);
            }
            ++n;
        }
        if (((Vector)object).size() > 0) {
            this.outnewsFailure(l, (String)hashtable.get("From"), (Vector)object, true);
        }
        ArticleData articleData = new ArticleData();
        articleData.file = l;
        articleData.received = Calendar.getInstance().getTime();
        this.addMsgid(string2, articleData);
        this.addToOutnews(string2, null);
        try {
            this.changeXrefLine(articleData.file, string);
            this.addToReplyPath(l);
            return;
        }
        catch (IOException iOException) {
            Basis.log("Unexpected Exception on modifying headers after sorting file No. " + l + " from gateway into newsserver database: " + ErrorTools.redirect(iOException));
        }
    }

    public Hashtable getActiveGroups(String string) throws IOException {
        return this.newsserver.getActiveGroups(string);
    }

    private final String getDateString(Calendar calendar) {
        int n = calendar.get(5);
        String string = String.valueOf(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        if ((n = calendar.get(2)) == 0) {
            n = 1;
        }
        if ((string = String.valueOf(n) + string).length() == 3) {
            string = "0" + string;
        }
        n = (n = calendar.get(1)) >= 2000 ? (n -= 2000) : (n -= 1900);
        string = String.valueOf(n) + string;
        if (string.length() == 5) {
            string = "0" + string;
        }
        return string;
    }

    public Vector getExpired(Vector vector, Date date) {
        return this.msgid.getExpired(vector, date, this.groups);
    }

    public long getFileFromMsgid(String string) {
        return this.msgid.get((String)string).file;
    }

    public String[] getGatewayNames() {
        Vector vector = this.gateways.names();
        String[] stringArray = new String[this.gateways.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public GroupData getGroupData(String string) {
        return this.groups.getData(string.toLowerCase());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getGroupList(Shell var1_1, String var2_2) throws IOException {
        var3_3 = new CommProgressWindow((Frame)var1_1.frame(), this, false, 5);
        var3_3.server().setText("Contacting server: " + var2_2);
        if (!this.newsserver.exists(var2_2)) {
            throw new IllegalArgumentException("Unknown news server: '" + var2_2 + "'");
        }
        var4_4 = new Connection(1, var2_2, this.timeout);
        var4_4.connect();
        try {
            if (var4_4.good()) {
                ++var3_3.connectionData().contactedServers;
            } else {
                ++var3_3.connectionData().errors;
lbl13:
                // 2 sources

                while (true) {
                    var6_15 = null;
                    var3_3.server().setText("Finished.");
                    var3_3.server().setValue(1000);
                    var3_3.dispose();
                    return;
                }
            }
            var4_4.writer().write("list\r\n");
            var4_4.writer().flush();
            var7_5 = var4_4.lineWaiter();
            var8_6 = null;
            var9_7 = true;
            if (true) ** GOTO lbl37
        }
        catch (Throwable var5_17) {
            var6_16 = null;
            var3_3.server().setText("Finished.");
            var3_3.server().setValue(1000);
            var3_3.dispose();
            throw var5_17;
        }
        do {
            if (!(var8_6 = new NNTPAnswer(var7_5.getLine())).good()) {
                throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "'");
            }
            if (var8_6.ignoreMe()) continue;
            var9_7 = false;
lbl37:
            // 3 sources

        } while (var9_7);
        if (var8_6.code() != 215) {
            throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "':\n" + var8_6.contents());
        }
        var10_8 = new File(this.dataDir + "nlist.temp");
        var11_9 = new BufferedWriter(new FileWriter(var10_8));
        var12_10 = var4_4.textWaiter();
        var13_11 = new IntWrapper();
        var13_11.contents = 1000;
        var14_12 = var12_10.getText(var11_9, var3_3.server(), var13_11, "groups");
        var11_9.close();
        var4_4.close();
        if (!var14_12) {
            throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "'");
        }
        var15_13 = new DefaultMutableTreeNode("*");
        var16_14 = new BufferedReader(new FileReader(var10_8));
        this.addGroupsToNode(var15_13, var16_14, var3_3.server(), var13_11.contents);
        var16_14.close();
        var10_8.delete();
        this.writeGroupList(var2_2, var15_13);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getGroupsForArticle(long l) {
        MailDataReader mailDataReader = null;
        Vector vector = new Vector();
        String string = ".";
        boolean bl = false;
        try {
            try {
                mailDataReader = new MailDataReader(this.repository, l);
                BufferedReader bufferedReader = mailDataReader.getReader();
                while (true) {
                    block12: {
                        block11: {
                            if (string == null) break block11;
                            if (!"".equals(string)) break block12;
                        }
                        Object var8_8 = null;
                        if (mailDataReader != null) return vector;
                        mailDataReader.close();
                        return vector;
                    }
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException();
                    }
                    if (string.startsWith("Newsgroups: ")) {
                        bl = true;
                        this.extractNewsgroups(vector, string.substring("Newsgroups: ".length()));
                        continue;
                    }
                    if (bl && (string.startsWith(" ") || string.startsWith("\t"))) {
                        this.extractNewsgroups(vector, string.substring(1));
                        continue;
                    }
                    bl = false;
                }
            }
            catch (IOException iOException) {
                Basis.log("File format error while scanning mail No. " + l + ":\n" + ErrorTools.redirect(iOException));
                Object var8_9 = null;
                if (mailDataReader != null) return vector;
                mailDataReader.close();
                return vector;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (mailDataReader != null) throw throwable;
            mailDataReader.close();
            throw throwable;
        }
    }

    public synchronized long getLastArticleFile() {
        return this.lastNumber;
    }

    public void getMails(CommProgressWindow commProgressWindow) throws IOException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 2);
            n = this.popserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.popserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Receiving mail from server: " + this.popserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.getMails(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    public void getMails(CommProgressWindow commProgressWindow, String string) throws IllegalArgumentException, IOException {
        int n;
        if (!this.popserver.exists(string)) {
            throw new IllegalArgumentException("Unknown pop server: '" + string + "'");
        }
        PopUserBase popUserBase = this.popserver.users(string);
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 2);
            commProgressWindow.group().setTitle("Progress for User");
            commProgressWindow.group().setPartialEnabled(true);
            commProgressWindow.mail().setTitle("Progress for Mail");
            commProgressWindow.mail().setPartialEnabled(true);
        }
        if ((n = popUserBase.size()) > 0) {
            commProgressWindow.server().setText("Scanning mail for " + n + (n > 1 ? " users..." : "user..."));
            commProgressWindow.server().setArea(0, popUserBase.size() + 1);
            commProgressWindow.server().setValue(1);
            Vector vector = popUserBase.users();
            int n2 = 0;
            while (n2 < vector.size()) {
                this.getMails(commProgressWindow, string, (String)vector.elementAt(n2));
                commProgressWindow.server().increase();
                ++n2;
            }
            commProgressWindow.server().setText("Finished! ");
        }
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.mail().setPartialEnabled(false);
        commProgressWindow.group().setText(" ");
        commProgressWindow.mail().setText(" ");
        commProgressWindow.group().setArea(0, 1);
        commProgressWindow.mail().setArea(0, 1);
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getMails(CommProgressWindow commProgressWindow, String string, String string2) throws IllegalArgumentException, IOException {
        if (!this.popserver.exists(string)) {
            throw new IllegalArgumentException("Unknown pop server: '" + string + "'");
        }
        PopUserBase popUserBase = this.popserver.users(string);
        if (!popUserBase.users().contains(string2)) {
            throw new IllegalArgumentException("User '" + string2 + "' has no mailbox on server '" + string + "'");
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 2);
        }
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.mail().setPartialEnabled(true);
        commProgressWindow.group().setText("Connecting to server: " + string);
        Connection connection = new Connection(2, string, this.timeout);
        this.connections.add(commProgressWindow.connectionData(), connection);
        connection.connect();
        if (!connection.good()) {
            throw new IOException("Couldn't establish connection to server '" + string + "'");
        }
        try {
            int n;
            Vector<Long> vector;
            String string3;
            block23: {
                popUserBase.connect(commProgressWindow, connection, string, string2);
                commProgressWindow.group().setText("Querying data...");
                connection.writer().write("LIST\r\n");
                connection.writer().flush();
                string3 = connection.lineWaiter().getLine();
                if (!string3.startsWith("+OK")) {
                    throw new IOException("An error occurred while talking to server '" + string + "'\r\n  Remote Server said: " + string3);
                }
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                connection.textWaiter().getText(bufferedWriter);
                bufferedWriter.close();
                stringWriter.close();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
                String string4 = bufferedReader.readLine();
                vector = new Vector<Long>();
                long l = 0L;
                while (true) {
                    if (string4 == null) {
                        n = vector.size();
                        if (n <= 0) break block23;
                    }
                    n = string4.indexOf(32);
                    if (n == -1) {
                        throw new IOException("Received illegal input from server: " + string);
                    }
                    try {
                        Long l2 = new Long(string4.substring(n + 1));
                        vector.addElement(l2);
                        l += l2.longValue();
                    }
                    catch (Exception exception) {
                        throw new IOException("Received illegal input from server: " + string);
                    }
                    string4 = bufferedReader.readLine();
                }
                commProgressWindow.group().setText("Receiving " + n + (n > 1 ? " mails..." : " mail..."));
                commProgressWindow.group().setArea(0, n + 1);
                commProgressWindow.group().setValue(1);
            }
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    connection.close();
                    this.connections.remove(connection);
                    commProgressWindow.group().setText("Finished");
                    break;
                }
                long l = (Long)vector.elementAt(n2);
                commProgressWindow.mail().setText("Receiving mail No." + (n2 + 1) + " (" + l + " Bytes)...");
                commProgressWindow.mail().setArea(0, (int)(l + 1L));
                commProgressWindow.mail().setValue(1);
                connection.writer().write("RETR " + (n2 + 1) + "\r\n");
                connection.writer().flush();
                string3 = connection.lineWaiter().getLine();
                if (!string3.startsWith("+OK")) {
                    throw new IOException("Can't receive mail No." + (n2 + 1) + " for user '" + string2 + "' (" + popUserBase.remoteName(string2) + ") from server '" + string + "'\r\n  Remote Server said: " + string3);
                }
                long l3 = this.getNextArticleFile();
                MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l3);
                String string5 = popUserBase.address(string2);
                if (string5 != null) {
                    mailDataWriter.getWriter().write("X-ZC-EMP: " + string5 + "\r\n");
                }
                connection.textWaiter().getByteText(mailDataWriter.getWriter(), commProgressWindow.mail(), (int)((Long)vector.elementAt(n2)).longValue());
                mailDataWriter.close();
                ++commProgressWindow.connectionData().receivedMails;
                Hashtable hashtable = RFCAnalyzer.analyzeRFC(this, l3);
                if (hashtable.containsKey("to")) {
                    Object object = RFCAnalyzer.rfcAddr2zc(this, hashtable.get("to"));
                    Vector<Object> vector2 = null;
                    if (object instanceof Vector) {
                        vector2 = (Vector<Object>)object;
                    } else {
                        vector2 = new Vector<Object>();
                        vector2.addElement(object);
                    }
                    String string6 = this.superuserAddress.toLowerCase();
                    int n3 = 0;
                    while (n3 < vector2.size()) {
                        if (((String)vector2.elementAt(n3)).toLowerCase().trim().startsWith(string6)) {
                            this.popmail.newMail("postmaster", l3);
                            break;
                        }
                        ++n3;
                    }
                }
                this.popmail.newMail(string2, l3);
                if (popUserBase.removeFromRemoteFor(string2)) {
                    commProgressWindow.mail().setText("Removing mail No." + (n2 + 1) + " from remote server...");
                    commProgressWindow.mail().setArea(0, 2);
                    commProgressWindow.mail().setValue(1);
                    connection.writer().write("DELE " + (n2 + 1) + "\r\n");
                    connection.writer().flush();
                    string3 = connection.lineWaiter().getLine();
                    commProgressWindow.mail().setValue(2);
                }
                commProgressWindow.group().increase();
                ++n2;
            }
        }
        catch (IOException iOException) {
            ++commProgressWindow.connectionData().errors;
            connection.close();
            this.connections.remove(connection);
            throw iOException;
        }
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.mail().setPartialEnabled(false);
        if (bl) {
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMsgId(long l, boolean bl, boolean bl2) throws IOException {
        Object object;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Hashtable hashtable = JanusGate.analyzeRFC(this, l);
        if (hashtable.containsKey("message-id")) {
            object = JanusGate.rfcMid2zc(hashtable.get("message-id"));
            if (!(object instanceof String)) throw new IOException("Multiple Message-ID header in mail No. '" + l + "'");
            string = (String)object;
        } else {
            bl3 = bl;
        }
        if (!hashtable.containsKey("date")) {
            bl4 = bl2;
        }
        if (bl3 || bl4) {
            object = new MailDataReader(this.repository, l);
            BufferedReader bufferedReader = ((MailDataReader)object).getReader();
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            if (bl3) {
                string = this.fakeMsgid(true);
                bufferedWriter.write("Message-ID: <" + string + ">");
                bufferedWriter.newLine();
                Basis.log("Message-ID <" + string + "> given to message No. " + l);
            }
            if (bl4) {
                bufferedWriter.write("Date: " + RFCAnalyzer.rfcDate(Calendar.getInstance().getTime()));
                bufferedWriter.newLine();
                Basis.log("Today's date given to message No. " + l);
            }
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = bufferedReader.readLine();
            }
            bufferedWriter.close();
            ((MailDataReader)object).close();
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
            bufferedWriter = mailDataWriter.getWriter();
            bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = bufferedReader.readLine();
            }
            mailDataWriter.close();
            bufferedReader.close();
            return string;
        } else {
            if (string != null) return string;
            throw new IOException("No Message-ID header in mail No. '" + l + "'");
        }
    }

    public void getNews(CommProgressWindow commProgressWindow) throws IOException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 1);
            n = this.newsserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.newsserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Reading from newsserver: " + this.newsserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.getNews(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getNews(CommProgressWindow commProgressWindow, String string) throws IllegalArgumentException, IOException {
        if (!this.newsserver.exists(string)) {
            throw new IllegalArgumentException("Unknown news server: '" + string + "'");
        }
        Hashtable hashtable = this.getActiveGroups(string);
        if (hashtable.size() == 0) {
            return;
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 1);
        }
        Hashtable<String, StartStop> hashtable2 = new Hashtable<String, StartStop>();
        Enumeration enumeration = hashtable.keys();
        int n = hashtable.size();
        commProgressWindow.server().setText("Contacting server: " + string);
        commProgressWindow.server().setArea(0, n + 1);
        commProgressWindow.server().setValue(1);
        commProgressWindow.group().setTitle("Progress in Group");
        commProgressWindow.group().setPartialEnabled(true);
        Connection connection = new Connection(1, string, this.timeout);
        this.connections.add(commProgressWindow.connectionData(), connection);
        connection.connect();
        if (!connection.good()) {
            throw new IOException("Couldn't establish connection to server '" + string + "'");
        }
        try {
            String string2;
            ++commProgressWindow.connectionData().contactedServers;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                commProgressWindow.server().setText("Scanning group: " + string2);
                StartStop startStop = new StartStop();
                if (!this.jumpGroup(connection, string2, startStop)) {
                    throw new IOException("Couldn't change to group: '" + string2 + "'");
                }
                long l = ((ActiveData)hashtable.get((Object)string2)).lastArticle + 1L;
                if (l <= startStop.stop + 1L && l > startStop.start) {
                    startStop.start = l;
                }
                if (startStop.start <= startStop.stop && (startStop.start != 0L || startStop.stop != 0L)) {
                    hashtable2.put(string2, startStop);
                }
                commProgressWindow.server().increase();
            }
            enumeration = hashtable2.keys();
            connection.close();
            this.connections.remove(connection);
            commProgressWindow.server().setValue(1);
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                commProgressWindow.server().setText("Retrieving group: " + string2);
                this.retrieveArticles(commProgressWindow, string, string2, (StartStop)hashtable2.get(string2), this.readThreads);
                ((ActiveData)hashtable.get((Object)string2)).lastArticle = ((StartStop)hashtable2.get((Object)string2)).stop;
                commProgressWindow.server().increase();
            }
            commProgressWindow.server().setText("Finished");
            this.putActiveGroups(string, hashtable);
        }
        catch (IOException iOException) {
            ++commProgressWindow.connectionData().errors;
            connection.close();
            this.connections.remove(connection);
            throw iOException;
        }
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.group().setText(" ");
        commProgressWindow.group().setArea(0, 1);
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    public String[] getNewsserverNames() {
        Vector vector = this.newsserver.titles();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public synchronized long getNextArticleFile() {
        return ++this.lastNumber;
    }

    public String getNNTPServerForTitle(String string) {
        Vector vector = this.newsserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string.equals(this.newsserver.title(string2))) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public int getNumberOfArticles() {
        return this.msgid.size();
    }

    public int getNumberOfPOPMails() {
        return this.popmail.numberOfMails();
    }

    public int getNumberOfSMTPMails() {
        return this.outmail.size();
    }

    public OptionsData getOptions() {
        OptionsData optionsData = new OptionsData();
        optionsData.readThreads = this.readThreads;
        optionsData.retries = this.artRetries;
        optionsData.timeout = this.timeout;
        optionsData.failureAllowed = this.failureAllowed;
        optionsData.maxRepositoryFileSize = this.maxRepositoryFileSize;
        optionsData.sendToAll = this.sendToAll;
        optionsData.forwardToAll = this.forwardAll;
        optionsData.saveWindowPos = this.saveWindowPos;
        optionsData.deleteWindowPos = this.deleteWindowPos;
        optionsData.dataDir = this.dataDir;
        optionsData.configFileName = this.configFileName;
        optionsData.defaultFont = this.defaultFont;
        optionsData.superuserAddress = this.superuserAddress;
        optionsData.superuserPassword = this.superuserPassword;
        return optionsData;
    }

    public PopMailboxBase getPOPMailboxForUser(String string) {
        return this.popmail.getMailbox(string);
    }

    public String getPOPPassword(String string) {
        if (string.toLowerCase().equals("postmaster")) {
            return this.superuserPassword;
        }
        return this.popserver.password(string);
    }

    public String getPOPServerForTitle(String string) {
        Vector vector = this.popserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (this.popserver.title(string2).equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public String[] getPOPServerNames() {
        Vector vector = this.popserver.servers();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.popserver.title((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    private final String getSMTPServerForPath(String string) {
        int n = string.indexOf(58);
        if (n != -1 && (n = (string = string.substring(0, n)).indexOf(44)) != -1) {
            string = string.substring(0, n);
        }
        Vector vector = this.analyzeAddress(string);
        String string2 = null;
        int n2 = -1;
        Vector vector2 = this.smtpserver.servers();
        int n3 = 0;
        while (n3 < vector2.size()) {
            String string3 = (String)vector2.elementAt(n3);
            int n4 = -1;
            Vector vector3 = this.smtpserver.getDomains(string3);
            if (vector3 == null) {
                n4 = 0;
            } else {
                int n5 = vector3.size();
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = this.compareDomains(vector, this.analyzeAddress((String)vector3.elementAt(n6)));
                    if (n7 > 0 && n7 > n4) {
                        n4 = n7;
                    }
                    ++n6;
                }
            }
            if (n4 > n2) {
                n2 = n4;
                string2 = string3;
            }
            ++n3;
        }
        return string2;
    }

    public String getSMTPServerForTitle(String string) {
        Vector vector = this.smtpserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (this.smtpserver.title(string2).equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public String[] getSMTPServerNames() {
        Vector vector = this.smtpserver.servers();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.smtpserver.title((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private final String getTimeString(Calendar calendar) {
        int n = calendar.get(13);
        String string = String.valueOf(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        if ((string = String.valueOf(n = calendar.get(12)) + string).length() == 3) {
            string = "0" + string;
        }
        if ((string = String.valueOf(n = calendar.get(10)) + string).length() == 5) {
            string = "0" + string;
        }
        return string;
    }

    public PopUserBase getUsersForPOPServer(String string) {
        String string2 = this.getPOPServerForTitle(string);
        if (!this.popserver.exists(string2)) {
            Shell.error("Internal Error", "POP Server '" + string2 + "' unknown!");
            return null;
        }
        return this.popserver.users(string2);
    }

    public PopUserBase getUsersForPOPServers(String[] stringArray) {
        PopUserBase popUserBase = null;
        int n = 0;
        while (n < stringArray.length) {
            popUserBase = this.popserver.users(this.getPOPServerForTitle(stringArray[n])).uniteWith(popUserBase);
            ++n;
        }
        return popUserBase;
    }

    public WindowData getWindowData(String string) {
        return this.windowData.get(string);
    }

    public GroupBase groups() {
        return this.groups;
    }

    public static String hostname() {
        return hostname;
    }

    public void interruptTransfer(ConnectionData connectionData, int n) {
        connectionData.setAbort(n);
        this.connections.cancel(connectionData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean jumpGroup(Connection connection, String string, StartStop startStop) {
        try {
            connection.writer().write("group " + string + "\r\n");
            connection.writer().flush();
        }
        catch (IOException iOException) {
            return false;
        }
        LineWaiter lineWaiter = connection.lineWaiter();
        GenericAnswer genericAnswer = null;
        boolean bl = true;
        while (bl) {
            genericAnswer = new NNTPAnswer(lineWaiter.getLine());
            if (!genericAnswer.good()) {
                return false;
            }
            if (genericAnswer.ignoreMe()) continue;
            bl = false;
        }
        if (genericAnswer.code() == 211) {
            startStop.start = ((NNTPAnswer)genericAnswer).firstArticleNumber();
            startStop.stop = ((NNTPAnswer)genericAnswer).lastArticleNumber();
            return true;
        }
        return false;
    }

    public boolean lockPOPUserName(String string) {
        Vector vector = this.lockedPOPUserNames;
        synchronized (vector) {
            if (!this.lockedPOPUserNames.contains(string)) {
                this.lockedPOPUserNames.addElement(string);
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
        }
        return false;
    }

    public static BufferedWriter log() {
        return logWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String string) {
        try {
            logWriter.write(string);
            logWriter.newLine();
            logWriter.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while trying to output information to the log file:");
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String string, Throwable throwable) {
        try {
            logWriter.write(string);
            logWriter.newLine();
            logWriter.write(ErrorTools.redirect(throwable));
            logWriter.newLine();
            logWriter.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while trying to output information to the log file:");
            iOException.printStackTrace();
        }
    }

    public static void memoryAlert(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        if (l - l2 > memoryUsed) {
            memoryUsed = l - l2;
        }
        double d = (double)l2 / (double)l * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        BigDecimal bigDecimal2 = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal2 = bigDecimal2.setScale(1, 4);
        if (d < 50.0) {
            System.out.println(string + ", you have " + bigDecimal + "% of your memory free.");
            System.out.println("  (Your total JVM memory is currently " + bigDecimal2 + " MB .)");
        }
    }

    public static void memoryFullAlert(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        if (l > memoryUsed) {
            memoryUsed = l;
        }
        BigDecimal bigDecimal = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal = bigDecimal.setScale(1, 4);
        System.out.println(string + ", you are out of memory!");
        System.out.println("  (Your total JVM memory is currently " + bigDecimal + " MB .)");
    }

    public static void memoryStatus() {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        double d = (double)memoryUsed / (double)l * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        BigDecimal bigDecimal2 = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal2 = bigDecimal2.setScale(1, 4);
        System.out.println("\n" + bigDecimal + "% or more of a total JVM memory of " + bigDecimal2 + " MB have been used.");
    }

    public MsgidBase msgid() {
        return this.msgid;
    }

    public NewsserverBase newsserver() {
        return this.newsserver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outmailFailure(long l, String string, String string2, Vector vector) {
        if (string2.equals("")) {
            return;
        }
        long l2 = this.getNextArticleFile();
        try {
            MailDataReader mailDataReader = new MailDataReader(this.repository, l);
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l2);
            BufferedReader bufferedReader = mailDataReader.getReader();
            BufferedWriter bufferedWriter = mailDataWriter.getWriter();
            bufferedWriter.write("From: " + this.superuserAddress + " (automatic error message)\r\n");
            bufferedWriter.write("X-ZC-ERR: The message could not be delivered to all recipients.\r\n");
            bufferedWriter.write("Message-ID: " + this.fakeMsgid(false) + "\r\n");
            bufferedWriter.write("Subject: Problems occurred delivering your mail\r\n");
            bufferedWriter.write("To: " + string2 + "\r\n\r\n");
            bufferedWriter.write("  This message was generated automatically by " + CommonConstants.TITLE + ".\r\n\r\n");
            bufferedWriter.write("  Your message could not be delivered to all recipients.\r\n");
            bufferedWriter.write("  The error message text is:\r\n\r\n");
            int n = 0;
            while (true) {
                if (n >= vector.size()) {
                    bufferedWriter.write("  Unsent mail follows.\r\n\r\n");
                    bufferedWriter.flush();
                    mailDataWriter.getStream().write(this.repository.get(l));
                    mailDataReader.close();
                    mailDataWriter.close();
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(string2);
                    this.addToOutmail(l, hostname, "", vector2);
                    return;
                }
                bufferedWriter.write((String)vector.elementAt(n));
                bufferedWriter.write("\r\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            Basis.log("Tried to send back failed email, but an error occurred: " + ErrorTools.redirect(iOException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outnewsFailure(long l, String string, Vector vector, boolean bl) {
        if (string.equals("")) {
            return;
        }
        long l2 = this.getNextArticleFile();
        try {
            MailDataReader mailDataReader = new MailDataReader(this.repository, l);
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l2);
            BufferedReader bufferedReader = mailDataReader.getReader();
            BufferedWriter bufferedWriter = mailDataWriter.getWriter();
            bufferedWriter.write("From: " + this.superuserAddress + " (automatic error message)\r\n");
            if (bl) {
                bufferedWriter.write("X-ZC-ERR: The message could not be delivered to all groups.\r\n");
            } else {
                bufferedWriter.write("X-ZC-ERR: The message could not be delivered.\r\n");
            }
            bufferedWriter.write("Message-ID: " + this.fakeMsgid(false) + "\r\n");
            bufferedWriter.write("Subject: Problems occurred delivering your article\r\n");
            bufferedWriter.write("To: " + string + "\r\n\r\n");
            bufferedWriter.write("  This message was generated automatically by " + CommonConstants.TITLE + ".\r\n\r\n");
            if (bl) {
                bufferedWriter.write("  Your article could not be delivered to the following destination groups,\r\n");
            } else {
                bufferedWriter.write("  Your article could not be delivered. Reason: you are not allowed to post\r\n");
            }
            if (bl) {
                bufferedWriter.write("  since they are unknown to the system:\r\n\r\n");
            } else {
                bufferedWriter.write("  articles into these newsgroups:\r\n\r\n");
            }
            int n = 0;
            while (true) {
                if (n >= vector.size()) {
                    bufferedWriter.write("  Unsent article follows.\r\n\r\n");
                    bufferedWriter.flush();
                    mailDataWriter.getStream().write(this.repository.get(l));
                    mailDataReader.close();
                    mailDataWriter.close();
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(string);
                    this.addToOutmail(l2, hostname, "", vector2);
                    return;
                }
                bufferedWriter.write((String)vector.elementAt(n));
                bufferedWriter.write("\r\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            Basis.log("Tried to send back failed email, but an error occurred: " + ErrorTools.redirect(iOException));
        }
    }

    public PopServerBase popserver() {
        return this.popserver;
    }

    public MailDataRepository prepack() {
        return this.prepack;
    }

    public void putActiveGroups(String string, Hashtable hashtable) throws IOException {
        this.newsserver.putActiveGroups(string, hashtable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putMail(CommProgressWindow commProgressWindow, Connection connection, OutmailData outmailData, long l, int n) throws IOException {
        Object object;
        if (commProgressWindow == null) {
            throw new IOException("Internal error: Basis.putMail called without CommProgressWindow.");
        }
        String string = outmailData.from;
        Vector vector = new Vector(outmailData.to.size());
        int n2 = 0;
        while (n2 < outmailData.to.size()) {
            vector.addElement(outmailData.to.elementAt(n2));
            ++n2;
        }
        n2 = string.indexOf(58);
        if (n2 != -1) {
            int n3 = 0;
            while (n3 < vector.size()) {
                object = (String)vector.elementAt(n3);
                n2 = ((String)object).indexOf(58);
                int n4 = ((String)object).indexOf(44);
                if (n4 != -1 && n4 < n2) {
                    n2 = n4;
                }
                if (n2 != -1) {
                    vector.setElementAt(((String)object).substring(n2 + 1), n3);
                }
                ++n3;
            }
            string = "@" + hostname + "," + string;
        }
        GenericAnswer genericAnswer = null;
        object = new Vector();
        try {
            try {
                commProgressWindow.connectionData().receiveInterruptsFor(2, this);
                if (connection == null) {
                    connection = new Connection(3, outmailData.server, this.timeout);
                    connection.connect();
                    ++commProgressWindow.connectionData().contactedServers;
                }
                long l2 = this.repository.size(l);
                commProgressWindow.group().setText("Sending mail No." + n + " (" + l2 + " Bytes)...");
                commProgressWindow.group().setArea(0, (int)(l2 + 1L));
                int n5 = 1;
                commProgressWindow.group().setValue(1);
                connection.writer().write("MAIL FROM:<" + string + ">\r\n");
                connection.writer().flush();
                genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                while (genericAnswer.ignoreMe()) {
                    if (!genericAnswer.good()) {
                        throw new Exception("Bad Connection");
                    }
                    genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                }
                if (genericAnswer.code() != 250) {
                    throw new Exception("Server '" + outmailData.server + "' rejected mail from " + string + "!");
                }
                int n6 = 0;
                while (n6 < vector.size()) {
                    connection.writer().write("RCPT TO:<" + vector.elementAt(n6) + ">\r\n");
                    connection.writer().flush();
                    genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    while (genericAnswer.ignoreMe()) {
                        if (!genericAnswer.good()) {
                            throw new Exception("Bad Connection");
                        }
                        genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    }
                    if (genericAnswer.code() != 250 && genericAnswer.code() != 251) {
                        ((Vector)object).addElement("Recipient " + vector.elementAt(n6) + " failed (host '" + outmailData.server + "' responded: '" + genericAnswer.contents() + "':");
                    }
                    ++n6;
                }
                if (((Vector)object).size() < vector.size()) {
                    connection.writer().write("DATA\r\n");
                    connection.writer().flush();
                    genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    while (genericAnswer.ignoreMe()) {
                        if (!genericAnswer.good()) {
                            throw new Exception("Bad Connection");
                        }
                        genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    }
                    if (genericAnswer.code() != 354) {
                        throw new Exception("Server '" + outmailData.server + "' did not accept mail data!");
                    }
                    MailDataReader mailDataReader = new MailDataReader(this.repository, l);
                    BufferedReader bufferedReader = mailDataReader.getReader();
                    String string2 = bufferedReader.readLine();
                    int n7 = 0;
                    int n8 = Shell.progressGranularity();
                    while (string2 != null) {
                        n5 += string2.length();
                        if (++n7 == n8) {
                            commProgressWindow.group().setValue(++n5);
                            n7 = 0;
                        }
                        if (string2.startsWith(".")) {
                            connection.writer().write(".");
                        }
                        connection.writer().write(string2);
                        connection.writer().write("\r\n");
                        string2 = bufferedReader.readLine();
                    }
                    connection.writer().write(".\r\n");
                    connection.writer().flush();
                    mailDataReader.close();
                    genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    while (genericAnswer.ignoreMe()) {
                        if (!genericAnswer.good()) {
                            throw new Exception("Bad Connection");
                        }
                        genericAnswer = new SMTPAnswer(connection.lineWaiter().getLine());
                    }
                    if (genericAnswer.code() != 250) {
                        throw new Exception("A problem occurred sending data to server '" + outmailData.server);
                    }
                    ++commProgressWindow.connectionData().sentMails;
                }
                if (((Vector)object).size() > 0) {
                    ++commProgressWindow.connectionData().errors;
                    this.outmailFailure(l, outmailData.fromHost, outmailData.from, (Vector)object);
                }
                Object var13_23 = null;
                commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                return;
            }
            catch (Exception exception) {
                ++commProgressWindow.connectionData().errors;
                if (connection != null) {
                    connection.close();
                }
                if (genericAnswer == null) throw new IOException("Couldn't connect to remote Host. Reason:\n" + ErrorTools.redirect(exception));
                throw new IOException("Remote host said: " + genericAnswer.contents() + "\nHence:" + ErrorTools.redirect(exception));
            }
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            commProgressWindow.connectionData().receiveInterruptsFor(2, null);
            throw throwable;
        }
    }

    public void putMails(CommProgressWindow commProgressWindow) {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 3);
            n = this.smtpserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.smtpserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Sending mail to server: " + this.smtpserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.putMails(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putMails(CommProgressWindow commProgressWindow, String string) {
        int n;
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 3);
        }
        if ((n = this.outmail.size()) > 0) {
            commProgressWindow.server().setText("Working on " + n + (n > 1 ? " mails..." : " mail..."));
            commProgressWindow.server().setArea(0, n + 1);
            commProgressWindow.server().setValue(1);
            commProgressWindow.group().setTitle("Progress on Mail");
            commProgressWindow.group().setPartialEnabled(true);
            commProgressWindow.group().setText("Connecting to server: " + string);
            Connection connection = new Connection(3, string, this.timeout);
            this.connections.add(commProgressWindow.connectionData(), connection);
            connection.connect();
            if (!connection.good()) {
                ++commProgressWindow.connectionData().errors;
                connection.close();
                Basis.log("Sending mail: Couldn't establish connection to server: " + string);
                if (bl) {
                    commProgressWindow.dispose();
                }
                return;
            }
            ++commProgressWindow.connectionData().contactedServers;
            try {
                this.outmail.putMails(commProgressWindow, connection, string);
            }
            catch (IOException iOException) {
                Basis.log("An error occurred while sending mails:\n" + ErrorTools.redirect(iOException));
                ++commProgressWindow.connectionData().errors;
            }
            commProgressWindow.server().setValue(n + 1);
            connection.close();
            this.connections.remove(connection);
        }
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.group().setText(" ");
        commProgressWindow.group().setArea(0, 1);
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    public void putNews(CommProgressWindow commProgressWindow) {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 1);
            n = this.newsserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.newsserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Writing to newsserver: " + this.newsserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.putNews(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    public void putNews(CommProgressWindow commProgressWindow, String string) {
        int n = this.outgoing.forServer(string);
        if (n == 0) {
            return;
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 1);
        }
        commProgressWindow.server().setText("Working on " + n + (n == 1 ? " article..." : " articles..."));
        commProgressWindow.server().setArea(0, n + 1);
        commProgressWindow.server().setValue(1);
        commProgressWindow.group().setTitle("Progress on Article");
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.group().setText("Connecting to server: " + string);
        Connection connection = new Connection(1, string, this.timeout);
        this.connections.add(commProgressWindow.connectionData(), connection);
        connection.connect();
        if (!connection.good()) {
            ++commProgressWindow.connectionData().errors;
            Basis.log("Sending mail: Couldn't establish connection to server: " + string);
        }
        ++commProgressWindow.connectionData().contactedServers;
        this.outgoing.putNews(commProgressWindow, string, connection, this.forwardAll);
        connection.close();
        this.connections.remove(connection);
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.group().setText(" ");
        commProgressWindow.group().setArea(0, 1);
        commProgressWindow.server().setValue(n + 1);
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    private final String readConfigLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        return string;
    }

    public TreeNode readGroupList(String string) throws IOException {
        return this.newsserver.readGroupList(string);
    }

    private final void readVersion0010(BufferedReader bufferedReader) throws IOException {
        this.dataDir = bufferedReader.readLine();
        if (this.dataDir == null) {
            throw new IOException("config file corrupt (too short)");
        }
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.readThreads = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.artRetries = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.timeout = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.failureAllowed = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.sendToAll = string.equals("y");
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.forwardAll = string.equals("y");
        string = bufferedReader.readLine();
        if (string != null) {
            throw new IOException("config file corrupt (too long)");
        }
    }

    private final void readVersion0020(BufferedReader bufferedReader) throws IOException {
        this.dataDir = bufferedReader.readLine();
        if (this.dataDir == null) {
            throw new IOException("config file corrupt (too short)");
        }
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.readThreads = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.artRetries = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.timeout = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.failureAllowed = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.maxRepositoryFileSize = new Integer(string);
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.sendToAll = string.equals("y");
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.forwardAll = string.equals("y");
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.saveWindowPos = string.equals("y");
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.deleteWindowPos = string.equals("y");
        string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        this.defaultFont = new Integer(string);
        string = bufferedReader.readLine();
        if (string != null) {
            throw new IOException("config file corrupt (too long)");
        }
    }

    private final void readVersion0030(BufferedReader bufferedReader) throws IOException {
        this.dataDir = this.readConfigLine(bufferedReader);
        this.readThreads = new Integer(this.readConfigLine(bufferedReader));
        this.artRetries = new Integer(this.readConfigLine(bufferedReader));
        this.timeout = new Integer(this.readConfigLine(bufferedReader));
        this.failureAllowed = new Integer(this.readConfigLine(bufferedReader));
        this.maxRepositoryFileSize = new Integer(this.readConfigLine(bufferedReader));
        this.sendToAll = this.readConfigLine(bufferedReader).equals("y");
        this.forwardAll = this.readConfigLine(bufferedReader).equals("y");
        this.saveWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.deleteWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.defaultFont = new Integer(this.readConfigLine(bufferedReader));
        this.superuserAddress = this.readConfigLine(bufferedReader);
        this.superuserPassword = this.readConfigLine(bufferedReader);
        String string = bufferedReader.readLine();
        if (string != null) {
            throw new IOException("config file corrupt (too long)");
        }
    }

    public void relax() throws IOException {
        this.relax(false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void relax(boolean bl, boolean bl2) throws IOException {
        if (!bl2) {
            this.doRelax = false;
            Basis.memoryAlert("On shutdown");
        }
        if (bl) {
            System.out.print("Saving data...");
        } else {
            System.out.println("Saving data:");
        }
        if (!bl2) {
            this.gateways.relaxObjects();
        }
        this.msgid.save(!bl);
        this.groups.save(!bl);
        this.outgoing.save(!bl);
        this.outmail.save(!bl);
        this.popmail.save(!bl);
        this.newsserver.save(!bl);
        this.smtpserver.save(!bl);
        this.popserver.save(!bl);
        this.gateways.save(!bl);
        if (this.saveWindowPos) {
            this.windowData.save(!bl);
        }
        this.repository.relax(bl);
        this.prepack.relax(bl);
        if (!bl2) {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataDir + FILE_LAST));
                objectOutputStream.writeObject(new Long(this.lastNumber));
                objectOutputStream.writeObject(new Boolean(false));
                objectOutputStream.close();
            }
            catch (Exception exception) {
                throw new IOException("Something went wrong writing file '" + this.dataDir + FILE_LAST + "':\n" + ErrorTools.redirect(exception));
            }
            this.lock.close();
        }
        if (!bl) {
            System.out.println("...done!");
        } else {
            System.out.println("done!");
        }
        if (!bl && !bl2) {
            Basis.memoryStatus();
        }
    }

    public void removeArticle(String string) {
        this.msgid.removeArticle(string, this.groups);
    }

    public void removeGateway(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.gateways.remove(string);
    }

    public void removeMailFromPopmail(Long l) {
        this.popmail.removeMail(l);
    }

    public void removeNewsgroup(String string, String string2) throws IOException {
        if (string2 == null) {
            Vector vector = this.newsserver.servers();
            int n = 0;
            while (n < vector.size()) {
                this.removeNewsgroup(string, (String)vector.elementAt(n));
                ++n;
            }
            this.groups.remove(string);
        } else {
            Hashtable hashtable = this.getActiveGroups(string2);
            if (hashtable.containsKey(string)) {
                hashtable.remove(string);
                this.putActiveGroups(string2, hashtable);
            }
        }
    }

    public void removeNewsserverByTitle(String string) throws IOException {
        String string2 = this.getNNTPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.newsserver.remove(string2);
        this.groups.removeServer(string2);
    }

    public void removePOPServerByTitle(String string) throws IOException {
        String string2 = this.getPOPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.popserver.remove(string2);
    }

    public void removeSMTPServerByTitle(String string) throws IOException {
        String string2 = this.getSMTPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.outmail.removeAllForServer(string2);
        this.smtpserver.remove(string2);
    }

    public boolean removeUserFromPopmail(String string) {
        if (!this.popmail.containsUser(string)) {
            return false;
        }
        return this.popmail.removeUser(string);
    }

    public MailDataRepository repository() {
        return this.repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void retrieveArticles(CommProgressWindow commProgressWindow, String string, String string2, StartStop startStop, int n) throws IOException {
        int n2;
        int n3;
        if (startStop.stop < startStop.start) {
            return;
        }
        if (startStop.stop - startStop.start + 1L < (long)n) {
            n = (int)(startStop.stop - startStop.start + 1L);
        }
        if (commProgressWindow == null) {
            throw new IOException("This can't happen: entered retrieveArticles with progress=null.");
        }
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.group().setText("Initializing " + n + " reader thread" + (n > 1 ? "s..." : "..."));
        commProgressWindow.group().setArea(0, n + 1);
        commProgressWindow.group().setValue(1);
        boolean[] blArray = new boolean[n];
        int n4 = 0;
        while (n4 < n) {
            blArray[n4] = false;
            ++n4;
        }
        long[] lArray = new long[n];
        int n5 = 0;
        while (n5 < n) {
            lArray[n5] = 0L;
            ++n5;
        }
        ArticleRetriever[] articleRetrieverArray = new ArticleRetriever[n];
        int n6 = 0;
        while (n6 < n) {
            try {
                articleRetrieverArray[n6] = new ArticleRetriever(n6, string, string2, blArray, lArray, this);
                commProgressWindow.group().increase();
            }
            catch (IOException iOException) {
                throw new IOException("Something went wrong creating a reader thread. Details:\n" + ErrorTools.redirect(iOException));
            }
            ++n6;
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray2) {
            n3 = 0;
            n2 = 0;
            while (n2 < n) {
                if (blArray[n2]) {
                    n3 = 1;
                }
                ++n2;
            }
            while (n3 == 0) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                n2 = 0;
                while (n2 < n) {
                    if (blArray[n2]) {
                        n3 = 1;
                    }
                    ++n2;
                }
            }
        }
        commProgressWindow.group().setText("Reading " + (startStop.stop - startStop.start + 1L) + " article" + (startStop.stop == startStop.start ? "..." : "s..."));
        commProgressWindow.group().setArea(0, (int)(startStop.stop - startStop.start + 1L));
        long l = startStop.start;
        while (l <= startStop.stop) {
            int n7;
            commProgressWindow.group().setValue((int)(l - startStop.start + 1L));
            n3 = n;
            boolean[] blArray3 = blArray;
            synchronized (blArray3) {
                n7 = 0;
                while (n7 < n) {
                    if (blArray[n7]) {
                        n3 = n7;
                        break;
                    }
                    ++n7;
                }
            }
            if (n3 == n) {
                throw new Error("This can't happen: thread confusion");
            }
            articleRetrieverArray[n3].retrieve(l);
            blArray3 = blArray;
            synchronized (blArray3) {
                n7 = 0;
                int n8 = 0;
                while (n8 < n) {
                    if (blArray[n8]) {
                        n7 = 1;
                    }
                    ++n8;
                }
                while (n7 == 0) {
                    try {
                        blArray.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    n8 = 0;
                    while (n8 < n) {
                        if (blArray[n8]) {
                            n7 = 1;
                        }
                        ++n8;
                    }
                }
            }
            ++commProgressWindow.connectionData().receivedArticles;
            ++l;
        }
        commProgressWindow.group().setText("Waiting for " + n + " reader thread" + (n > 1 ? "s" : "") + " to finish...");
        commProgressWindow.group().setArea(0, n + 1);
        commProgressWindow.group().setValue(1);
        boolean[] blArray4 = blArray;
        synchronized (blArray4) {
            n3 = 0;
            n2 = 0;
            while (n2 < n) {
                if (!blArray[n2]) {
                    ++n3;
                }
                ++n2;
            }
            commProgressWindow.group().setValue(n - n3 + 1);
            while (n3 > 0) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                n3 = 0;
                n2 = 0;
                while (n2 < n) {
                    if (!blArray[n2]) {
                        ++n3;
                    }
                    ++n2;
                }
                commProgressWindow.group().setValue(n - n3 + 1);
            }
        }
        int n9 = 0;
        while (n9 < n) {
            articleRetrieverArray[n9].cancel();
            ++n9;
        }
        commProgressWindow.group().setArea(0, 1);
        commProgressWindow.group().setText(" ");
        commProgressWindow.group().setPartialEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveHashtableFile(Hashtable hashtable, String string, boolean bl) throws IOException {
        if (bl) {
            System.out.print("..." + string);
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataDir + string), 16384));
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.close();
            return;
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong writing file '" + this.dataDir + string + "':\n" + ErrorTools.redirect(exception));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable scanHashtableFile(String string, boolean bl) throws IOException {
        if (bl) {
            System.out.print("..." + string);
        }
        Hashtable hashtable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.dataDir + string), 16384));
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            return hashtable;
        }
        catch (IOException iOException) {
            return new Hashtable();
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong reading file '" + this.dataDir + string + "':\n" + ErrorTools.redirect(exception));
        }
    }

    public void setOptions(OptionsData optionsData) {
        this.readThreads = optionsData.readThreads;
        this.artRetries = optionsData.retries;
        this.timeout = optionsData.timeout;
        this.failureAllowed = optionsData.failureAllowed;
        this.maxRepositoryFileSize = optionsData.maxRepositoryFileSize;
        this.sendToAll = optionsData.sendToAll;
        this.forwardAll = optionsData.forwardToAll;
        this.saveWindowPos = optionsData.saveWindowPos;
        this.deleteWindowPos = optionsData.deleteWindowPos;
        this.dataDir = optionsData.dataDir;
        this.configFileName = optionsData.configFileName;
        this.defaultFont = optionsData.defaultFont;
        this.superuserAddress = optionsData.superuserAddress;
        this.superuserPassword = optionsData.superuserPassword;
    }

    public SmtpServerBase smtpserver() {
        return this.smtpserver;
    }

    public String superuserAddress() {
        return this.superuserAddress;
    }

    public TidyUpData tidyUp(File file) {
        TidyUpData tidyUpData = new TidyUpData();
        Object object = new Object();
        Hashtable hashtable = new Hashtable();
        this.groups.tidyUp(tidyUpData);
        Vector vector = this.outgoing.msgids();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (!this.msgid.exists(string)) {
                this.outgoing.remove(string);
                ++tidyUpData.errors;
            } else if (!this.repository.exists(this.msgid.get((String)string).file)) {
                this.outgoing.remove(string);
            } else {
                this.outgoing.tidyUp(string, this.newsserver);
            }
            ++n;
        }
        this.msgid.tidyUp(this.groups, hashtable, tidyUpData);
        this.outmail.tidyUp(this.smtpserver, hashtable, tidyUpData);
        this.popmail.tidyUp(hashtable, tidyUpData);
        long l = 0L;
        Enumeration enumeration = this.repository.allFiles();
        while (enumeration.hasMoreElements()) {
            Long l2 = (Long)enumeration.nextElement();
            if (!hashtable.containsKey(l2)) {
                ++tidyUpData.orphaned;
                this.repository.backup(l2, file);
                this.repository.delete(l2);
            }
            if (l2 <= l) continue;
            l = l2;
        }
        if (l > this.lastNumber) {
            this.lastNumber = l;
            ++tidyUpData.errors;
        }
        return tidyUpData;
    }

    public TidyUpData tidyUpPrepack(File file) {
        int n;
        Serializable serializable;
        TidyUpData tidyUpData = new TidyUpData();
        Vector vector = new Vector();
        Object object = new Object();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector2 = new Vector();
        Object object2 = this.prepack.allFiles();
        while (object2.hasMoreElements()) {
            vector2.addElement(object2.nextElement());
        }
        object2 = this.gateways.names();
        int n2 = 0;
        while (n2 < ((Vector)object2).size()) {
            serializable = this.gateways.object((String)((Vector)object2).elementAt(n2)).prepackFiles();
            int n3 = 0;
            while (n3 < ((Vector)serializable).size()) {
                vector.addElement(((Vector)serializable).elementAt(n3));
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            block10: {
                long l = (Long)vector2.elementAt(n2);
                n = 0;
                while (n < vector.size()) {
                    if ((Long)vector.elementAt(n) != l) {
                        ++n;
                        continue;
                    }
                    break block10;
                }
                hashtable.put(vector2.elementAt(n2), object);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            block11: {
                long l = (Long)vector.elementAt(n2);
                n = 0;
                while (n < vector2.size()) {
                    if ((Long)vector2.elementAt(n) != l) {
                        ++n;
                        continue;
                    }
                    break block11;
                }
                hashtable2.put(vector.elementAt(n2), object);
            }
            ++n2;
        }
        tidyUpData.orphaned = hashtable.size();
        tidyUpData.unavailable = hashtable2.size();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            serializable = (Long)enumeration.nextElement();
            this.prepack.backup((Long)serializable, file);
            this.prepack.delete((Long)serializable);
        }
        return tidyUpData;
    }

    public void unlockPOPUserName(String string) {
        Vector vector = this.lockedPOPUserNames;
        synchronized (vector) {
            this.lockedPOPUserNames.removeElement(string);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateGroupList(Shell var1_1, String var2_2) throws IOException {
        if (!this.newsserver.exists(var2_2)) {
            throw new IllegalArgumentException("Unknown news server: '" + var2_2 + "'");
        }
        var3_3 = this.newsserver.getListDate(var2_2);
        if (!this.newsserver.hasGroupList(var2_2)) {
            this.getGroupList(var1_1, var2_2);
            return;
        }
        var4_4 = Calendar.getInstance();
        var4_4.setTime(var3_3);
        var4_4.add(5, -2);
        var5_5 = new CommProgressWindow((Frame)var1_1.frame(), this, false, 3);
        var5_5.server().setText("Contacting server: " + var2_2);
        var6_6 = new Connection(1, var2_2, this.timeout);
        var6_6.connect();
        try {
            if (var6_6.good()) {
                ++var5_5.connectionData().contactedServers;
            } else {
                ++var5_5.connectionData().errors;
lbl20:
                // 2 sources

                while (true) {
                    var8_17 = null;
                    var5_5.server().setText("Finished.");
                    var5_5.server().setValue(50);
                    var5_5.dispose();
                    return;
                }
            }
            var6_6.writer().write("newgroups " + this.getDateString(var4_4) + " " + this.getTimeString(var4_4) + "\r\n");
            var6_6.writer().flush();
            var9_7 = var6_6.lineWaiter();
            var10_8 = null;
            var11_9 = true;
            if (true) ** GOTO lbl44
        }
        catch (Throwable var7_19) {
            var8_18 = null;
            var5_5.server().setText("Finished.");
            var5_5.server().setValue(50);
            var5_5.dispose();
            throw var7_19;
        }
        do {
            if (!(var10_8 = new NNTPAnswer(var9_7.getLine())).good()) {
                throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "'");
            }
            if (var10_8.ignoreMe()) continue;
            var11_9 = false;
lbl44:
            // 3 sources

        } while (var11_9);
        if (var10_8.code() != 231) {
            throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "':\n" + var10_8.contents());
        }
        var12_10 = new File(this.dataDir + "nlist.temp");
        var13_11 = new BufferedWriter(new FileWriter(var12_10));
        var14_12 = var6_6.textWaiter();
        var15_13 = new IntWrapper();
        var15_13.contents = 50;
        var16_14 = var14_12.getText(var13_11, var5_5.server(), var15_13, "groups");
        var13_11.close();
        var6_6.close();
        if (!var16_14) {
            throw new IOException("An error occurred trying to get the group list from server '" + var2_2 + "'");
        }
        var17_15 = this.readGroupList(var2_2);
        var18_16 = new BufferedReader(new FileReader(var12_10));
        this.addGroupsToNode(var17_15, var18_16, var5_5.server(), var15_13.contents);
        var18_16.close();
        this.writeGroupList(var2_2, var17_15);
        ** while (true)
    }

    public void writeConfigFile() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.configFileName));
        bufferedWriter.write(CONFIG_FILE_HEADER);
        bufferedWriter.newLine();
        bufferedWriter.write("00.30");
        bufferedWriter.newLine();
        bufferedWriter.write(this.dataDir);
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.readThreads));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.artRetries));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.timeout));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.failureAllowed));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.maxRepositoryFileSize));
        bufferedWriter.newLine();
        bufferedWriter.write(this.sendToAll ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.forwardAll ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.saveWindowPos ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.deleteWindowPos ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.defaultFont));
        bufferedWriter.newLine();
        bufferedWriter.write(this.superuserAddress);
        bufferedWriter.newLine();
        bufferedWriter.write(this.superuserPassword);
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    public void writeGroupList(String string, TreeNode treeNode) throws IOException {
        this.newsserver.writeGroupList(string, treeNode);
    }

    public Basis() throws IOException {
        this(false);
    }

    public Basis(String string) throws IOException {
        this(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Basis(String string, boolean bl) throws IOException {
        boolean bl2;
        FileInputStream fileInputStream;
        block24: {
            this.readThreads = 3;
            this.artRetries = 3;
            this.timeout = 200;
            this.failureAllowed = 5;
            this.maxRepositoryFileSize = 0x2800000;
            this.lastNumber = 0L;
            this.sendToAll = true;
            this.forwardAll = false;
            this.defaultFont = 1;
            this.superuserAddress = "postmaster@some.domain";
            this.superuserPassword = "secret";
            this.doRelax = false;
            this.lockedPOPUserNames = new Vector();
            this.connections = new ConnectionBase();
            this.configFileName = string;
            hostname = null;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                if (!CommonConstants.debugL) break block24;
                System.err.println("Warning: This machine sufferes from an invalid TCP/IP configuration.");
                System.err.println("  Message returned by the Java Runtime System:");
                System.err.println("  " + exception.getMessage());
            }
        }
        if (hostname == null || hostname.toLowerCase().equals("localhost") || hostname.equals("")) {
            hostname = "not-for-mail";
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                throw new IOException("Config file not found: " + string);
            }
            this.createConfigFile(string);
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                throw new IOException("Couldn't make config file ('" + string + "'). Reason:\n" + ErrorTools.redirect(fileNotFoundException2));
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = bufferedReader.readLine();
        if (!string2.equals(CONFIG_FILE_HEADER)) {
            throw new IOException("'" + string + "' isn't a valid config file");
        }
        string2 = bufferedReader.readLine();
        if (string2.equals("00.10")) {
            this.readVersion0010(bufferedReader);
        } else if (string2.equals("00.20")) {
            this.readVersion0020(bufferedReader);
        } else {
            if (!string2.equals("00.30")) {
                throw new IOException("config file '" + string + "' has unrecognized format '" + string2 + "'");
            }
            this.readVersion0030(bufferedReader);
            if (this.deleteWindowPos) {
                this.deleteWindowPos = false;
                this.writeConfigFile();
                new File(this.dataDir + FILE_WINDOWS).delete();
            }
        }
        bufferedReader.close();
        logWriter.flush();
        logWriter.close();
        FileWriter fileWriter = new FileWriter(this.dataDir + "knewsmail.log", true);
        fileWriter.write("\n\n--->\n" + DateFormat.getDateTimeInstance().format(new Date()) + " : starting " + CommonConstants.TITLE + "\n\n");
        fileWriter.flush();
        logWriter = new BufferedWriter(new EchoWriter((Writer)fileWriter, new BufferedWriter(new OutputStreamWriter(System.out))));
        if (bl) {
            System.out.print("Scanning database...");
        } else {
            System.out.println("Scanning database:");
        }
        this.lock = new FileOutputStream(this.dataDir + FILE_LOCK);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.dataDir + FILE_LAST));
            this.lastNumber = (Long)objectInputStream.readObject();
            bl2 = (Boolean)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong scanning file '" + this.dataDir + FILE_LAST + "':\n" + ErrorTools.redirect(exception));
        }
        if (bl2) {
            System.out.println("Database possibly corrupt! We'll try to go on...");
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataDir + FILE_LAST));
            objectOutputStream.writeObject(new Long(this.lastNumber));
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Something went wrong writing file '" + this.dataDir + FILE_LAST + "':\n" + ErrorTools.redirect(exception));
        }
        this.newsserver = new NewsserverBase(this, FILE_NEWSSERVER, !bl);
        this.smtpserver = new SmtpServerBase(this, FILE_SMTPSERVER, !bl);
        this.popserver = new PopServerBase(this, FILE_POPSERVER, !bl);
        this.gateways = new GateBase(this, FILE_GATEWAYS, !bl);
        this.groups = new GroupBase(this, FILE_GROUPS, !bl);
        this.msgid = new MsgidBase(this, FILE_MSGID, !bl);
        this.outgoing = new OutgoingBase(this, FILE_OUTGOING, !bl);
        this.popmail = new PopmailBase(this, FILE_POPMAIL, !bl);
        this.outmail = new OutmailBase(this, FILE_OUTMAIL, !bl);
        this.windowData = new WindowBase(this, FILE_WINDOWS, !bl);
        this.repository = new MailDataRepository(FILE_REPOSITORY_PREFIX, this, this.maxRepositoryFileSize, bl);
        this.prepack = new MailDataRepository(FILE_PREPACK_PREFIX, this, this.maxRepositoryFileSize, bl);
        if (!bl) {
            System.out.println("...done!");
        } else {
            System.out.println("done!");
        }
        Basis.memoryAlert("After initialization");
        this.doRelax = true;
    }

    public Basis(boolean bl) throws IOException {
        this(System.getProperty("user.home") + System.getProperty("file.separator") + FILE_CONFIG, bl);
    }

    static {
        logWriter = new BufferedWriter(new OutputStreamWriter(System.err));
    }
}

