/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.Connection;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.GenericAnswer;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.NNTPAnswer;
import net.ibm.malamut.newsmail.TextWaiter;

public final class ArticleRetriever
extends Thread {
    private boolean goOn = true;
    private Basis basis;
    private boolean[] threadReady;
    private long[] threadTask;
    private int threadId;
    private String newsserver;
    private String newsgroup;
    private int timeout;
    private boolean ready = false;
    private Object readyMonitor = new Object();
    private Connection conn;

    public void cancel() {
        long[] lArray = this.threadTask;
        synchronized (lArray) {
            this.goOn = false;
            this.threadTask.notifyAll();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void establishConnection() throws IOException {
        this.conn = new Connection(1, this.newsserver, this.timeout);
        this.conn.connect();
        if (!this.conn.good()) {
            throw new IOException("Couldn't open connection to server '" + this.newsserver + "'");
        }
        this.conn.writer().write("group " + this.newsgroup + "\r\n");
        this.conn.writer().flush();
        try {
            boolean bl = true;
            GenericAnswer genericAnswer = null;
            while (true) {
                if (!bl) {
                    if (genericAnswer.code() != 211) throw new Exception();
                    if (((NNTPAnswer)genericAnswer).group().equals(this.newsgroup)) return;
                    throw new Exception();
                }
                genericAnswer = new NNTPAnswer(this.conn.lineWaiter().getLine());
                if (!genericAnswer.good()) {
                    throw new Exception();
                }
                if (genericAnswer.ignoreMe()) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            throw new IOException("Error switching to group '" + this.newsgroup + "' on server '" + this.newsserver + "'. Reason:\n" + ErrorTools.redirect(exception));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retrieve(long l) {
        Object object = this.readyMonitor;
        synchronized (object) {
            while (!this.ready) {
                try {
                    this.readyMonitor.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        object = this.threadTask;
        synchronized (object) {
            this.threadTask[this.threadId] = l;
            this.threadTask.notifyAll();
        }
        object = this.threadReady;
        synchronized (object) {
            this.threadReady[this.threadId] = false;
            return;
        }
    }

    private final void retrieveFromServer(long l) throws IOException {
        this.conn.writer().write("stat " + l + "\r\n");
        this.conn.writer().flush();
        boolean bl = true;
        GenericAnswer genericAnswer = null;
        while (bl) {
            genericAnswer = new NNTPAnswer(this.conn.lineWaiter().getLine());
            if (!genericAnswer.good()) {
                throw new IOException("Something went wrong reading article No. " + l + " in group " + this.newsgroup + " on server " + this.newsserver);
            }
            if (genericAnswer.ignoreMe()) continue;
            bl = false;
        }
        if (genericAnswer.code() != 223) {
            return;
        }
        if (!this.basis.existsMsgid(((NNTPAnswer)genericAnswer).msgid())) {
            ArticleData articleData = new ArticleData();
            articleData.file = this.basis.getNextArticleFile();
            articleData.received = Calendar.getInstance().getTime();
            this.conn.writer().write("article " + l + "\r\n");
            this.conn.writer().flush();
            bl = true;
            while (bl) {
                genericAnswer = new NNTPAnswer(this.conn.lineWaiter().getLine());
                if (!genericAnswer.good()) {
                    throw new IOException("Something went wrong reading article No. " + l + " in group " + this.newsgroup + " on server " + this.newsserver);
                }
                if (genericAnswer.ignoreMe()) continue;
                bl = false;
            }
            if (genericAnswer.code() != 220) {
                return;
            }
            MailDataWriter mailDataWriter = new MailDataWriter(this.basis.repository(), articleData.file);
            TextWaiter textWaiter = this.conn.textWaiter();
            boolean bl2 = textWaiter.getText(mailDataWriter.getWriter());
            mailDataWriter.close();
            if (!bl2) {
                throw new IOException("Something went wrong reading article No. " + l + " in group " + this.newsgroup + " on server " + this.newsserver);
            }
            Vector vector = this.basis.getGroupsForArticle(articleData.file);
            if (vector.size() == 0) {
                throw new IOException("Article No. " + l + " in group " + this.newsgroup + " on server " + this.newsserver + " is corrupt!");
            }
            String string = "Xref: " + Basis.hostname() + " ";
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                GroupData groupData = this.basis.getGroupData(string2);
                if (groupData != null) {
                    this.basis.groups().sync().startWrite();
                    ++groupData.lastArticle;
                    groupData.articles.put(new Long(groupData.lastArticle), ((NNTPAnswer)genericAnswer).msgid());
                    this.basis.groups().sync().endWrite();
                    string = string + string2 + ":" + groupData.lastArticle;
                }
                ++n;
            }
            this.basis.changeXrefLine(articleData.file, string);
            this.basis.addMsgid(((NNTPAnswer)genericAnswer).msgid(), articleData);
            this.basis.addToOutnews(this.newsserver, ((NNTPAnswer)genericAnswer).msgid());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        var1_1 = 0L;
        var3_2 /* !! */  = this.threadReady;
        // MONITORENTER : var3_2 /* !! */ 
        this.threadReady[this.threadId] = true;
        // MONITOREXIT : var3_2 /* !! */ 
        block24: while (true) {
            var3_2 /* !! */  = (boolean[])this.threadTask;
            // MONITORENTER : var3_2 /* !! */ 
            var5_4 /* !! */  = this.threadReady;
            // MONITORENTER : var5_4 /* !! */ 
            this.threadReady.notifyAll();
            // MONITOREXIT : var5_4 /* !! */ 
            var5_4 /* !! */  = (boolean[])this.readyMonitor;
            // MONITORENTER : var5_4 /* !! */ 
            try {
                this.ready = true;
                // MONITOREXIT : var5_4 /* !! */ 
                ** GOTO lbl33
            }
            catch (Throwable v2) {
                // MONITOREXIT : var5_4 /* !! */ 
                throw v2;
lbl33:
                // 1 sources

                if (true) ** GOTO lbl48
            }
            do {
                try {
                    this.threadTask.wait();
                    if (!this.goOn) {
                        var4_7 = null;
                        // MONITOREXIT : var3_2 /* !! */ 
                        return;
                    }
                }
                catch (InterruptedException var5_5) {
                }
lbl48:
                // 3 sources

            } while (this.threadTask[this.threadId] == 0L);
            var1_1 = this.threadTask[this.threadId];
            this.threadTask[this.threadId] = 0L;
            var5_4 /* !! */  = (boolean[])this.readyMonitor;
            // MONITORENTER : var5_4 /* !! */ 
            this.ready = false;
            // MONITOREXIT : var5_4 /* !! */ 
            try {
                this.retrieveFromServer(var1_1);
            }
            catch (IOException var3_3) {
                Basis.log("An error occurred while receiving articles", var3_3);
            }
            var3_2 /* !! */  = this.threadReady;
            // MONITORENTER : var3_2 /* !! */ 
            while (true) {
                if (!this.threadReady[this.threadId]) {
                    this.threadReady[this.threadId] = true;
                    // MONITOREXIT : var3_2 /* !! */ 
                    continue block24;
                }
                try {
                    this.threadReady.wait(100L);
                }
                catch (InterruptedException var5_6) {
                }
            }
            break;
        }
        catch (Throwable v5) {
            // MONITOREXIT : var3_2 /* !! */ 
            throw v5;
        }
    }

    public ArticleRetriever(int n, String string, String string2, boolean[] blArray, long[] lArray, Basis basis) throws IOException {
        this.threadReady = blArray;
        this.threadTask = lArray;
        this.threadId = n;
        this.newsserver = string;
        this.newsgroup = string2;
        this.timeout = basis.getTimeout();
        this.basis = basis;
        this.establishConnection();
        this.start();
    }
}

