/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;

class Show
extends CloseableFrame {
    ScanParam sp;
    ScanFile sf;
    ScanGui sg;
    Image img;
    int xs;
    int ys;
    int lastx;
    int lasty;
    int nx;
    int ny;
    ImageCanvas cv;

    public Show(ScanGui scanGui, ScanFile scanFile, ScanParam scanParam) {
        this.sp = scanParam;
        this.sf = scanFile;
        this.sg = scanGui;
        if (scanGui.preview) {
            this.setTitle("Preview");
        } else {
            this.setTitle("Scanned Image");
        }
        this.img = this.createImage(scanFile.getImage());
        this.nx = this.img.getWidth(this);
        this.ny = this.img.getHeight(this);
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("Action");
        Font font = new Font("SansSerif", 1, 12);
        menu.setFont(font);
        menuBar.add(menu);
        MenuListener menuListener = new MenuListener();
        Show.addmi(menu, "Crop", font, menuListener);
        if (scanGui.preview) {
            Show.addmi(menu, "Scan", font, menuListener);
            Show.addmi(menu, "Scan/Save", font, menuListener);
        } else {
            Show.addmi(menu, "View/Print", font, menuListener);
            Show.addmi(menu, "Browse", font, menuListener);
        }
        Show.addmi(menu, "Cancel", font, menuListener);
        this.cv = new ImageCanvas();
        this.add((Component)this.cv, "Center");
        this.cv.addMouseListener(new 1());
        this.cv.addMouseMotionListener(new 2());
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.sg.sw = null;
    }

    boolean actionOf(ActionEvent actionEvent, String string) {
        return actionEvent.getActionCommand().equals(string);
    }

    static void addmi(Menu menu, String string, Font font, MenuListener menuListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setFont(font);
        menuItem.addActionListener(menuListener);
        menu.add(menuItem);
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Show.this.xs = mouseEvent.getX();
            Show.this.ys = mouseEvent.getY();
            Show.this.lastx = Show.this.xs;
            Show.this.lasty = Show.this.ys;
            Show.this.cv.repaint();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            Show.this.xs = mouseEvent.getX();
            Show.this.ys = mouseEvent.getY();
            Show.this.cv.repaint(10L);
        }

        /* synthetic */ 2() {
        }
    }

    class MenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("Cancel")) {
                Show.this.dispose();
                Show.this.sg.sw = null;
                if (Show.this.actionOf(actionEvent, "Crop")) {
                    if (Show.this.xs > Show.this.nx) {
                        Show.this.xs = Show.this.nx;
                    }
                    if (Show.this.ys > Show.this.ny) {
                        Show.this.ys = Show.this.ny;
                    }
                    Show.this.sg.setSize(Show.this.lastx, Show.this.lasty, Show.this.xs, Show.this.ys);
                    return;
                }
                if (Show.this.actionOf(actionEvent, "Scan")) {
                    Show.this.sg.scan();
                    return;
                }
                if (Show.this.actionOf(actionEvent, "Scan/Save")) {
                    Show.this.sg.scansave();
                    return;
                }
                if (Show.this.actionOf(actionEvent, "View/Print")) {
                    Show.this.sg.vw.view();
                    return;
                }
                if (Show.this.actionOf(actionEvent, "Browse")) {
                    Show.this.sg.vw.browse();
                }
            }
        }

        MenuListener() {
            Show.this = Show.this;
        }
    }

    class ImageCanvas
    extends Canvas {
        public ImageCanvas() {
            Show.this = Show.this;
            this.setSize(Show.this.nx, Show.this.ny);
        }

        public void paint(Graphics graphics) {
            if (Show.this.img != null) {
                graphics.drawImage(Show.this.img, 0, 0, this);
            }
            graphics.clipRect(0, 0, Show.this.nx, Show.this.ny);
            graphics.setXORMode(Color.yellow);
            graphics.drawRect(Show.this.lastx, Show.this.lasty, Show.this.xs - Show.this.lastx, Show.this.ys - Show.this.lasty);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

