/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.TextComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class Settings {
    ScanGui sg;

    Settings(ScanGui scanGui) {
        this.sg = scanGui;
    }

    void save(String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.sg.save_path);
            objectOutputStream.writeObject(this.sg.scanmode);
            objectOutputStream.writeObject(this.sg.tf_bright.getText());
            objectOutputStream.writeObject(this.sg.tf_contrast.getText());
            int n = 0;
            while (n < 2) {
                objectOutputStream.writeObject(this.sg.tf_size[n].getText());
                objectOutputStream.writeObject(this.sg.tf_orig[n].getText());
                objectOutputStream.writeObject(this.sg.tf_res[n].getText());
                ++n;
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    void load(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                ((TextComponent)this.sg.tf_status).setText("Settings file, " + string + ", is missing. Save a new one.");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.sg.save_path = (String)objectInputStream.readObject();
            this.sg.lbl_dir.setText(this.sg.save_path);
            this.sg.scanmode.select(((Choice)objectInputStream.readObject()).getSelectedIndex());
            ((TextComponent)this.sg.tf_bright).setText((String)objectInputStream.readObject());
            ((TextComponent)this.sg.tf_contrast).setText((String)objectInputStream.readObject());
            int n = 0;
            while (n < 2) {
                ((TextComponent)this.sg.tf_size[n]).setText((String)objectInputStream.readObject());
                ((TextComponent)this.sg.tf_orig[n]).setText((String)objectInputStream.readObject());
                ((TextComponent)this.sg.tf_res[n]).setText((String)objectInputStream.readObject());
                ++n;
            }
            objectInputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.getMessage());
            return;
        }
    }
}

