/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;

class ScanFile {
    BufferedInputStream bf;
    Dimension reduce = new Dimension(5, 5);
    BlkWht bw;
    PcxFile pcx;
    ScanGui sg;
    char savchr;
    boolean char_saved;
    int magic;
    boolean raw;
    int w;
    int h;
    int maxclr;
    int ired;
    int igrn;
    int iblu;
    int[] pix;
    String scfile = "tmp.pnm";
    String pcx_file;
    String pcx_base;
    boolean pcx_save;

    public ScanFile(ScanParam scanParam, ScanGui scanGui) {
        this.pcx_save = scanParam.pcx_save;
        this.pcx_file = scanParam.pcx_file;
        this.sg = scanGui;
        this.char_saved = false;
        this.savchr = (char)32;
        int n = 32;
        if (scanGui.preview) {
            ((TextComponent)scanGui.tf_status).setText("Preview scan");
        } else {
            ((TextComponent)scanGui.tf_status).setText("Scanning at " + scanGui.tf_res[0].getText() + " x " + scanGui.tf_res[1].getText() + " resolution");
        }
        this.run_scanimage(scanParam, this.scfile);
        if (this.pcx_save) {
            ((TextComponent)scanGui.tf_status).setText("Creating image and saving file");
        } else {
            ((TextComponent)scanGui.tf_status).setText("Creating image");
        }
        File file = new File(this.scfile);
        if (!file.exists()) {
            ((TextComponent)scanGui.tf_status).setText("File " + this.scfile + " does not exist");
            return;
        }
        try {
            this.bf = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + fileNotFoundException.getMessage());
        }
        char c = this.getChr();
        n = c;
        if (c != 'P') {
            System.out.println("Bad magic number");
            System.exit(1);
        }
        n = this.getChr();
        this.magic = n - 48;
        if (this.magic > 3) {
            this.magic -= 3;
            this.raw = true;
        } else {
            this.raw = false;
        }
        this.w = this.getNmbr();
        this.h = this.getNmbr();
        this.maxclr = this.magic > 1 ? this.getNmbr() : 1;
        if (this.pcx_save) {
            this.pcx = new PcxFile(this.pcx_file, this.magic, this.w, this.h, this.maxclr, 300, 300);
        }
        this.reduce.width = this.w / scanParam.scrn_pix2.width + 1;
        this.reduce.height = this.h / scanParam.scrn_pix2.height + 1;
        if (this.reduce.width > this.reduce.height) {
            this.reduce.height = this.reduce.width;
        } else {
            this.reduce.width = this.reduce.height;
        }
        int n2 = this.w / this.reduce.width;
        int n3 = this.h / this.reduce.height;
        this.pix = new int[n2 * n3];
        int n4 = 0;
        try {
            if (this.raw) {
                if (this.magic == 1) {
                    this.bw = new BlkWht();
                }
                int n5 = 1;
                while (n5 <= this.h) {
                    if (this.magic == 1) {
                        this.bw.reset();
                    }
                    boolean bl = n5 % this.reduce.height == 0;
                    int n6 = 1;
                    while (n6 <= this.w) {
                        if (this.magic == 1) {
                            this.ired = this.bw.getBit();
                        } else {
                            this.ired = this.bf.read();
                            if (this.pcx_save) {
                                this.pcx.store(this.ired);
                            }
                            if (this.magic == 3) {
                                this.igrn = this.bf.read();
                                this.iblu = this.bf.read();
                                if (this.pcx_save) {
                                    this.pcx.store(1, this.igrn);
                                    this.pcx.store(2, this.iblu);
                                }
                            }
                        }
                        if (bl && n6 % this.reduce.width == 0) {
                            this.ired = 255 * this.ired / this.maxclr;
                            if (this.magic < 3) {
                                this.iblu = this.ired;
                                this.igrn = this.ired;
                            } else {
                                this.iblu = 255 * this.iblu / this.maxclr;
                                this.igrn = 255 * this.igrn / this.maxclr;
                            }
                            this.pix[n4++] = 0xFF000000 | this.ired << 16 | this.igrn << 8 | this.iblu;
                        }
                        ++n6;
                    }
                    if (this.pcx_save) {
                        this.pcx.writeLine();
                    }
                    ++n5;
                }
                if (this.pcx_save) {
                    this.pcx.finish();
                }
                this.h = n3;
                this.w = n2;
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    String tr(int n, DecimalFormat decimalFormat, double d) {
        double d2 = (double)n / 10.0;
        if (d2 > d) {
            d2 = d;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return decimalFormat.format(d2);
    }

    int tr(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    int tr(int n, int n2) {
        n = n2 * n / 100;
        return this.tr(n, -n2, n2);
    }

    void run_scanimage(ScanParam scanParam, String string) {
        String string2 = " -d " + this.sg.device;
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        String string3 = this.tr(scanParam.origmm.width, decimalFormat, 215.8);
        String string4 = this.tr(scanParam.origmm.height, decimalFormat, 355.5);
        String string5 = this.tr(scanParam.sizemm.width, decimalFormat, 215.8);
        String string6 = this.tr(scanParam.sizemm.height, decimalFormat, 355.5);
        int n = this.tr(scanParam.brightness, 127);
        int n2 = this.tr(scanParam.contrast, 127);
        int n3 = this.tr(scanParam.resolution.width, 20, 300);
        String string7 = " -l " + string3 + " -t " + string4 + " -x " + string5 + " -y " + string6;
        String string8 = " --mode " + scanParam.mode + " --brightness " + n + " --contrast " + n2 + " --resolution " + n3;
        String string9 = "scanimage";
        File file = new File(String.valueOf(string9) + ".exe");
        if (!file.exists()) {
            System.out.println("The executable file, " + string9 + " is missing");
            return;
        }
        string9 = "cmd /c " + string9 + string2 + string7 + string8 + " > " + string;
        System.out.println(string9);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string9);
            process.waitFor();
            return;
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public MemoryImageSource getImage() {
        return new MemoryImageSource(this.w, this.h, this.pix, 0, this.w);
    }

    private int getNmbr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getChr());
        while (this.chrNxt()) {
            stringBuffer.append(this.getChr());
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private char getChr() {
        char c;
        if (this.char_saved) {
            this.char_saved = false;
            return this.savchr;
        }
        try {
            do {
                c = (char)this.bf.read();
            } while (this.whitespace(c = this.skipComment(c)));
        }
        catch (IOException iOException) {
            c = ' ';
            System.out.println(iOException.getMessage());
        }
        return c;
    }

    private boolean chrNxt() {
        if (this.char_saved) {
            return true;
        }
        try {
            char c = (char)this.bf.read();
            c = this.skipComment(c);
            if (!this.whitespace(c)) {
                this.char_saved = true;
                this.savchr = c;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return false;
        }
    }

    private boolean whitespace(char c) {
        return c == ' ' | c == '\t' | c == '\n' | c == '\r';
    }

    private char skipComment(char c) throws IOException {
        if (c == '#') {
            while ((c = (char)this.bf.read()) != '\n') {
            }
        }
        return c;
    }

    class BlkWht {
        int bits_remain;
        int byt;
        int result;

        BlkWht() {
            ScanFile.this = ScanFile.this;
        }

        public int getBit() throws IOException {
            if (this.bits_remain == 0) {
                this.reset();
            }
            --this.bits_remain;
            this.result = this.byt >> this.bits_remain & 1;
            if (this.result == 0) {
                return 1;
            }
            return 0;
        }

        public void reset() throws IOException {
            this.byt = ScanFile.this.bf.read();
            this.bits_remain = 8;
            if (ScanFile.this.pcx_save) {
                ScanFile.this.pcx.store(~this.byt);
            }
        }
    }
}

