/* 
 * @(#)CorbaObj.java	1.2 99/09/07
 * 
 * Copyright 1997, 1998, 1999 Sun Microsystems, Inc. All Rights
 * Reserved.
 * 
 * Sun grants you ("Licensee") a non-exclusive, royalty free,
 * license to use, modify and redistribute this software in source and
 * binary code form, provided that i) this copyright notice and license
 * appear on all copies of the software; and ii) Licensee does not 
 * utilize the software in a manner which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE 
 * HEREBY EXCLUDED.  SUN AND ITS LICENSORS SHALL NOT BE LIABLE 
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, 
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN 
 * NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST 
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER 
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT 
 * OF THE USE OF OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS 
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and warrants
 * that it will not use or redistribute the Software for such purposes.  
 */

import javax.naming.*;
import javax.naming.directory.*;
import java.util.Hashtable;
import org.omg.CORBA.ORB;

/**
  * Demonstrates how to bind a CORBA object to a directory.
  * (Use Unbind to remove binding.)
  * COS name server NOT needed for this example.
  * 
  * NOTE: Requires ldapbp.jar, and either Java 2 Platform, v 1.2 (or higher),
  * or JavaIDL for JDK 1.1.
  *
  * Before compiling this example, you need to run 
  * # idltojava HelloApp.idl
  *
  * usage: java CorbaObj [waitForClients]
  */
class CorbaObj {
    public static void main(String[] args) {
	// Set up environment for creating initial context
	Hashtable env = new Hashtable(11);
	env.put(Context.INITIAL_CONTEXT_FACTORY, 
	    "com.sun.jndi.ldap.LdapCtxFactory");
	env.put(Context.PROVIDER_URL, "ldap://localhost:389/o=JNDITutorial");

	try {
	    // Create and initialize the ORB
	    ORB orb = ORB.init(args, null);

	    // Create servant and register it with the ORB
	    helloServant helloRef = new helloServant();
	    orb.connect(helloRef);

	    // Let service provider use the ORB
	    env.put("java.naming.corba.orb", orb);

	    // Create the initial context
	    DirContext ctx = new InitialDirContext(env);

	    // Bind to directory
	    ctx.rebind("cn=CorbaHello", helloRef); 

	    // Look up and narrow
	    HelloApp.hello h2 = HelloApp.helloHelper.narrow(
		(org.omg.CORBA.Object)ctx.lookup("cn=CorbaHello"));

	    // Invoke method on object
	    System.out.println(h2.sayHello());

	    // Close the context when we're done
	    ctx.close();

	    // If asked to keep alive for other clients
	    if (args.length > 0) {
		waitForClients();
	    }
	} catch (NamingException e) {
	    System.out.println("Operation failed: " + e);
	}
    }

    private static void waitForClients() {
	// wait for invocations from clients
	while (true) {
	    try {
		Thread.sleep(5000);
	    } catch (InterruptedException e) {
	    }
	}
    }
}

class helloServant extends HelloApp._helloImplBase {
    public String sayHello() {
	return "\nHello world !!\n" + new java.util.Date();
    }
}

