/*
File: test.java
Description: Test MsgBox
Date: 25.Nov 1996
Author: Henrik Falk
        2:236/89@fidonet.org
        81:445/16@os2net.ftn
        hfalk@ibm.net

        Released into Public Domain.
*/

import java.awt.*;

/********************************************************************
* Class: test
********************************************************************/
public class test extends Frame
{
  protected Button testButton;

  /******************************************************************
  * Function: main()
  ******************************************************************/
  public static void main(String args[])
    {

      test mainApp=new test("Test Application");

           mainApp.resize(400,200);
           mainApp.show();

    } // end function main()

  /******************************************************************
  * Constructor: test()
  ******************************************************************/
  public test(String mainTitle)
    {

      super(mainTitle);

      testButton=new Button("Test me!");
      Panel c=new Panel();
            c.setLayout(new FlowLayout());
            c.add(testButton);
      this.add("Center",c);

    } // end constructor test()

  /******************************************************************
  * Method: handleEvent()
  ******************************************************************/
  public boolean handleEvent(Event evt)
    {

      switch(evt.id)
       {
        case Event.WINDOW_DESTROY: 
                   System.exit(0);
                   return false;
        } // endswitch

    if(evt.target instanceof Button)
      {
      String choice=(String)evt.arg;

      if(choice.equals("Test me!"))
        {
        int result;

        MsgBox msg=new MsgBox();
        result=msg.show(MsgBox.MB_YESNO,"Test Application","Press 'Yes' or 'No'");

        String response;
        switch(result)
          {
            case MsgBox.MBID_YES:
                        response=new String("Yes");
                        break;
            case MsgBox.MBID_NO:
                        response=new String("No");
                        break;
            default:
                        response=new String("Ouups!");
                        break;
          } // endswitch

        MsgBox msg2=new MsgBox();
               msg2.show(MsgBox.MB_OK,"Test Application",
                    "You pressed: "+response);

        } // endif
      } // endif

      return false;

    } // end method handleEvent()

} // end class test
