/*
 *  Smart Cache , http proxy caching server
 *  Copyright (C) 1998 Radim Kolar <hsn@cybermail.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

public final class regexp
{
 public boolean ignoreCase; 

 private String elements[];
 
 private String prefix;
 private String suffix;
 
 private int prefixlen;
 private int suffixlen;
 
 private boolean exact;


 regexp(String exp, boolean ign)
 {
  ignoreCase=ign;
  exact=false;
  int i;
  
  if(exp.indexOf('*',0)==-1) { exact=true; 
                               prefix=exp; 
                               prefixlen=exp.length(); 
                               if(ign) prefix=prefix.toLowerCase();
                               return;
                             }
  i=1;
  if(!exp.startsWith("*"))
   {
    /* mame prefix */
    prefix=exp.substring(0,exp.indexOf('*',0));
    if(ign) prefix=prefix.toLowerCase();
    prefixlen=prefix.length();
    i=prefixlen+1;
   }
   int pos;
   String part;
   while(true)
   {
    pos=exp.indexOf('*',i);
    if(pos==-1)
      {
       /* mame suffix */
       if(i==exp.length()) return;
       suffix=exp.substring(i);
       if(ign) suffix=suffix.toLowerCase();
       suffixlen=suffix.length();
       return;
      }
      
    part=exp.substring(i,pos);
    if(ign) part=part.toLowerCase();
    if(!part.equals(""))
     {
      /* pridame part do pole */
      
       if(elements==null) elements=new String[1];
        else
       {
        String tmp[]=new String[elements.length+1];
        System.arraycopy(elements,0,tmp,0,elements.length);
        elements=tmp;
       } 
      elements[elements.length-1]=part;
     }/* pridani */
     
    i=pos+1;
    if(i>=exp.length()) break;
    
   
   }/* while */
 
 }
 
 /* DEBUG VERZE
 public String toString()
 {
  String result="prefix="+prefix+"\nsuffix="+suffix+"\nelements=";
  if (elements==null) return result+="null";
  for(int i=0;i<elements.length;i++)
   result+=elements[i]+",";

  return result;
 }
 */
 
 
 final public String toString()
 {
  if(exact==true) return prefix;
  String result;
  if(prefix==null) result="*";
   else
    result=prefix;
  /* pridat elementy */
  if(elements!=null)
   for(int i=0;i<elements.length;i++)
     result+=elements[i]+"*";
  
  /* suffix */
  if(suffix!=null) result+=suffix;
   else
    if(elements==null) result+="*";
  
  return result;
 }
 final public boolean matches(String str)
 {
  int pos;
  pos=0;
  if(ignoreCase) str=str.toLowerCase();
  if(exact) return str.equals(prefix);
  
  if(prefix!=null)
   if(!str.startsWith(prefix)) return false;
       else
     pos=prefixlen;
  if(elements!=null)
   {
    int j=elements.length;
    for(int i=0;i<j;i++)
     {
     if( (pos=str.indexOf(elements[i],pos))==-1 ) return false;
     pos+=elements[i].length();
     }
   }
  if(suffix==null) return true; 
  if(str.length()-pos<suffixlen) return false;
  
  return str.endsWith(suffix);
 }
 
 /*
 public static void main(String argv[])
 {
  if (argv.length<2) return;
  regexp r=new regexp(argv[0],false);
  System.out.println(r);
  System.out.println("Matches : "+argv[1]+" : "+r.matches(argv[1]));
 }
 */
}