import java.util.NoSuchElementException;

public final class priorityqueue
{
 /* synonimum varianta     */
 /* idea from Jachym Kolar */
 
 protected Queue queues[];
 protected float  priorities[];
 
 protected static final int DEFAULTQUEUES=5;
 protected static final int DEFAULTINCREMENT=5;
 protected static final float INTERNAL_FREE_MARK=-999.9f;
 protected int increment;


 public priorityqueue()
 {
  this(DEFAULTQUEUES,DEFAULTINCREMENT);
 }
 
 public priorityqueue(int size)
 {
  this(size,DEFAULTINCREMENT);
 }
 
 public priorityqueue(int size,int increment)
 {
  if(size<=0) throw new IllegalArgumentException("size(queues) <= 0");
  if(increment<0) throw new IllegalArgumentException("increment < 0");
  queues=new Queue[size];
  priorities=new float[size];
  for(int i=size-1;i>=0;i--)
   priorities[i]=INTERNAL_FREE_MARK;
  this.increment=increment;
 }

 public synchronized Object push(Object item) 
 {
  return push(item,1f);
 }

 public synchronized Object push(Object item,float prio) 
 {
  // najdi patricnou pozici
  for(int i=priorities.length-1;i>=0;i--)
   {
    Queue q;
    q=queues[i];
    float pc;
    pc=priorities[i];
    if(pc==prio) 
     if(q!=null) {q.push(item);notify();return item;}
      else
                 { q=new Queue(increment,increment);
                   queues[i]=q;
                   q.push(item);
                   notify();
                   return item;
                 }
    if(pc==INTERNAL_FREE_MARK) 
      { add(i,prio,item);notify();return item;}
   }
  // pridat....
  //System.out.println("INCREASING STORAGE");
  float ftmp[]=new float[priorities.length+increment];
  Queue qtmp[]=new Queue[priorities.length+increment];
  //System.arraycopy(priorities,0,ftmp,increment,priorities.length);
  for(int i=0;i<increment;i++)
   ftmp[i]=INTERNAL_FREE_MARK;
  //System.arraycopy(queues,0,qtmp,increment,priorities.length);
  priorities=ftmp;
  queues=qtmp;
  add(increment-1,prio,item);
  notify();
  return item;  
  
  // throw new OutOfMemoryError("Out of Queue Space!");
  // return null;
 }
 
 public String toString()
 {
  StringBuffer sb;
  sb=new StringBuffer(128);
  for(int i=priorities.length-1;i>=0;i--)
   sb.append(priorities[i]+" ");
  return sb.toString();
 }
 
 public synchronized Object pop()
 {
  int pos=queues.length;
  while(true)
  try
   {
    return queues[--pos].pop();
   }
   catch
    ( NullPointerException ignore)
          {continue;}
   catch
    ( NoSuchElementException ignore)
          {queues[pos]=null;continue;}
   catch
    ( ArrayIndexOutOfBoundsException br)
      {break;}
      
   throw new NoSuchElementException();
   
 }
 
 public synchronized int search(Object item)
 {
  int pos=queues.length;
  int add=0;
  int i;
  while(true)
  {
   try
   {
    i=queues[pos].search(item);
    if(i==-1) add+=queues[pos].queuesize();
      else
       return i+add;
   }
   catch
    ( NullPointerException ignore)
          {continue;}
   catch
    ( ArrayIndexOutOfBoundsException br)
      {break;}
   
  }
  return -1;
 }
 
 public Object peek()
 {
  int pos=queues.length;
  while(true)
  try
   {
    return queues[--pos].peek();
   }
   catch
    ( NullPointerException ignore)
          {continue;}
   catch
    ( NoSuchElementException ignore)
          {queues[pos]=null;continue;}
   catch
    ( ArrayIndexOutOfBoundsException br)
      {break;}
      
   throw new NoSuchElementException();
   
 }
 
       // pridej ho tedy
 protected Object add(int i,float prio,Object item)
 {
      Queue q;
      //System.out.println("adding "+prio+", free at "+i);
      int inew=i; // zjisti misto, kam ho zaradit
      /* 9 - 1
         5 - 0.5
         2 - 0.1
         */
      if(i<priorities.length-1 && priorities[i+1]<prio  )
      {
      for(int j=i+1;j<priorities.length;j++)
       if(priorities[j]>prio) 
         {
          //System.out.println("making room for "+prio+" at "+j+"\n"+this);
          System.arraycopy(priorities,i+1,priorities,i,j-i);
          System.arraycopy(queues,i+1,queues,i,j-i);
          //System.out.println("after room make "+this);
          inew=j-1;break;
         }
      } 
      q=new Queue(increment,increment);
      queues[inew]=q;
      priorities[inew]=prio;
      return q.push(item);
     }
}