/*
 *  Smart Cache , http proxy caching server
 *  Copyright (C) 1998 Radim Kolar <hsn@cybermail.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.net.*;

public final class minicachedir extends localdir{

public static final String DIRINFO=".cacheinfo";

minicachedir(String locdir)
{
 super(locdir);
}

protected final void localinit()
{
 File f=new File(name);
 if(!f.exists() || !f.isDirectory())
  {
   return;
  }
 /* nacteme cachovane objekty */
 
 DataInputStream is=null;
 try{
 is=new DataInputStream( 
                 new BufferedInputStream(
                 new FileInputStream( name+DIRINFO ),4096));
                 
 int howmany=is.readInt();
 for(int i=0;i<howmany;i++)
  {
   localurl lu;
   String name,ctype,localname,location;
   long date;

   name=is.readUTF();
   ctype=is.readUTF();
   localname=is.readUTF();
   location=is.readUTF();
   if(location.length()==0) location=null;
   is.readInt();
   is.readInt();
   is.readLong();
   date=is.readLong();
   is.readLong();
   is.readLong(); 

   if(localname.equals("<>")) continue;
   
   lu=new localurl(this.name,name,localname,ctype,location,date);
   objects.put(name,lu);
  }
 is.close(); 
 }
 catch(IOException e) {
                       try{
                         if(is!=null) { System.out.println("I/O error reading "+name+DIRINFO+" ,file corrupted?");
                                        is.close();
                                      }
                          }
                        catch (IOException z) {}  
                       };
} /* konstruktor */



} /* class */
