import java.io.*;
import java.util.*;
import java.net.*;

public final class location implements Cloneable
{

 public String locbase; /* URL http://zero.org/ */
 public String starturl[]; /* url pro zahajeni sosani */
 public String name;  /* alias i.e. netmag */
 public String aliases[]; /* aliases for location */

 /* don't start auto-fetching */
 public boolean passive;
 
 /* default policy true=ACCEPT, false=REJECT */
 public boolean accept; 
 
 public float priority; /* 0.0 - XX ? */

 public short depth;
 
 public final static byte ANY=3;
 public final static byte SPECIFIED=1; 
 public final static byte INCLUDING_DEFAULTS=2;

 public byte content;
 public byte masks;
 public byte action;
 
 /* default action string */  
 public options actions;
 public mask defaultmask;
 
 public mask ctmasks[];
 public mask urlmasks[];

 public location(String loc,location def)
 {
  this(loc);
  
  // copy default location settings
  passive=def.passive;
  accept=def.accept;
  priority=def.priority;
  depth=def.depth;
  content=def.content;
  masks=def.masks;  
  action=def.action;
  
  if(action==INCLUDING_DEFAULTS) actions=def.actions; // TODO: ???? is this OK??
    else
   actions=new options(""); 
   
   
  defaultmask=new mask(actions);
  
 }
 
 public location(String loc)
 {
  /* location check */
  if(!loc.endsWith("/")) throw new IllegalArgumentException("Location must end with /");
  /* end loc. check */
  
  locbase=loc;
  
  aliases=null;
  name=null;
  starturl=null;
  
  actions=new options("");
  
  systemdefaults();
  defaultmask=new mask(actions);
 }
 
 private final void systemdefaults()
 {
  passive=true;
  accept=true;
  priority=1.0f;
  depth=4;
  content=INCLUDING_DEFAULTS;
  masks=INCLUDING_DEFAULTS;  
  action=INCLUDING_DEFAULTS;
  
  }
 
 /* server-options parser */
 /* - for defaultoptions (options o) */
 /* - for normal server (options o,options default) */
 
 public final void serveroptions(options o)
 {
  if(o.parsed.size()==0) return;
  
  StringTokenizer st=new StringTokenizer((String)o.parsed.elementAt(0));
  
  try
  {
   /* skip options */
   st.nextToken();
   
   while(true)
   {
    String s;
    boolean ok;
    s=st.nextToken();
    ok=true;
    if(s.length()==1 && s.charAt(0)=='!')
     {
      ok=false;
      s=st.nextToken();
     }
    // System.out.println("opt="+s);
    /* */
    if(s.equals("systemdefaults") && ok==true)
     systemdefaults();
    else if( s.equals("passive") || 
             s.equals("nofetch") 
           ) 
                 passive=ok;
    else if( s.equals("active") || 
             s.equals("autostart") 
           ) 
                 passive=!ok;

    else if( s.equals("default") || 
             s.equals("none") 
           ) 
                 ;
                 
    else if( s.equals("nodefaults") && ok==true
           ) 
            {
		  content=SPECIFIED;
		  masks=SPECIFIED;  
		  action=SPECIFIED;
            }
    else if( s.equals("reject")
           ) 
                 accept=!ok;
    else if( s.equals("accept")
           ) 
                 accept=ok;
                 
    else if( s.equals("nodefaulturlmasks") || 
             s.equals("nomasks") 
           ) 
                 if(ok) masks=SPECIFIED;
                   else masks=INCLUDING_DEFAULTS;

    else if( s.equals("nodefaultcontentmasks") || 
             s.equals("nocontent") 
           ) 
                 if(ok) content=SPECIFIED;
                   else content=INCLUDING_DEFAULTS;

    else if( s.equals("nodefaultactions") || 
             s.equals("noaction") 
           ) 
                 if(ok) action =SPECIFIED;
                   else action =INCLUDING_DEFAULTS;
                   
    else if( s.equals("anycontent")
           ) 
                 if(ok) content = ANY;
                   else content =INCLUDING_DEFAULTS;

    else if( s.equals("anyurl")
           ) 
                 if(ok) masks   = ANY;
                   else masks   = INCLUDING_DEFAULTS;
                                                           
    else /* not known */
     System.err.println("[CONFIG_ERROR] Unknown server option "+s);
     
     
    st.nextToken();
   
   }
  }
  catch (NoSuchElementException eof)
  {}
 
 }
 
 public final void setPriority(float f)
 {
  if(f<0) f=0;
  priority=f;
 }

 public final void setDepth(short d)
 {
  if(d<-1) d=-1;
  depth=d;
 }
 
 public final void setActions(options my, options xdefault)
 {
  if(my==null) return;
  actions=my;
  if(xdefault==null || action==SPECIFIED) { defaultmask=new mask(actions);return;}
  my.addDefault(xdefault);
  defaultmask=new mask(actions);
 }
 
 public final void addActions(options add, boolean updatedefault)
 {
  if(add==null) return;
  add.addDefault(actions);
  actions=add;
  if(updatedefault) defaultmask=new mask(actions);
 }
 
 public final void addMask(options o)
 {
 // add defaults
 o.addDefault(actions);
 mask m;
 m=new mask(o);
 if(m.hasContent()) ctmasks=util.addMaskToArray(m,ctmasks);
  else
   urlmasks=util.addMaskToArray(m,urlmasks);
 }
 
 public final void setName(String s)
 {
  if(s==null) return;
  name=s;
 }
 
 public final void addAlias(String s)
 {
  if(s==null) return;
  if(!s.endsWith("/")) throw new IllegalArgumentException("Alias must end with /");
  // s=s.toLowerCase();
  // check 4 dupez
     if(s.startsWith(locbase)) return;
     if(aliases!=null)
      for(int i=aliases.length-1;i>=0;i--)
       if(s.startsWith(aliases[i])) return;
       
     aliases=util.addStringToArray(s,aliases);  
 }
 
 public final void addStartURL(String start)
 {
  if(start==null) return;
  if(start.indexOf("://")==-1) return;
  URL u;
  try
  {
    // check 4 dupez
    if(starturl!=null)
      for(int i=starturl.length-1;i>=0;i--)
        if(starturl[i].equals(start)) return;
    u=new URL(start);
    start=u.getProtocol()+"://"+u.getHost()+
     ( u.getPort()==-1?"":(":"+u.getPort())  )
       +u.getFile();
    starturl=util.addStringToArray(start,starturl);
  }
  catch (MalformedURLException badurl)
  {}
 
 }
 
 public final boolean processURL(String frombase,String fromdir,short fdepth, boolean fdepthset,String url, String src)
 {
  // zjisti target  
  byte target=mask.getTarget(frombase,fromdir,locbase,url);
  // System.out.println("url="+url+" target="+target);
  
  // depth check
  if(fdepth<0) return false;
  if(src.equals("A") && fdepth<1) return false;
  
  if( masks==ANY )
     if ( (target & mask.TARGET_ME)!=0)  
       {
         loader.pq.push(new request(url,this,defaultmask,--fdepth,fdepthset),priority*defaultmask.q);
         return true;
       }
     else
      return false; // bad target..ignoring for mask=any
      
 String ext=util.getExt(url);
 // System.out.println("url="+url+" ext="+ext);
 
 if(urlmasks!=null)
 {
   for(int i=0;i<urlmasks.length;i++)
    if(urlmasks[i].match(url,ext,src,target,locbase))
     {
         loader.pq.push(new request(url,this,urlmasks[i],--fdepth,fdepthset),priority*urlmasks[i].q);
         return true;
     }
 }
 if(masks==INCLUDING_DEFAULTS)
 {
   // System.out.println("go here:)");
   for(int i=0;i<loader.def.urlmasks.length;i++)
    if(loader.def.urlmasks[i].match(url,ext,src,target,locbase))
     {
         loader.pq.push(new request(url,this,loader.def.urlmasks[i],--fdepth,fdepthset),priority*loader.def.urlmasks[i].q);
         return true;
     }
 }
 
 if(accept==true && (target&defaultmask.target)!=0)
  {
         loader.pq.push(new request(url,this,defaultmask,--fdepth,fdepthset),priority*defaultmask.q);
         return true;
  }  
 else 
  return false;
    
 }
 
 public final void transferAliases(location def)
 {
  if(def.aliases!=null) 
    if(aliases==null)
       { aliases=def.aliases;def.aliases=null;}
     else
      {
       // apend it to me
       for(int i=0;i<def.aliases.length;i++)
         addAlias(def.aliases[i]);
       def.aliases=null;
      }
 }
 
 public final void transferStartURL(location def)
 {
  if(def.starturl!=null)
    if(starturl==null) { starturl=def.starturl;def.starturl=null;}
     else
     {
       // apend it to me
       for(int i=0;i<def.starturl.length;i++)
         addStartURL(def.starturl[i]);
       def.starturl=null;
     
     }
 }
  
}
