import java.io.*;
import java.util.*;

/* localstore */
public class localstore
{
 protected String arg[];

 private Hashtable dirs;
 
public localstore(String argv[])
{
  if(argv==null) arg=new String[0];
   else
   arg=argv;

 // static init
 init(arg);
 localinit();
}

protected void localinit()
{
 if(arg.length==0) 
  {
    arg=new String[1];
    arg[0]="data"+File.separator;
  } else if(!arg[0].endsWith(File.separator))
	     arg[0]+=File.separator;
  dirs=new Hashtable();
}

 public String toString()
 {
  return "SIMPLE localstore";
 }

 public boolean isReadOnly()
 {
  return false;
 }

 public void close()
 {
  if(dirs==null) return;
  // System.out.println("[debug] closing localstore");
  Enumeration en=dirs.elements();
  while(en.hasMoreElements())
  {
   ((localdir)en.nextElement()).close();
  }
  dirs=null;
}  
 
 public localurl getURL(String URL) throws java.net.MalformedURLException
 {
  String parsed[]=parseURL(URL);
  StringBuffer ld=new StringBuffer(80);
  // System.out.println("Parsed: host="+parsed[0]+" port="+parsed[1]+" dir="+parsed[2]+" file="+parsed[3]+" proto="+parsed[4]+" auth="+parsed[5]);
  ld.append(arg[0]);
  /* host */
  ld.append(parsed[0]);
  /* port */
  if(parsed[1]!=null) {
                         ld.append('_');
                         ld.append(parsed[1]);
		      }
  /* protocol */
  if(parsed[4]!=null)
                      {
		         ld.append('^');
			 ld.append(parsed[4]);
	              }
 /* directory */
 if(File.separatorChar!='/') parsed[2].replace('/',File.separatorChar);
 ld.append(parsed[2]);
  
 return getLocaldir(ld.toString()).getObject(parsed[3]);
 }

 private localdir getLocaldir(String directory)
 {
  synchronized (dirs)
  {
   localdir ld=(localdir)dirs.get(directory);
   if(ld!=null) return ld;
   ld=new localdir(directory);
   dirs.put(directory,ld);
   return ld;
  }
 }

 protected static void init(String arg[])
 {
   localdir.init(arg);
   localurl.init(arg);
 }
 
/*  prechrousta URL a vrati
0 - hostname
1 - port (if any) jinak null
2 - directory
3 - file including query string ("" if empty)
4 - protocol (null if http)
5 - Auth string (null if empty)
*/

final public static String[] parseURL(String url) throws java.net.MalformedURLException
{
  String[] res=new String[6];
  res[3]=""; /* HashTable do not likes NULL */
  int i,j,seven;
  i=url.indexOf("://");
  if(i==-1) throw new java.net.MalformedURLException(url);
  res[4]=url.substring(0,i);
  /* protocol check */
  seven=i+3; /* '://' */
  
  if(seven==7)
   {
    char c;
    c=url.charAt(0);
    if(c=='h' || c=='H') res[4]=null; /* HTTP protocol */
   }

  i=url.indexOf('/',seven);
  if(i==-1) { url+='/'; i=url.length()-1;}

   /* check for losername/password */
 try
 {
  int zav=url.indexOf('@',seven);
  if(zav>0)
   {
    /*   @   / - ok     */ 
    /*   /  @ - ignore  */
    if( i>zav)
    {
     /* mame heslo */
     res[5]=url.substring(seven,zav);
     seven=zav+1;
    }
   }
 }
 catch (Exception e) 
   { throw new java.net.MalformedURLException(url);} // So no need to check index out of bounds

  
  j=url.indexOf(':',seven);
  /* http://zero.dsd:434/ */
  if(j!=-1 && j<i)  /* mame tu portname */
                    {
                      res[0]=url.substring(seven,j).toLowerCase();
                      res[1]=url.substring(j+1,i);
                      if(res[1].equals("80")) res[1]=null;
                    }
           else
             {
              res[0]=url.substring(seven,i).toLowerCase();
             }

  j=url.length()-1;
   byte v[];
   v=new byte[j+1];
   url.getBytes(i,j+1,v,i);
   // getChars(i,j,v,0);
   loop1:for(int zz=i;zz<=j;zz++)
    {
    switch(v[zz])
    {
    case 0x3b: // ;
    case 0x3a: // :
    case 0x3d: // =
    case 0x3f: // ?
              j=zz;break loop1;
    case 0x23: // #
     url=url.substring(0,zz);break loop1;
    }
    }
   j=url.lastIndexOf('/',j);

  res[2]=url.substring(i,j+1); // adresar
  if(j+1!=url.length()) res[3]=url.substring(j+1);
  
  return res;  
}
} 
