/* 

0- 1
1- 2

*/

import java.util.Vector;
import java.util.NoSuchElementException;

public class Queue extends Vector
{

  public Queue(int a,int b)
  {
   super(a,b);
  }
  
    public Object push(Object item) {
	addElement(item);

	return item;
    }
    public synchronized Object pop() {
	Object	obj;
	int	len = size();

	obj = peek();
	removeElementAt(0);

	return obj;
    }

    /**
     * Looks at the object at the top of this stack without removing it 
     * from the stack. 
     *
     * @return     the object at the top of this stack. 
     * @exception  EmptyStackException  if this stack is empty.
     * @since      JDK1.0
     */
    public synchronized Object peek() {
	int	len = size();

	if (len == 0)
	    throw new NoSuchElementException();
	return elementAt(0);
    }

    /**
     * Returns where an object is on this stack. 
     *
     * @param   o   the desired object.
     * @return  the distance from the top of the stack where the object is]
     *          located; the return value <code>-1</code> indicates that the
     *          object is not on the stack.
     * @since   JDK1.0
     */
    public synchronized int search(Object o) {
	int i = indexOf(o);

	if (i >= 0) {
	    return i;
	}
	return -1;
    }
    
    public int queuesize()
    {
     return super.size();
    }



}