/* *******************************************************
 * 
 * name:          IniListener.java
 * 
 * description:   Interface for classes that wish to get
 *                informed when options in the ini-file change
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

/**
 * Implement this Interface so that a class can receive 
 * IniFile-events. A class should check in the iniChange
 * function whether it is its section, then according to
 * the key it knows which of the parameters was the one
 * that was changed. For example, if a module stores an
 * integer value in the section &quot;ShiftFrequency&quot;, key
 * &quot;LastFrequency&quot; so that it can restore the value when
 * the module is called the next time, it would know,
 * that this type of IniChange supplies the changed value
 * in the integer field.<BR>
 * As, for now, no useful values are stored in the IniFile
 * by JaWavedit, this functionality is not probably
 * not necessary in a module.
 */
public interface IniListener {
  public void iniChange(String section,String key,String s,int i,boolean b);
}