/* *******************************************************
 * 
 * name:          HoriLine.java
 * 
 * description:   Displays a horizontal line
 *
 * Author:        Florian Bomers
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

import java.awt.*;

/**
* This small component just displays a horizontal line.
* It is useful to separate sections in a window.
* For example, this command is used to display the
* line right under the menu in JaWavedit:<BR>
* <pre>
*   P.add("North",new HoriLine());
* </pre>
*/

public class HoriLine extends Canvas {
  
  public void paint(Graphics g) {
    Dimension dim = getSize();
    // mettre la ligne au milieu 
    int middle=(dim.height/2)-1;
    g.setColor(Color.gray);
    g.drawLine(0,middle,dim.width,middle);
    g.setColor(Color.white);
    g.drawLine(0,middle+1,dim.width,middle+1);
  }
  
  public Dimension getPreferredSize() {
    return new Dimension(0,2);
  }
}