/* *******************************************************
 * 
 * name:          Info.java
 * 
 * description:   A StereoModule which offers a window
 *                to set the "description" text of a wavefile.
 *
 * Author:        Niels Thorwirth
 *
 * (c) by         Florian Boemers  fbomers@erato.unice.fr
 *                  or JaWavedit@bome.com
 *                Robin Pouget     rpouget@erato.unice.fr
 *                Niels Thorwirth  niels-t@usa.net
 *
 ********************************************************* */

/**
*  Module qui permet de lire et ecrire une text 
*  qui va etre stocke dans le 'header' du son 
*/

import java.awt.*;
import java.awt.event.*;

public class Info extends Dialog implements StereoModule,
WindowListener,ActionListener
{
  private WaveFile FWaveFile;
  private TextArea info_tf;
  private Button ok_bt;
  
  public void apply(WaveFile wf,Selection sel){
    FWaveFile = wf;
    info_tf.setText(FWaveFile.getDescription());
    info_tf.invalidate();
    setVisible (true);
  }
  
  public Info(Frame parent) {
    // constructeur qui va creer une interface
    super (parent,true);
    setTitle ("Traiter le Caracteres d'information");
    addWindowListener(this);
    setResizable(true);
    
    Panel p = new Panel();
    p.setLayout (new GridLayout(2,1));
    add ("North",p);
    p.add (new Label("Texte d'information"));
    p.add (new Label("La ligne de Information qui va etre sauvgarde dans le fichier "));
    info_tf = new TextArea("",5,50);
    add ("Center",info_tf);
    
    ok_bt = new Button ("OK");
    ok_bt.addActionListener (this);
    add ("South",ok_bt);
    
    pack();
    setSize(140,360);
  }  
  
  // methodes pour traiter les evenements
  public void actionPerformed (ActionEvent e) {
    if (e.getSource()==ok_bt) {
      FWaveFile.setDescription(info_tf.getText());
      setVisible(false);
    }
  }
  
  public void windowClosed(WindowEvent event) {}
  public void windowDeiconified(WindowEvent event) {}
  public void windowIconified(WindowEvent event) {}
  public void windowActivated(WindowEvent event) {}
  public void windowDeactivated(WindowEvent event) {}
  public void windowOpened(WindowEvent event) {}
  public void windowClosing(WindowEvent event) { setVisible(false); }
}