/*
 * Decompiled with CFR 0.152.
 */
import java.util.Locale;

public class LangBase {
    protected static int lang = LangBase.findLang();
    private static final Locale[] AvailLang = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH};
    private static final String[] AvailLangNames = new String[]{"English", "Deutsch", "Fran\u00e7ais"};
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int APPLY = 2;
    public static final int RETRY = 3;
    public static final int YES = 4;
    public static final int NO = 5;
    public static final int FILE = 6;
    public static final int NEW = 7;
    public static final int OPEN = 8;
    public static final int SAVE = 9;
    public static final int SAVE_AS = 10;
    public static final int SAVE_ALL = 11;
    public static final int SAVE_SEL_AS = 12;
    public static final int REOPEN = 13;
    public static final int NEW_WINDOW = 14;
    public static final int CLOSE = 15;
    public static final int EDIT = 16;
    public static final int UNDO = 17;
    public static final int CUT = 18;
    public static final int COPY = 19;
    public static final int PASTE = 20;
    public static final int FIND = 21;
    public static final int SELECTION = 22;
    public static final int DESELECT = 23;
    public static final int SELECT_ALL = 24;
    public static final int WINDOW = 25;
    public static final int HELP = 26;
    public static final int CONTENTS = 27;
    public static final int ABOUT = 28;
    public static final int DOYOUWANTTOSAVE_S = 29;
    public static final int LOADING_WAIT = 30;
    public static final int SAVING_WAIT = 31;
    public static final int OPERATION_ABORTED = 32;
    public static final int LOADED_S = 33;
    public static final int SAVED_S = 34;
    public static final int EXECUTED_S = 35;
    public static final int APPLIED_S = 36;
    public static final int SUCCESFUL = 37;
    public static final int NO2 = 38;
    public static final int PREPARE_UNDO = 39;
    public static final int STORING_UNDO = 40;
    public static final int ERROR_STORING_UNDO = 41;
    public static final int PROB_MEM_ERR = 42;
    public static final int STILL_CONTINUE = 43;
    public static final int NO_UNDO_AVAIL = 44;
    public static final int OPTIONS = 45;
    public static final int RESET = 46;
    public static final int LANGUAGE = 47;
    protected static final String[][] std = new String[][]{{"OK", "Cancel", "Apply", "Retry", "Yes", "No", "File", "New", "Open", "Save", "Save As", "Save All", "Save Selection As", "Re-Open", "New Window", "Close", "Edit", "Undo", "Cut", "Copy", "Paste", "Find", "Selection", "Deselect", "Select All", "Window", "Help", "Contents", "About", "Do you want to save your recent changes of %s ?", "loading... please wait", "saving... please wait", "operation aborted", "loaded %s succesfully", "saved %s succesfully", "executed %s succesfully", "applied %s succesfully", "succesful", "", "preparing Undo...", "storing undo-informations", "Error during storing undo", "That is probably a memory error.", "Do you still want to continue ?", "No Undo available", "Options", "Reset", "Language"}, {"OK", "Abbrechen", "\u00dcbertragen", "Wiederholen", "Ja", "Nein", "Datei", "Neu", "\u00d6ffnen", "Speichern", "Speichern unter", "Alles Speichern", "Markierung speichern unter", "Wieder\u00f6ffnen", "Neues Fenster", "Schlie\u00dfen", "Bearbeiten", "R\u00fcckg\u00e4ngig", "Ausschneiden", "Kopieren", "Einf\u00fcgen", "Suchen", "Markierung", "Nichts markieren", "Alles markieren", "Fenster", "Hilfe", "Inhalt", "\u00dcber", "Wollen Sie die letzten \u00c4nderungen in %s speichern ?", "l\u00e4dt... bitte warten", "speichert... bitte warten", "Vorgang abgebrochen", "%s erfolgreich geladen", "%s erfolgreich gespeichert", "%s erfolgreich ausgef\u00fchrt", "%s erfolgreich angewendet", "erfolgreich", "", "Undo wird vorbereitet...", "R\u00fcckg\u00e4ngig-Informationen werden gesichert...", "Fehler w\u00e4hrend des sicherns des Undo.", "Dies ist wahrscheinlich ein Speicherfehler.", "Wollen Sie trotzdem fortfahren ?", "Undo ist nicht verf\u00fcgbar", "Optionen", "Reset", "Sprache"}, {"OK", "Annuler", "Appliquer", "Refaire", "Oui", "Non", "Fichier", "Nouveau", "Ouvrir", "Enregistrer", "Enregistrer sous", "Sauver tout", "Enregistrer s\u00e9lection sous", "Re-ouvrier", "Nouvelle fen\u00eatre", "Fermer", "Editeur", "Annuler", "Couper", "Copier", "Coller", "Rechercher", "S\u00e9lection", "S\u00e9lectionner rien", "S\u00e9lectionner tout", "Fen\u00eatre", "Aide", "Sommaire", "A propos", "Voulez vous enregistrer les changements dans %s ?", "charger... attendez s'il vous pla\u00eet", "sauver... attendez s'il vous pla\u00eet", "Op\u00e9ration annull\u00e9", "Charg\u00e9 %s avec succ\u00e8s", "Sauv\u00e9 %s avec succ\u00e8s", "Ex\u00e9cut\u00e9 %s avec succ\u00e8s", "Appliqu\u00e9 %s avec succ\u00e8s", "avec succ\u00e8s", "", "Pr\u00e9paration de l'undo...", "Sauve les informations pour l'undo...", "Erreur pendant sauver l'undo.", "C'est probablement un erreur de m\u00e9moire.", "Voulez vous continuer quand m\u00eame ?", "Undo n'est pas disponible", "Options", "Reset", "Langue"}};

    private static int findLang() {
        try {
            String string = System.getProperty("user.language", "").substring(0, 2);
            if (string.equalsIgnoreCase("fr")) {
                return 2;
            }
            if (string.equalsIgnoreCase("de")) {
                return 1;
            }
        }
        catch (Throwable throwable) {}
        return 0;
    }

    public static int getLangCount() {
        return AvailLangNames.length;
    }

    protected static void setLangName(String string) {
        int n = 0;
        while (n < AvailLangNames.length) {
            if (AvailLangNames[n].equals(string)) {
                lang = n;
                return;
            }
            ++n;
        }
    }

    protected static void setLangIndex(int n) {
        if (AvailLangNames.length > n) {
            lang = n;
        }
    }

    public static int getLangIndex(String string) {
        int n = 0;
        while (n < AvailLangNames.length) {
            if (AvailLangNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static String getLangName() {
        return AvailLangNames[lang];
    }

    public static String getLangName(int n) {
        if (AvailLangNames.length > n) {
            return AvailLangNames[n];
        }
        return AvailLangNames[0];
    }

    public static int getLangIndex() {
        return lang;
    }

    public static Locale getLangLocale(String string) {
        int n = 0;
        while (n < AvailLangNames.length) {
            if (AvailLangNames[n].equals(string)) {
                return AvailLang[n];
            }
            ++n;
        }
        return AvailLang[0];
    }

    public static String getStr(int n) {
        return std[lang][n];
    }
}

