/*
File: sample4.java
Description: Test the setIniData() and getIniData() methods in
             class Os2Ini.
Date: 22.Apr 1997
Author: Henrik Falk
        2:236/89@fidonet.org
        81:445/12@os2net.ftn
        hfalk@ibm.net

        Freeware!
*/

import java.io.*;

/********************************************************************
* Class: sample4
********************************************************************/
public class sample4
{

  /******************************************************************
  * Method: main()
  ******************************************************************/
  public static void main(String args[])
  {

    // create a new Os2Ini Object;
    Os2Ini ini=new Os2Ini();

    System.out.println("Saving key: 'x0j4w'");

    // Add some bytes to a byte array
    byte[] inBuffer=new byte[5];
           inBuffer[0]='x';
           inBuffer[1]='0';
           inBuffer[2]='j';
           inBuffer[3]='4';
           inBuffer[4]='w';

    // Save the binary byte buffer    
    System.out.println("Calling: Os2Ini.setIniData()\n");
    boolean bRC=ini.setIniData("TEST.INI","APP","DATA",inBuffer);
    if(bRC==false)
    {
      System.out.println("Error! Os2Ini.setIniData() returned FALSE");
    }

    // Get size of buffer and print it
    System.out.println("Calling: Os2Ini.getIniSize()\n");
    int num=ini.getIniSize("TEST.INI","APP","DATA");
    System.out.println("Number of bytes saved: "+num);

    // Create an outbuffer to hold the data from the key
    byte[] outBuffer=new byte[num];

    // Get the byte array from the ini file
    System.out.println("Calling: Os2Ini.getIniData()\n");
    outBuffer=ini.getIniData("TEST.INI","APP","DATA");

    // Print the byte array.
    // This is not normally done. A binary key could be a encrypted
    // text or a image and not something printet to stdout
    try
    {
      System.out.write(outBuffer);
    }
    catch(IOException e)
    { 
    System.exit(0);
    }
    System.out.println();

  } // end method main()

} // end class sample4
