/*
File: sample2.java
Description: Test the getIniSize() method in class Os2Ini.
             The method returns the length in bytes of a key.
             Notice that I have not verified that the application
             and key in this sample exists in all WARP4 versions.
             If you don't have the key, the method returns zero.
Date: 22.Apr 1997
Author: Henrik Falk
        2:236/89@fidonet.org
        81:445/12@os2net.ftn
        hfalk@ibm.net

        Freeware!
*/

/********************************************************************
* Class: sample2
********************************************************************/
public class sample2
{

  /******************************************************************
  * Method: main()
  ******************************************************************/
  public static void main(String args[])
  {

    // create a new Os2Ini Object;
    Os2Ini ini=new Os2Ini();

    // Get os2.ini and os2sys.ini
    String[] sys=ini.getIniSystem();

    // Get the size of a key in os2.ini
    System.out.println("Calling: Os2Ini.getIniSize()\n");
    int len=ini.getIniSize(sys[0],"PM_Workplace:WindowListPos","SavePos");

    // Print it out
    System.out.println("File       : "+sys[0]);
    System.out.println("Application: PM_Workplace:WindowListPos");
    System.out.println("Key        : SavePos");
    System.out.println("Length     : "+len);

  } // end method main()

} // end class sample2
