/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import starwave.util.regexp.NoSuchMatchException;
import starwave.util.regexp.Regexp;
import starwave.util.regexp.State;

class GroupReference
extends Regexp {
    int n;

    GroupReference(Regexp prev, int n) {
        super(prev);
        this.n = n;
    }

    public String toStringThis() {
        return "\\" + new Character((char)(48 + this.n));
    }

    Regexp advance(State state) {
        String group;
        try {
            group = state.getGroupString(this.n);
        }
        catch (NoSuchMatchException noSuchMatchException) {
            return null;
        }
        int cnt = group.length();
        if (state.charsLeft() < cnt) {
            return null;
        }
        int offset = state.offset;
        int i = 0;
        while (--cnt >= 0) {
            if (group.charAt(i++) == state.getchar(offset++)) continue;
            return null;
        }
        state.offset = offset;
        return this.next;
    }

    void backup(State s) {
        try {
            int len = s.getGroupLength(this.n);
            s.offset -= len;
        }
        catch (NoSuchMatchException noSuchMatchException) {}
    }
}

