/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceOptionsException;
import com.jthomas.javafaces.FaceProperties;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.javafaces.Prompter;
import com.jthomas.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public class FaceOptions {
    private static FaceOptions _TheOptions;
    private Hashtable _Options;
    private Hashtable _OptionsList;
    private final String DefaultImageURL = "http://www.cruzio.com/~jthomas/images/q_mark.gif";
    private final String NoMailURL = "http://www.cruzio.com/~jthomas/images/nomail.gif";
    private String _OptionsFile;
    private Prompter _Prompter;

    FaceOptions(String optionsfile) throws FaceOptionsException {
        File file = null;
        boolean verified = false;
        String deflt = "faces.opt";
        String title = "Enter JavaFaces Options FileName";
        if (_TheOptions != null) {
            Debug.out("Creating a new FaceOptions object");
        }
        Debug.out("FaceOptions(" + optionsfile + ")");
        if (optionsfile == null) {
            this._OptionsFile = FaceProperties.getRef().getProperty("OptionsFile");
            Debug.out("OptionsFile=" + optionsfile);
        } else {
            this._OptionsFile = optionsfile;
        }
        while (this._OptionsFile == null || this._OptionsFile.length() == 0 || !verified) {
            if (this._OptionsFile == null || this._OptionsFile.length() == 0) {
                this._OptionsFile = this.prompt("Enter name of Options File:", deflt, title);
                if (this._OptionsFile == null || this._OptionsFile.length() == 0) {
                    throw new FaceOptionsException("Option file not specified");
                }
            }
            try {
                file = new File(this._OptionsFile);
                Debug.out("file=" + file);
            }
            catch (Exception e) {
                Debug.out("Bad Filename", e);
            }
            if (file == null || !file.exists()) {
                deflt = this._OptionsFile;
                title = "Options Filename invalid or not found\nPlease Reenter";
                this._OptionsFile = null;
                continue;
            }
            verified = true;
        }
        ((Hashtable)FaceProperties.getRef()).put("OptionsFile", this._OptionsFile);
        _TheOptions = this;
    }

    public void parseOptions(String filename) throws FaceOptionsException {
        String[] reparseKeys = new String[]{"SELECT", "SELECTAFTER", "KILLSELECT"};
        boolean reparse = false;
        Debug.out("parseOptions(" + filename + ")");
        String parseFile = filename;
        if (parseFile == null) {
            parseFile = this._OptionsFile;
            this._Options = new Hashtable(40);
        }
        FileReader filereader = null;
        try {
            filereader = new FileReader(parseFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.out("File not found. '" + parseFile + "'");
            throw new FaceOptionsException("File not found");
        }
        StreamTokenizer tokenstream = new StreamTokenizer(filereader);
        tokenstream.slashSlashComments(true);
        tokenstream.slashStarComments(true);
        tokenstream.eolIsSignificant(true);
        tokenstream.ordinaryChars(48, 57);
        tokenstream.wordChars(48, 57);
        try {
            String key = null;
            String value = "";
            block11: while (tokenstream.nextToken() != -1) {
                block3 : switch (tokenstream.ttype) {
                    case 10: {
                        value = value.trim();
                        if (key == null) continue block11;
                        if (key.equals("INCLUDE")) {
                            try {
                                Debug.out("Read Include file: " + value);
                                this.parseOptions(value);
                            }
                            catch (Exception exception) {
                                Debug.out("Failed parsing Include file " + value);
                                throw new FaceOptionsException("Could not parse Include File\n'" + value + "'");
                            }
                        } else {
                            Object old = this._Options.get(key);
                            if (old == null) {
                                this._Options.put(key, value.trim());
                            } else if (old instanceof Vector) {
                                ((Vector)old).addElement(value);
                            } else {
                                Vector<Object> newVector = new Vector<Object>(5);
                                newVector.addElement(old);
                                newVector.addElement(value);
                                this._Options.put(key, newVector);
                            }
                        }
                        key = null;
                        value = "";
                        reparse = false;
                        break;
                    }
                    case -3: {
                        if (key == null) {
                            key = tokenstream.sval.trim().toUpperCase();
                            int i = 0;
                            while (i < reparseKeys.length) {
                                if (key.equals(reparseKeys[i])) {
                                    reparse = true;
                                    break block3;
                                }
                                ++i;
                            }
                            continue block11;
                        }
                        value = String.valueOf(value) + " " + tokenstream.sval;
                        break;
                    }
                    case 34: {
                        if (reparse) {
                            value = String.valueOf(value) + " \"" + tokenstream.sval + "\"";
                            break;
                        }
                        value = String.valueOf(value) + " " + tokenstream.sval;
                        break;
                    }
                    default: {
                        value = String.valueOf(value) + String.valueOf((char)tokenstream.ttype);
                    }
                }
            }
            filereader.close();
        }
        catch (IOException iOException) {
            Debug.out("Error while reading Options File. " + parseFile);
            throw new FaceOptionsException("Error reading Options File");
        }
        if (filename == null) {
            JavaFaces.getRef().fireFaceEvent(20);
        }
    }

    public boolean verifyOptions() {
        String[] serverlist;
        String msg;
        String pgm = JavaFaces.version();
        String opt = this.get("Version", "Unknown");
        boolean errs = false;
        if (!pgm.regionMatches(true, 0, opt, 0, 3)) {
            msg = "Your Option file version is Version: " + opt + "\n" + "JavaFaces version is Version: " + pgm + "' \n \n";
            errs = true;
        } else {
            msg = "Your Option file has errors: \n \n";
        }
        if (this.get("NoMailURL", null) == null) {
            msg = String.valueOf(msg) + "Add NoMailURL \n";
            this.put("NoMailURL", "http://www.cruzio.com/~jthomas/images/nomail.gif");
            errs = true;
        }
        if (this.get("DefaultImageURL", null) == null) {
            msg = String.valueOf(msg) + "Add DefaultImageURL \n";
            this.put("DefaultImageURL", "http://www.cruzio.com/~jthomas/images/q_mark.gif");
            errs = true;
        }
        if ((serverlist = this.getList("MailServer")) == null) {
            msg = String.valueOf(msg) + "No Mail Server specified! \n";
            errs = true;
        } else {
            int i = 0;
            while (i < serverlist.length) {
                Debug.out(serverlist[i]);
                ++i;
            }
        }
        String[] picondblist = this.getList("PIconDB");
        if (picondblist == null) {
            msg = String.valueOf(msg) + "No PIconDB specified! \n";
            errs = true;
        } else {
            int i = 0;
            while (i < picondblist.length) {
                Debug.out(picondblist[i]);
                ++i;
            }
        }
        if (errs) {
            Debug.out(msg);
            MsgDialog.create(msg);
            return false;
        }
        return true;
    }

    public static FaceOptions getRef() {
        return _TheOptions;
    }

    public String get(String option) {
        return this.get(option, "");
    }

    public String get(String option, String dflt) {
        String value = null;
        Object obj = this._Options.get(option.toUpperCase());
        if (obj == null) {
            value = dflt;
        } else if (obj instanceof String) {
            value = (String)obj;
        } else {
            Vector v = (Vector)obj;
            Debug.out("Requested Single value for key=" + option);
            Debug.out("but there are multiple values. Using last value!");
            value = (String)v.lastElement();
        }
        if (value != null && value.toUpperCase().equals("*PROMPT*") && (value = this.prompt("Enter " + option + ":", dflt)) == null) {
            value = dflt;
        }
        return value;
    }

    public boolean getBoolean(String option, boolean dflt) {
        String value = this.get(option, null);
        if (value == null) {
            return dflt;
        }
        return value.toUpperCase().equals("TRUE");
    }

    public int getInt(String option, int dflt) {
        String value = this.get(option, null);
        if (value == null) {
            return dflt;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException nfe) {
            Debug.out("Error Option: " + option + "=" + value + " " + nfe);
            return dflt;
        }
    }

    public void put(String option, String value) {
        Debug.out("FaceOptions.put: " + option + " Value:" + value);
        if (value != null) {
            this._Options.put(option.toUpperCase(), value);
        } else {
            this._Options.remove(option.toUpperCase());
        }
    }

    public String[] getList(String option) {
        String[] value = null;
        Object obj = this._Options.get(option.toUpperCase());
        if (obj == null) {
            return new String[0];
        }
        if (obj instanceof String) {
            value = new String[]{(String)obj};
        } else {
            Vector v = (Vector)obj;
            int n = v.size();
            value = new String[n];
            int i = 0;
            while (i < n) {
                value[i] = (String)v.elementAt(i);
                ++i;
            }
        }
        return value;
    }

    private String prompt(String prompt, String deflt) {
        return this.prompt(prompt, deflt, "JavaFaces Options");
    }

    private String prompt(String prompt, String deflt, String title) {
        Prompter p = Prompter.create();
        p.setTextInputPrompt(prompt, deflt, title);
        p.show();
        int status = p.getStatus();
        if (status == 2) {
            return p.getTextInput();
        }
        return null;
    }
}

