/*
 * @(#)Boolean.java	1.16 95/07/27  
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package java.lang;

/**
 * The Boolean class provides an object wrapper for Boolean data values, and 
 * serves as a place for boolean-oriented operations.
 * A wrapper is useful because most of Java's utility classes require the use
 * of objects.  Since booleans are not objects in Java, they need to be
 * "wrapped" in a Boolean instance. 
 * @version 	1.16, 07/27/95
 * @author	Arthur van Hoff
 */
public final
class Boolean {
    /** 
     *  Assigns this Boolean to be true.
     */
    public static final Boolean TRUE = new Boolean(true);
    /** 
     * Assigns this Boolean to be false.
     */
    public static final Boolean FALSE = new Boolean(false);
    
    /**
     * The value of the Boolean.
     */
    private boolean value;

    /**
     * Constructs a Boolean object initialized to the specified boolean 
     * value.
     * @param value the value of the boolean
     */
    public Boolean(boolean value) {
	this.value = value;
    }

    /**
     * Returns the value of this Boolean object as a boolean.
     */
    public boolean booleanValue() {
	return value;
    }

    /**
     * Returns a new String object representing this Boolean's value.
     */
    public String toString() {
	return value ? "true" : "false";
    }

    /**
     * Compares this object against the specified object.
     * @param obj		the object to compare with
     * @return 		true if the objects are the same; false otherwise.
     */
    public boolean equals(Object obj) {
	if ((obj != null) && (obj instanceof Boolean)) {
	    return (value == ((Boolean)obj).booleanValue());
	} 
	return false;
    }

    /**
     * Gets a Boolean from the properties.
     * @param name the property name.
     */
    public static boolean getBoolean(String name) {
	return "true".equals(System.getProperty(name));
    }
}







