/*
 * @(#)Panel.java	1.5 95/08/17 Sami Shaio
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package java.awt;

import java.awt.peer.PanelPeer;

/**
 * A Panel Container class. This produces a generic container.
 *
 * @version 	1.5, 08/17/95
 * @author 	Sami Shaio
 */
public class Panel extends Container {
    final static LayoutManager panelLayout = new FlowLayout();

    /**
     * Creates a new panel. The default layout for all panels is
     * FlowLayout.
     */
    public Panel() {
	setLayout(panelLayout);
    }

    /**
     * Creates the Panel's peer.  The peer allows us to modify the appearance
     * of the panel without changing its functionality.
     */
    public synchronized void addNotify() {
	peer = getToolkit().createPanel(this);
	super.addNotify();
    }
}
