/*
 * @(#)CheckboxGroup.java	1.6 95/08/17 Sami Shaio
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package java.awt;

/**
 * This class is used to create a multiple-exclusion scope for a set
 * of Checkbox buttons. For example, creating a set of Checkbox buttons
 * with the same RadioGroup object means that only one of those Checkbox
 * buttons will be allowed to be "on" at a time.
 *
 * @version 	1.6 08/17/95
 * @author 	Sami Shaio
 */
public class CheckboxGroup {
    /**
     * The current choice.
     */
    Checkbox currentChoice = null;

    /**
     * Creates a new CheckboxGroup.
     */
    public CheckboxGroup() {
    }

    /**
     * Gets the current choice.
     */
    public Checkbox getCurrent() {
	return currentChoice;
    }

    /**
     * Sets the current choice to the specified Checkbox.
     * @param t the Checkbox to be set to
     */
    public synchronized void setCurrent(Checkbox t) {
	Checkbox oldChoice = this.currentChoice;
	this.currentChoice = t;
	if ((oldChoice != null) && (oldChoice != t)) {
	    oldChoice.setState(false);
	}
    }

    /**
     * Returns the String representation of this CheckboxGroup's values.
     * Convert to String.
     */
    public String toString() {
	return getClass().getName() + "[current=" + currentChoice + "]";
    }
}
