/*
 * @(#)threads_md.h 1.13 95/09/21
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

/*
 * System dependent threads API
 */

#ifndef _OS2_THREADS_MD_H_
#define _OS2_THREADS_MD_H_

#include "sys_api.h"
#include <stdlib.h>           /* for _threadstore */
/*
 * #include <stddef.h>
 * #include "types_md.h"
 */
#include "mutex_md.h"
#include "condvar_md.h"
#include "monitor_md.h"

/* Win32 did a forward reference to sys_mon here -- not clear why */

/*
 * Keep in mind that the stack base here is expected to be the LOWEST
 * address of the stack, e.g. the address of a malloc'ed chunk.
 */
typedef struct {
     stackp_t   base;
     uint_t     size;
} gstack_t;


/*
 * Machine dependent thread data structure (includes active list/queue stuff)
 */
#define N_TRACED_REGS  6      /* Number of context registers to save */

struct sys_thread {
    void            *cookie;  /* back pointer to shared thread_t */

    unsigned long   os2_thread_id;      /* [OS2TID] */
    struct sys_thread *next;

    unsigned int    primordial_thread:1;
    unsigned int    system_thread:1;
    unsigned int    suspended:1;
    unsigned int    :0;
    int             priority;           /* [java-style] */

    gstack_t        stackp;

    unsigned long   monitor_entry_count;
    sys_mon_t       *mon_wait;

    HEV             requested;          /* ThreadSuspend waits on this */
    HEV             release;            /* CheckSuspend waits on this */
    HMTX            suspendlock;        /* Locks suspendreq/suspendack */
    int             suspendreq;         /* Suspend requested */
    int             suspendack;         /* Suspend request acknowledged */
    int             hardsuspend;        /* Thread is OS suspended */
 /* int             suspended;  */      /* Thread is suspended [check] */
    int             snap;               /* Context snap taken */
    int             unsafecontext;      /* Context is unsafe [see GC_MD.C] */
    CONTEXTRECORD   context;            /* Thread context iff snap */
    ULONG           saver[N_TRACED_REGS]; /* Space saved for registers */
    void            *start_parm;        /* Thread start routine parameter */
};


#define TID_NULL ((sys_thread_t *) 0)
#define SUSPEND_WAIT 4999               /* How long to wait for suspend */
#define CHECK_WAIT     51               /* How often to check waits */

void sysThreadCheck(sys_thread_t *);    /* Checks thread for suspend */
sys_thread_t * sysThreadSelf(void);     /* tid, if known */

/* Macro for cooperative suspension test -- arg is allowed to be 0 */
#define ThreadCheck(tid) if ((tid) && (tid)->suspendreq) sysThreadCheck(tid)

/* Macro to return TID of current thread */
/* [Identical in function to sysThreadSelf] */
#define quickThreadSelf() ((sys_thread_t *)(*_threadstore()))

#endif /* !_OS2_THREADS_MD_H_ */
