/*
 * @(#)mutex_md.h   1.7 95/03/10
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

/*-
 * Machine dependent mutex definitions.  For Win32 we use critical
 * section objects to implement interpreter mutexes.  We could use
 * mutexes, but they are heavier weight than critical sections and
 * are semantically identical.

 * For OS/2, we use mutex semaphores.

 */

#ifndef   _OS2_MUTEX_MD_H_
#define   _OS2_MUTEX_MD_H_

#include "javaos2.h"

typedef HMTX mutex_t;              /* from OS2.H */

int mutexInit(mutex_t *);
int mutexDestroy(mutex_t *);
int mutexLock(mutex_t *);
int mutexUnlock(mutex_t *);

#endif    /* !_OS2_MUTEX_MD_H_ */
