/*
 * @(#)monitor_md.h 1.9 95/08/17
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

/*-
 * System dependent API
 */

#ifndef   _OS2_MONITOR_MD_H_
#define   _OS2_MONITOR_MD_H_

#include "javaos2.h"

#include "bool.h"
#include "mutex_md.h"
#include "condvar_md.h"
/* #include "types_md.h" */


/*
 * The system dependent monitor structure
 */

#define SYS_MON_FOREVER       -1
#define SYS_TIMEOUT_INFINITY  -1
#define SYS_INTERRUPTS_PENDING() (0)

struct sys_mon {
    mutex_t                mutex;
    condvar_t              condvar;
    unsigned long          monitor_owner;
    unsigned long          entry_count;
    unsigned long          wait_count;
};


/* This next should be in monitor.h */
/* void monitorCleanup(TID tid); */


#endif    /* !_OS2_MONITOR_MD_H_ */
