/*
 * @(#)src/contract/ras/sov/ras.h, xs131, xs131, 20020822 1.13.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 *
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION:
 * RAS header file for use in all core libraries that use any of the facilities
 * provided by the Diagnostics subcomponent of the JVM.
 * ===========================================================================
 */
#ifndef _IBM_RAS_H_
#define _IBM_RAS_H_

/*
 * ======================================================================
 * Allow for inclusion in C++
 * ======================================================================
 */
#ifdef __cplusplus
extern "C" {
#endif

/*
 * ======================================================================
 * Forward declarations
 * ======================================================================
 */

struct DgTrcExecStruct;
typedef struct DgTrcExecStruct DgTrcExec;
struct rasHpiInterface;
typedef struct rasHpiInterface RasHpiInterface;
struct rasJniInterface;
typedef struct rasJniInterface RasJniInterface;

/*
 * ======================================================================
 * RasInfo structures
 * ======================================================================
 */
typedef struct RasInfo {
    int  type;
    union {

        struct {
            int    number;
            char **names;
        } query;

        struct {
            int    number;
            char **names;
        } trace_components;

        struct {
            char          *name;
            int            first;
            int            last;
            unsigned char *bitMap;
        } trace_component;
    } info;
} RasInfo;

#define RASINFO_TYPES               0
#define RASINFO_TRACE_COMPONENTS    1
#define RASINFO_TRACE_COMPONENT     2
#define RASINFO_MAX_TYPES           2

/*
 * ======================================================================
 * External access facade
 * ======================================================================
 */
#define JVMRAS_VERSION_1_1      0x7F000001

typedef struct DgRasInterface {
    char    eyecatcher[4];
    int     length;
    int     version;
    int     modification;
    int     (JNICALL *TraceRegister)(JNIEnv *env,
                                     void (JNICALL *func)(JNIEnv *env2,
                             void **threadLocal, int traceId,
                             const char * format, va_list var));
    int     (JNICALL *TraceDeregister)(JNIEnv *env,
                                       void (JNICALL *func)(JNIEnv *env2,
                               void **threadLocal, int traceId,
                               const char * format, va_list var));
    int     (JNICALL *TraceSet)(JNIEnv *env, const char *);
    void    (JNICALL *TraceSnap)(JNIEnv *env, char *);
    void    (JNICALL *TraceSuspend)(JNIEnv *env);
    void    (JNICALL *TraceResume)(JNIEnv *env);
    int     (JNICALL *GetRasInfo)(JNIEnv * env, RasInfo * info_ptr);
    int     (JNICALL *ReleaseRasInfo)(JNIEnv * env, RasInfo * info_ptr);
    int     (JNICALL *DumpRegister)(JNIEnv *env,
                                    int (JNICALL *func)(JNIEnv *env2,
                                                        void **threadLocal,
                                                        int reason));
    int     (JNICALL *DumpDeregister)(JNIEnv *env,
                                      int (JNICALL *func)(JNIEnv *env2,
                                                          void **threadLocal,
                                                          int reason));
    void    (JNICALL *NotifySignal)(JNIEnv *env, int signal);
} DgRasInterface;

/*
 * ======================================================================
 *    Dump exit return codes
 * ======================================================================
 */

#define RAS_DUMP_CONTINUE   0         /* Continue with diagnostic collection */
#define RAS_DUMP_ABORT      1         /* No more diagnostics should be taken */

/*
 * ======================================================================
 *    RAS structure header
 * ======================================================================
 */

typedef struct RasDataHeader {
    char eyecatcher[4];
    int length;
    int version;
    int modification;
} RasDataHeader;


/*
 * ======================================================================
 * Function prototypes
 * ======================================================================
 */

int  JNICALL rasTraceRegister(JNIEnv *env , void (JNICALL *func)(JNIEnv *env2,
                        void **threadLocal, int traceId,
                        const char * format, va_list varargs));
int  JNICALL rasTraceDeregister(JNIEnv *env ,
                                   void (JNICALL *func)(JNIEnv *env2,
                          void **threadLocal, int traceId,
                          const char * format, va_list varargs));
int  JNICALL rasGetRasInfo(JNIEnv * env, RasInfo * info_ptr);
int  JNICALL rasReleaseRasInfo(JNIEnv * env, RasInfo * info_ptr);


/*
 * ======================================================================
 * Facade access macros
 * ======================================================================
 */

#define RAS_FACADE(env) dgTrcExec.rasTrcIntf->

#ifdef __cplusplus
} /* extern "C" */
#endif
#endif /* !_IBM_RAS_H_ */

/*
 * End of file
 */
