/* Setup the JamochaMUD Icon on the OS/2 desktop */

/* This script will create an icon on the user's desktop which */

/* in turn calls a REXX CMD file to set up the environment and */

/* launch JamochaMUD.  The big thing is to ensure that our     */

/* classpath is setup right in the .cmd file                   */



obID = '<JamochaMUDBeta>'	/* The object ID */

title = 'JamochaMUD beta'	/* Title for the desktop icon */

startFile = 'anecho.JamochaMUD.JMUD'		/* Name of the file JavaPM has to run */

iconFile = 'JMUD.ico'	/* JamochaMUD icon file */

cmdFile = 'JMUD.cmd'            /* The .cmd file to start JamochaMUD */



rc = RxFuncAdd("SysCreateObject", "RexxUtil", "SysCreateObject")

rc = RxFuncAdd("SysSearchPath", "RexxUtil", "SysSearchPath")



/* Search for different versions of Java (the executables have different names */

/* These executables should be listed from least to most desirable for running JamochaMUD */

javaLocation = "";



progName.1 = "java.exe";

progName.2 = "jre.exe";

progName.3 = "javapm.exe";

progName.0 = 3;



do i=1 to progName.0

    tempLoc = SysSearchPath('PATH', progName.i);

    if (tempLoc <> "") then do

        javaLocation = tempLoc;

    END

END



/* Check to see if this script is being run from WarpIN or stand-alone

 * Warpin will pass the argument "warpin" where stand-alone will

 * have no argument

 */

if (arg() > 0) THEN DO

    /* Do a WarpIN install */

    JMUDLocation = directory()||'\anecho\JamochaMUD'  /* The directory where JamochaMUD "lives" */

    cd '..\..'

END

ELSE DO

    /* Do a stand-alone install */

    cd '..\..'

    JMUDLocation = directory()||'\anecho\JamochaMUD'  /* The directory where JamochaMUD "lives" */

END



javaClassPath = directory() /* This is the directory that must be added to the CLASSPATH */



/* Return to where we started */

cd JMUDLocation



/* say "Is this our classpath for anecho.*? "||javaClasspath */



If(javaLocation = "") Then

  Do

    Say "Unable to find a suitable Java environment (by myself)"

    Say ""

    Exit(1)

  End



/* Try to write out a startup .cmd file */

rc = LINEOUT(cmdFile, "/* Launch JamochaMUD after setting the proper path */", 1)

rc = LINEOUT(cmdFile, "'set CLASSPATH=%CLASSPATH%;"||javaClassPath||"'")

rc = LINEOUT(cmdFile, "/* Attempt to run JamochaMUD via javapm.exe */")

rc = LINEOUT(cmdFile, "'"||javaLocation||' '||startFile||"'")

/* Now close the file */

rc = LINEOUT(cmdFile)



/* Set up the parameters for the program */

params = "OBJECTID="||obID||";EXENAME=" || JMUDLocation || "\" || cmdFile || ";PROGTYPE=PM;STARTUPDIR=" || Directory() || ";PARAMETERS="||startFile||";ICONFILE="||Directory()||"\"||iconFile



/* Create the desktop icon */

rc = SysCreateObject("WPProgram", title, "<WP_DESKTOP>", params, "R");



If(rc = 0) Then

  Do

    Say "unable to create the JamochaMUD program object"

    Say ""

  End

