/**
 * ResReader.java
 * Contains functions to simplify reading
 * language resource bundles, taking the bulk
 * of the code out of the other classes
 * $Id: ResReader.java 1.2 2000/07/24 14:00:51 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package gui;

import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.StringTokenizer;

	/**
	 * ResReader.java
	 * Contains functions to simplify reading
	 * language resource bundles, taking the bulk
	 * of the code out of the other classes
         * @version $Id: ResReader.java 1.2 2000/07/24 14:00:51 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class ResReader{

	private static ResourceBundle rB;
	private static String finalString;
	private static Vector finalVector;

	/* Methods for reading simple Resource bundles,
	 * such as labels and short strings
	 */
	public static String LangString(String bundleName, String className) {
		rB = ResourceBundle.getBundle(bundleName);
		finalString = new String(ExtractString(rB, className));
		return finalString.trim();
	}

	public static String LangString(String bundleName, String className, String itemName){
		rB = ResourceBundle.getBundle(bundleName);
		finalString = new String(ExtractString(rB, className + "." + itemName));	
		return finalString.trim();
	}

	public static String LangString(String bundleName, String className, String itemName, String subName) {
		rB = ResourceBundle.getBundle(bundleName);
		finalString = new String(ExtractString(rB, className + "." + itemName + "." + subName));
		return finalString.trim();
	}

	/**
	 * Method for reading multiple-line
	 * messages from resource bundles
	 */
	public static Vector LangVector(String bundleName, String className, String itemName) {
		rB = ResourceBundle.getBundle(bundleName);
		return RBFinalVector(rB, className, itemName);
	}

	// Grab the string from the Resource Bundle
	private static String ExtractString(ResourceBundle rB, String item) {
		String extractString = new String("");

		try {
			extractString = rB.getString(item);
		} catch (MissingResourceException e) {
			System.out.println("Missing Resource Exception " + item);
		}

		return extractString;
	}
	
	/**
	 * This method is capable of grabbing/returning multi-line messages
	 * in the form of a vector
	 */
	private static Vector RBFinalVector(ResourceBundle rB, String className, String itemName) {
		// This method grabs a multi-lined message
		String tempString = new String("");				

		try {
				tempString = rB.getString(className + "." + itemName);
		} catch (MissingResourceException e) {
			System.out.println("Missing Resource Exception " + className + "." + itemName);
		}	

		return RBStringToVector(tempString);
	}

	/** 
	 * Break up a long string into tokens, using || as the delimeter,
	 * in that way, each token will be a single line of text in a long
	 * message.  Not the best method, but does seem to work for now
	 */
	private static Vector RBStringToVector(String tempString) {
		// Tokenize the string into an array
		StringTokenizer tokenizer = new StringTokenizer(tempString, "||");
		Vector tokenVector = new Vector(0, 1);
		
		while (tokenizer.hasMoreTokens()) {
			tokenVector.addElement(tokenizer.nextToken());
		}

		return tokenVector;
	}
}
