/**
 * The Reusable dialogue box:
 * OKBox.java displays program messages to the user with the possibility
 * of including icons, text, and/or response buttons
 * $Id: OKBox.java 1.3 2000/07/24 14:00:51 jeffnik Exp $
*/

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package gui;

import java.awt.*;
import java.awt.image.*;

import java.net.*;

import java.util.StringTokenizer;
import java.util.Vector;

	/*
	 * The Reusable dialogue box:
	 * OKBox.java displays program messages to the user with the possibility
	 * of including icons, text, and/or response buttons
         * @version $Id: OKBox.java 1.3 2000/07/24 14:00:51 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class OKBox extends Dialog {

	// Variables
	Image icon;		// The icon for the OKBox (if applicable)
	String buttonChoice;	// The label of button that was chosen by the user
	Vector buttonLabels;	// List of the labels to be applied to the buttons
	public static final int NO_ICON = 0;
	public static final int CUSTOM_ICON = 1;
	public static final int QUESTION_ICON = 2;
	public static final int ALERT_ICON = 3;
	public static final int INFORMATION_ICON = 4;
	
	private	BorderLayout layout = new BorderLayout(5, 5); // Our layout manager for the OKBox
	private Canvas iconCanvas;	// The canvas that will contain our icon (if applicable)
	private Canvas textCanvas;	// The canvas that will contain our user-message
	private Panel buttonPanel;	// This panel will contain the buttons in a flow-layout 
					// type of fashion
	private Vector readyMessage = new Vector(0, 1);	// Message ready for output
	private Vector userMessage = new Vector(0, 1);	// Message before preparation for output

	// Constructor(s)
	public OKBox(Frame parent) {
		this(parent, "");
	}

	public OKBox(Frame parent, boolean modalBox) {
		this(parent, "", modalBox);
	}

	public OKBox(Frame parent, String title) {
		this(parent, title, false);
	}

	public OKBox(Frame parent, String title, boolean modalBox) {
		this(parent, title, modalBox, "");
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage) {
		this(parent, title, modalBox, boxMessage, NO_ICON);
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, int iconType) {
		this(parent, title, modalBox, boxMessage, iconType, "");
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, String buttons) {
		this(parent, title, modalBox, boxMessage, NO_ICON, buttons);
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, int iconType, String buttons) {
		// Because Dialog does not have a parameter-less constructor,
		// we have to call its basic constructor ourselves, or we get
		// a compiling error of "No constructor matching Dialog()"
		super(parent, title, modalBox);

		// Time to set up our new OKBox
		setLayout(layout);

		iconCanvas = new Canvas();
		Panel iconPanel = new Panel();
		textCanvas = new Canvas();
		Panel textPanel = new Panel();
		buttonPanel = new Panel();
		Panel dudPanel = new Panel();
//		layout.addLayoutComponent(iconCanvas, BorderLayout.WEST);
//		layout.addLayoutComponent(textCanvas, BorderLayout.CENTER);
//		layout.addLayoutComponent(dudPanel, BorderLayout.NORTH);
		layout.addLayoutComponent(iconPanel, BorderLayout.WEST);
		layout.addLayoutComponent(textPanel, BorderLayout.CENTER);
//		layout.addLayoutComponent(dudPanel, BorderLayout.EAST);

		// Figure out the labels for the buttons
		buttonLabels = new Vector(0, 1);
		if (buttons.equals("")) {
			// We weren't passed a string of buttons, so we'll default to 'OK'
			buttonLabels.addElement("OK");
		} else {
			// Tokenize the String of buttons
			StringTokenizer chopMe = new StringTokenizer(buttons, "|", false);

			for (int i = 0; i < chopMe.countTokens(); i++) {
				buttonLabels.addElement(chopMe.nextToken());
			}
		}
		
		for (int i = 0; i < buttonLabels.size(); i++) {
			buttonPanel.add(new Button((buttonLabels.elementAt(i)).toString()));
			System.out.println("OKBox, added button: " + buttonLabels.elementAt(i));
			System.out.println("ButtonPanel: " + buttonPanel);
		}
	
		if (iconType > 0) {
			// We'll nab the icon and use it to help use determine the default size
			icon = getBoxIcon(iconType);
		}

		layout.addLayoutComponent(buttonPanel, BorderLayout.SOUTH);

		pack();
		buttonPanel.setVisible(true);
	}

	/** We'll pull the icon (from wherever it is supposed to be)
	 * and write it onto the correct canvas (also keeping a copy in memory)
	 */
	private synchronized Image getBoxIcon(int type) {
		Image image = Toolkit.getDefaultToolkit().getImage("kehza.gif");

		return image;
	}

	// Draw the contents to the screen
	public void paint(Graphics g) {
		g.drawImage(icon, 5, 25, this);
	}

	/** We'll do a virtual run-through of the text available so that we'll
	 * be able to size the window before we try to print to it. 
	 * By doing this we can set up our vector so it neatly parses the message
	 */
	private void formatText() {
		
	}

	/** Set the text for the message (erasing any previous contents) */
	public synchronized void setText(String text) {
		if (userMessage.size() > 0) {
			userMessage.removeAllElements();
		}
		append(text);
	}

	public synchronized void append(String text) {
		userMessage.addElement(text);
	}
}
