/**
 * The JamochaMUD Timer thread
 * Timers.java, including things such as
 * Normal timerkeeping, average lag, and maximum lag
 * $Id: Timers.java 1.8 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * vesion 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.StringTokenizer;
import java.lang.System;

import gui.SyncFrame;
import gui.SyncFrameGroup;

	/**
	 * The JamochaMUD Timer thread
	 * Timers.java, including things such as
	 * Normal timerkeeping, average lag, and maximum lag
         * @version $Id: Timers.java 1.8 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class Timers extends Thread implements WindowListener{

	// Variables
	private static Vector pendingPhrases;
	private static long averageLag[];
	private static long highestLag;
	private static long averageLagTimer, lagTimer, startTime;
	public static SyncFrame timerFrame;
	private Label genericLabel;
        private static String newString;
	private static TextField averageLL, highestLL, lagTL;
	boolean timerLoop = true;
	boolean activeState = false;
		

	public Timers() {
		// Set the timer variables
		pendingPhrases = new Vector(0, 1);
		averageLag = new long[10];
		averageLagTimer = 0;
		highestLag = 0;
		lagTimer = 0;

		// This sets the layout for the timers
		boolean sync;
		if (((String)MuckConn.jmVars.get("SyncWindows")).equals("true")) {
			sync = true; 
		} else {
			sync = false;
		}
		timerFrame = new SyncFrame("JamochaMUD - Timers", sync, MuckConn.syncGroup);
		timerFrame.addWindowListener(this);

		Panel timerPanel = new Panel();
		GridBagLayout timerBag = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();

		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.BOTH;
		genericLabel = new Label("Lag: ");
		timerBag.setConstraints(genericLabel, constraints);
		timerPanel.add(genericLabel);

		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.BOTH;
		// This will be cast to a String in hh:mm:ss format in the future
		lagTL = new TextField(lagTimer + "");
		lagTL.setEditable(false);
		timerBag.setConstraints(lagTL, constraints);
		timerPanel.add(lagTL);

		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.gridx = 2;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.BOTH;
		genericLabel = new Label("Max. Lag: ");
		timerBag.setConstraints(genericLabel, constraints);
		timerPanel.add(genericLabel);

		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.gridx = 3;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.BOTH;
		// This will be cast to a String in hh:mm:ss format in the future
		highestLL = new TextField(highestLag + "");
		highestLL.setEditable(false);
		timerBag.setConstraints(highestLL, constraints);
		timerPanel.add(highestLL);

		constraints.weightx = 2.0;
		constraints.weighty = 1.0;
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		genericLabel = new Label("Average Lag: ");
		timerBag.setConstraints(genericLabel, constraints);
		timerPanel.add(genericLabel);

		constraints.weightx = 2.0;
		constraints.weighty = 1.0;
		constraints.gridx = 2;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		// This will be cast to a String in hh:mm:ss format in the future
		averageLL = new TextField(averageLagTimer + "");
		averageLL.setEditable(false);
		timerBag.setConstraints(averageLL, constraints);
		timerPanel.add(averageLL);

		timerFrame.add(timerPanel);
		timerFrame.setIconImage((Image)MuckConn.jmVars.get("JamochaMUDImage"));
		//return timerPanel;
		timerFrame.setBounds((Rectangle)MuckConn.jmVars.get("Timers"));

	}

	/**
	* Check to see if the timer needs to be incremented, and do so if necessary
	*/
	public void IncrementTimer() {
		// If there is still a string in the 'pendingPhrases'
		// Vector, then this will increment the timer
		
		// First, we check to see if there is a start-time	
		// To compare against
		if (startTime == 0) {
			// Set the 'startTime'
			startTime = System.currentTimeMillis();
		}
	
		// Now see if there has been a second (or more) increment
		if ((System.currentTimeMillis() - lagTimer) > 999) {
			// There has been an increment of over a second
			lagTimer = (System.currentTimeMillis() - startTime);
			
			// Repaint the display
			lagTL.setText(ToTime(lagTimer));
		}
			
	}

	/**
	* This method adds the new string to the vector of Strings waiting to be processed
	*/
	public static void AddOutput(String incomingString) {
		// Collects output from user (sent from DataIn)  
		// and adds it to the 'pendingPhrases' vector
		// (Also parse any 'special characters' off the ends)
		
                pendingPhrases.addElement(PrepString(incomingString));


	}

	/**
	* Search through the vector of Strings to see if the latest
	* input matches anything.
	*/
	public static void CompareStrings(String receivedString) {
		// See if the string returned from the MU* matches
		// input in the 'pendingPhrases' vector.  If so,
		// pop that one from the vector, and reset the lag timer
		// Most likely, this function will be called by 'FromNet.class'

		// First, check to see if any Strings are waiting

		if (pendingPhrases.size() > 0) {
			// There are phrases waiting, so we will proceed
			
			for (int i = 0; i < pendingPhrases.size(); i++) {
				// Check to see if the new string has
				// a matching sting in 'pendingPhrases'

				if (receivedString.indexOf(pendingPhrases.elementAt(i).toString().trim()) > -1) {
					// We have located a pendingPhrase
					// Now 'pop' the vector to continue

					try {
						for (int j = 0; j < (i + 1); j++) {
        	                                        // The removed element should always
                	                                // be at '0', just because we're knocking
                        	                        // down the Vector from the bottom
                                	                pendingPhrases.removeElementAt(0);
						}
					} catch (Exception e) {
						System.out.println("Timers: An exception occured in the removal loop: " + e);
					}
					
					try {
						// Send this figure to calculate the average lag
						AverageLagCalc(lagTimer);
					} catch (Exception a) {
						// System.out.println("AverageLagCalc " + a);
					}
			
					try {
						// See if this lag qualified for Highest Lag time yet
						HighestLagCalc(lagTimer);
					} catch (Exception b) {
						// System.out.println("HighestLagCalc " + b);
					}
					
					try {
						// Reset the lag counter for the next phrase
						ResetCounter();
					} catch (Exception counter) {
						System.out.println("Timer error in resetting: " + counter);
					}	
	
					// This loop has done what we need, so we can break it
					break;			
	
				}
	
			} // End the 'for' loop			
		} else {
			// This call had nothing to do with the player,
			// so does not affect the lag-timer
		}
	}

	/**
	* Reset the lag counter to zero
	*/
	private static void ResetCounter() {
		// Set the lag timer back to zero, and queue the next
		// string in 'pendingPhrases' if applicable
		lagTimer = 0;
		startTime = 0;
	}

	/**
	 * Calculate the average amount of lag.  This calculation actually
	 * needs to be fixed, because of how it initially does the
	 * calculations if the user has not sent up to 10 lines of
	 * output yet
	 */
	private static void AverageLagCalc(long timeVariable) {
		// Averages lag from the last 10 recorded lags
		averageLagTimer = 0;

		for (int i = 0; i < 9; i++) {
			averageLag[i] = averageLag[i + 1];
			averageLagTimer = (averageLagTimer + averageLag[i]);
		}

		averageLag[9] = timeVariable;
		averageLagTimer = (long)((averageLagTimer + timeVariable) / 10);
		averageLL.setText(ToTime(averageLagTimer));
	}

	/**
	* This method checks to see if the last lag was the greatest yet!
	*/
	private static void HighestLagCalc(long timeVariable) {
		// Calculate if the last lag count was the highest
		// yet, and updates the variable if so
		if (timeVariable > highestLag) {
			// Wow... more lag than before!!
			highestLag = timeVariable;

			highestLL.setText(ToTime(highestLag));
		}
	}

	/**
	 * returns the time to the user in seconds
	 */
	private static String ToTime(long origTime) {
		// Take the count in seconds, and return it to
		// the user in the standard time (hh:mm:ss) format
		return ((int)(origTime / 1000) + "");
	}

	public void run () {

		while (timerLoop) {
		
			// pause this thread for a little bit
			try {
				sleep(500);
			} catch (Exception e) {
				System.out.println("Sleep failed: " + e);
			}

			if (pendingPhrases.size() > 0) {
				// there are pendingPhrases, so we should be
				// able to increment the timer
				IncrementTimer();
			}
		}
	}

	/**
	* Cleans up the string a bit for easier comparison in the future
	*/
	private static String PrepString(String tempString) {
		// This will parse characters that obviously won't
		// be returned from the MU*, such as a leading : or "
		// There could be future problems if this is a
		// MU* independant thing...

		// First, tokenize the phrase, and then drop the first 2
		// tokens to compensate for page/pose 'tokens'
		StringTokenizer tokenString = new StringTokenizer(tempString);
		Vector tempTokens = new Vector(0, 1);

		while (tokenString.hasMoreTokens()) {
			tempTokens.addElement(tokenString.nextToken());
		}

		// Unconditionally remove the first token		
		tempTokens.removeElementAt(0);

		// Now we see if we should remove the next
		if (tempTokens.size() > 1) {
			tempTokens.removeElementAt(0);
		}

		// Now we reconstruct the string out of the remaining tokens
		tempString = new String("");
		for (int i = 0; i < tempTokens.size(); i++) {
			tempString = tempString + tempTokens.elementAt(i) + " ";
		}

		tempString.trim();

                while (tempString.startsWith(":") || tempString.startsWith("=") || tempString.startsWith("\"")) {
                        // Keep running this loop until the illegal characters
                        // have been removed from the front of the String
			tempString = tempString.substring(1, tempString.length());
                }

                while (tempString.endsWith(":") || tempString.startsWith("=") || tempString.startsWith("\"")) {
                        // Run this loop until the illegal characters
                        // have been removed from the end of the String
                }

		return tempString.trim();
        }

	/** Return the visibility state of this class */
	public synchronized boolean getActiveState() {
		return activeState;
	}

	/** Set the visibility state of this class */
	public synchronized void setActiveState(boolean state) {
		activeState = state;
		if (!state) {
			MuckConn.jmVars.put("Timers", timerFrame.getBounds());
		}
		timerFrame.setVisible(state);
		timerFrame.setSync(state);
	}	

	// Frame events
	public void windowActivated(WindowEvent event) {
		if (MuckConn.jmVars.containsKey("Timers")) {
			MuckConn.jmVars.remove("Timers");
		}
	}

	public void windowClosed(WindowEvent event) {}

	public void windowClosing(WindowEvent event) {
		// Hide the macroWindow
		setActiveState(false);

		// We have to make sure the menu of MuckMain correlates...
		MuckMain.tWTimers.setState(false);
	}

	public void windowDeactivated(WindowEvent event) {}

	public void windowDeiconified(WindowEvent event) {
	}

	public void windowIconified(WindowEvent event) {
		MuckConn.jmVars.put("Timers", timerFrame.getBounds());
		// Now here, we want to take this frame out of Sync with the rest
		// otherwise it'll keep popping up every time the user
		// minimizes or maximizes the other sync'd frames
	}

	public void windowOpened(WindowEvent event) {}

}
