/**
 * Main Muck Output Window
 * $Id: MuckMain.java 1.22 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

import gui.SyncFrame;
import gui.JMText;
import gui.ResReader;

	/**
	 * Main Muck Output Window, heart of the program, containing
	 * most of the menus and logistics of JamochaMUD
         * @version $Id: MuckMain.java 1.22 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
// public class MuckMain extends Frame implements ActionListener, KeyListener, MouseListener, ItemListener, TextListener, WindowListener{
public class MuckMain extends Frame implements ActionListener, KeyListener, MouseListener, ItemListener, WindowListener{
	public static SyncFrame textWindow;
	static CheckboxMenuItem tWMacro, tWSyncWindowsItem, tWUseUnicodeItem, tWTFKeysItem;
	protected static CheckboxMenuItem tWAutoFocus, tWTimers;

	public static JMText mainText;

	static boolean pauseStatus, textWindowStatus;
	static BufferedReader input;
	public static MuckMain z;
	static MenuItem cTM, dFM, rTM;
	static Socket serverSock;
	static Timers timerThread;
	public static String muckMainTitle;
	static Vector heldResponse;	
	private Vector tempVector;
	private MenuItem dumpOutputItem, quitItem;
	private MenuItem pingMUItem;
	private MenuItem copyItem, pasteItem, findItem;
	private MenuItem coloursItem, editOptionsItem, externalProgramsItem, managePlugIn, serverOptionsItem, showTimersItem, showMacroBarItem;
	private MenuItem contentsItem, troubleshootingItem, aboutJamochaMUDItem;
	protected static Menu tWPlugInMenu;
	

	public MuckMain() {

		// Create the windows
		muckMainTitle = new String(RB("frameTitle.label"));
		boolean sync;
		if (((String)MuckConn.jmVars.get("SyncWindows")).equals("false")) {
			sync = false;
		} else {
			sync = true;
		}
		textWindow = new SyncFrame(muckMainTitle, sync, MuckConn.syncGroup);
		textWindow.setCloseState(true);
		textWindow.addWindowListener(this);
		
		mainText = new JMText("", 50, 80, JMText.SCROLLBARS_VERTICAL_ONLY);

		mainText.setEditable(false);
		textWindow.add(mainText); // Add TextArea to Frame
		pauseStatus = false;
		heldResponse = new Vector(0, 1);
		tempVector = new Vector(0, 1);
		mainText.addKeyListener(this);
		mainText.addMouseListener(this);
		// mainText.addTextListener(this);

		// Create a timer
		timerThread = new Timers();	

		// Create macros
		MuckConn.jmMacros = new MuMacros();

		// Add Menu Bar and items to textWindow

		MenuBar tWMenuBar = new MenuBar();
		textWindow.setMenuBar(tWMenuBar); // Add MenuBar to Frame
		Menu tWFileMenu = new Menu(RB("file.label"));
		tWMenuBar.add(tWFileMenu);
		tWFileMenu.add(dumpOutputItem = new MenuItem(RB("file.dumpOutput"), new MenuShortcut(KeyEvent.VK_D, false)));
			dumpOutputItem.setActionCommand(dumpOutputItem.getLabel());

		tWFileMenu.addSeparator();
		tWFileMenu.add(quitItem = new MenuItem(RB("file.quit"), new MenuShortcut(KeyEvent.VK_Q, true)));
			quitItem.setActionCommand(quitItem.getLabel());
		tWFileMenu.addActionListener(this);


		// Add the Edit menu items
		Menu tWEditMenu = new Menu(RB("edit.label"));
		tWMenuBar.add(tWEditMenu);
			// I'm making it the right key for OS/2, damn't!
			if (((String)MuckConn.jmVars.get("OSName")).equals("OS/2")) {
				copyItem = new MenuItem(RB("edit.copy"), new MenuShortcut(KeyEvent.VK_INSERT, false));
			} else {
				copyItem = new MenuItem(RB("edit.copy"), new MenuShortcut(KeyEvent.VK_C, false));
			}
			copyItem.setActionCommand(copyItem.getLabel());
			tWEditMenu.add(copyItem);
	
			pasteItem = new MenuItem(RB("edit.paste"), new MenuShortcut(KeyEvent.VK_V, false));
			pasteItem.setActionCommand(pasteItem.getLabel());
			tWEditMenu.add(pasteItem);

			tWEditMenu.addSeparator();

			findItem = new MenuItem(RB("edit.find"), new MenuShortcut(KeyEvent.VK_F, false));
			findItem.setActionCommand(findItem.getLabel());
			findItem.setEnabled(false);
			tWEditMenu.add(findItem);
		tWEditMenu.addActionListener(this);


		// Add CONNECTION menu items
		Menu tWConnectMenu = new Menu(RB("connection.label"));
		tWMenuBar.add(tWConnectMenu);
                	cTM = new MenuItem(RB("connection.connectToMU"), new MenuShortcut(KeyEvent.VK_C, true)); // enable/disable functionality
				cTM.setActionCommand(cTM.getLabel());
               		tWConnectMenu.add(cTM);

			rTM = new MenuItem(RB("connection.reconnectToMU"), new MenuShortcut(KeyEvent.VK_R, true));
				rTM.setActionCommand(rTM.getLabel());
			tWConnectMenu.add(rTM);

	       		dFM = new MenuItem(RB("connection.disconnectFromMU"), new MenuShortcut(KeyEvent.VK_D, true));  // enable/disable functionality
				dFM.setActionCommand(dFM.getLabel());
                	tWConnectMenu.add(dFM);

		tWConnectMenu.add(pingMUItem = new MenuItem(RB("connection.pingMU")));
		pingMUItem.setEnabled(false);
		tWConnectMenu.addActionListener(this);
		
		Menu tWOptionMenu = new Menu(RB("options.label"));
		tWMenuBar.add(tWOptionMenu);
		tWOptionMenu.add(coloursItem = new MenuItem(RB("options.colours"), new MenuShortcut(KeyEvent.VK_F, true)));
			coloursItem.setActionCommand(coloursItem.getLabel());


		// Add ****Edit Options**** Submenu
		Menu tWEditOptionsMenu = new Menu(RB("options.editOptions"));
		tWOptionMenu.add(tWEditOptionsMenu);
		tWEditOptionsMenu.add(externalProgramsItem = new MenuItem(RB("options.editOptions.externalPrograms"), new MenuShortcut(KeyEvent.VK_E, false)));

			externalProgramsItem.setActionCommand(externalProgramsItem.getLabel());
		tWEditOptionsMenu.add(serverOptionsItem = new MenuItem(RB("options.editOptions.serverOptions")));
			// serverOptionsItem.setEnabled(false);
		tWEditOptionsMenu.add(managePlugIn = new MenuItem(RB("options.editOptions.managePlugIn"), new MenuShortcut(KeyEvent.VK_M, false)));
			managePlugIn.setActionCommand(managePlugIn.getLabel());
		tWEditOptionsMenu.addActionListener(this);
	
		// Continue with normal option menu
		tWOptionMenu.addSeparator();


		tWAutoFocus = new CheckboxMenuItem(RB("options.autoFocusInput"), true);
		tWOptionMenu.add(tWAutoFocus);
		tWAutoFocus.addItemListener(this);


		tWTimers = new CheckboxMenuItem(RB("options.showTimers"), false);
			tWTimers.setShortcut(new MenuShortcut(KeyEvent.VK_T, false));
			tWTimers.setActionCommand(tWTimers.getLabel());
		tWOptionMenu.add(tWTimers);
		tWTimers.addItemListener(this);
		tWTimers.addActionListener(this);

		
		tWMacro = new CheckboxMenuItem(RB("options.showMacroBar"), false);
		tWOptionMenu.add(tWMacro);
		tWMacro.addItemListener(this);

		tWSyncWindowsItem = new CheckboxMenuItem(RB("options.syncWindows"), true);
		tWOptionMenu.add(tWSyncWindowsItem);
		tWSyncWindowsItem.addItemListener(this);

		tWUseUnicodeItem = new CheckboxMenuItem(RB("options.useUnicode"), false);
		tWOptionMenu.add(tWUseUnicodeItem);
		tWUseUnicodeItem.addItemListener(this);

		tWTFKeysItem = new CheckboxMenuItem(RB("options.tinyFugueKeys"), true);
		tWOptionMenu.add(tWTFKeysItem);
		tWTFKeysItem.addItemListener(this);

		// Add the ActionListener to this menu
		tWOptionMenu.addActionListener(this);


		// Add the Plug-in menu items
		tWPlugInMenu = new Menu(RB("plugIn.label"));
		tWMenuBar.add(tWPlugInMenu);
		// tWPlugInMenu.addItemListener(this);
		tWPlugInMenu.addActionListener(this);


		//Add HELP menu items
		Menu tWHelpMenu = new Menu(RB("help.label"));
		tWMenuBar.setHelpMenu(tWHelpMenu);
		tWHelpMenu.add(contentsItem = new MenuItem(RB("help.contents"), new MenuShortcut(KeyEvent.VK_H)));
			contentsItem.setActionCommand(contentsItem.getLabel());
		tWHelpMenu.add(troubleshootingItem = new MenuItem(RB("help.troubleshooting")));
		tWHelpMenu.addSeparator();
		tWHelpMenu.add(aboutJamochaMUDItem = new MenuItem(RB("help.aboutJamochaMUD")));
		tWHelpMenu.addActionListener(this);

		
		// Display textWindow
		mainText.setForeground((Color)MuckConn.jmVars.get("ForeGroundColour"));
		mainText.setBackground((Color)MuckConn.jmVars.get("BackGroundColour"));
		MuckMain.mainText.setFont((Font)MuckConn.jmVars.get("FontFace"));

				
	}
	
	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "MuckMain", itemTarget);
	}


	
	// public static void Content(Frame appletContainer, int a) throws IOException{
	public static void Content() throws IOException{
	
		MuckMain z = new MuckMain();
	
	}

	
	public void actionPerformed(ActionEvent event){

		String arg = event.getActionCommand();
		
		// Arguments for the ***FILE**** menu
			
			// Check for 'Dump Output'
			if (arg.equals(dumpOutputItem.getLabel())) {
				
				DumpOutput();
			}
	
			if (arg.equals(quitItem.getLabel())) {
				// Call WriteINI to save information
				JMWriteRC.Content();

				// Close the JVM
				System.exit(1);  // Probably an ugly exit	
			}

		// Arguments for the **EDIT** menu

			/** Copy */
			if (arg.equals(copyItem.getLabel())) {
				Clipboard c = this.getToolkit().getSystemClipboard();
				try {
					String str = mainText.getSelectedText();
					StringSelection s = new StringSelection(str);
					c.setContents(s, s);
				} catch (Exception e) {
					System.out.println("Copy exception in MuckMain." + e);
				}					
			}

			/** Paste */
			if (arg.equals(pasteItem.getLabel())) {
				Clipboard c = this.getToolkit().getSystemClipboard();
				try {
					Transferable contents = c.getContents(this);
					String str = (String)contents.getTransferData(DataFlavor.stringFlavor);

					// Now we'll stick it into the dataText-thing
					StringBuffer buff = new StringBuffer(DataIn.dataText.getText());
					int caretPos = DataIn.dataText.getCaretPosition();
					buff.insert(caretPos, str);
					DataIn.dataText.setText(buff.toString());
				} catch (Exception e) {
					System.out.println("Paste exception in MuckMain " + e);
				}
			}

			/** Find */

		// Arguments for the **CONNECTION**** menu 

			/** Connect to MU* */
			if (arg.equals(cTM.getLabel())) {
				
				JMConnectToMU();
			}			

			/** Reconnect to MU* */
			if (arg.equals(rTM.getLabel())) {
				// Call reconnect to MU*
				mainText.setText("");
				MuckConn.jmCommThread = new FromNet();
				MuckConn.jmCommThread.start();
			}

			/** Disconnect from MU* */
        		if (arg.equals(dFM.getLabel())) {
		        	
				JMDisconnectFromMU();
				
			} 

			/** Ping MU* */
			if (arg.equals(pingMUItem.getLabel())) {
								
			}

		// Arguments for ****OPTIONS**** menu

			if (arg.equals(coloursItem.getLabel())) {
				FontFace.RunOkay(textWindow);
			}

			if (arg.equals(externalProgramsItem.getLabel())) {
				ExternalProgs.Content(textWindow);
			}

			if (arg.equals(serverOptionsItem.getLabel())) {
				ProxyBox.Content(textWindow);
			}

			if (arg.equals(managePlugIn.getLabel())) {
				ManagePlugins.RunMP(textWindow);
			}
	
		// Arguments for ****HELP**** menu

			if (arg.equals(contentsItem.getLabel())) {
				
				StringBuffer tentativeURL = new StringBuffer(RB("help.jamochaMUDPages"));
				ExternalProgs.LaunchProgram(textWindow, tentativeURL);
			}

			if (arg.equals(troubleshootingItem.getLabel())) {
				
				JMTroubleShooting();
			}
		
			if (arg.equals(aboutJamochaMUDItem.getLabel())) {
				
				AboutBox temp = new AboutBox();
				temp.setVisible(true);
				//AboutBox.Content();
			}

		return;
	}

	/**
	 * Show a dialogue box to allow users to select a file
	 * to dump all of the output to for logging/archiving, etc...
	 */
	private void DumpOutput() {
		
		// Show the system dump dialogue
		// This will dump *all* the output to the selected file

		try {
			FileDialog dumpDialogue = new FileDialog(textWindow, "Dump Output to file", 1);
			dumpDialogue.show();

			try {
				String fileName = new String(dumpDialogue.getFile());
				
				// File has been selected
				// now write the output contents to it
				try {
					String filePath = new String(dumpDialogue.getDirectory());
					FileOutputStream outFile = new FileOutputStream((filePath + fileName), false);
					PrintWriter out = new PrintWriter(outFile, true);
					out.println(mainText.getText());
					out.flush();
					outFile.close();
				} catch (Exception fo) {
					System.out.println("File output error " + fo);
				}
			} catch (Exception e) {
				// This occurs when there is a 'cancel' instead of a file selection
			}	
	
		} catch (Exception e) {
			// This occurs if the user hits 'cancel'
			// so we'll just end this sequence.
			System.out.println("MuckMain, final exception");
		}

	}

	// Check for mouse actions

	public void mousePressed(MouseEvent e) {
		PauseText();
	}
	public void mouseReleased(MouseEvent e) {
        }
        public void mouseClicked(MouseEvent e) {
		// Determine number of mouse clicks
		int a = e.getClickCount();

		if (a >= 2) {
			// Call outside routines (plug-ins) to handle the selected text
			e.consume();
			DataIn.SpoolText();

			// grab the 'selected' URL
			StringBuffer tentativeURL = new StringBuffer((mainText.getSelectedText()).trim());
			System.out.println("Muckmain... using " + tentativeURL + " for external program.");

			// The frame is sent to anchor any potential dialogues
			// send the 'URL' to launch the correct program
			ExternalProgs.LaunchProgram(textWindow, tentativeURL);

			// Deselect the text
			// mainText.select(mainText.getSelectionEnd(), mainText.getSelectionEnd());
			System.out.println("MuckMain: Deselect text?");
		} else {
			// A single click signals a pause		
			// This will pause the output window, 
			// the incoming lines held in queue
			PauseText();
		}
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}
	
	public void keyPressed(KeyEvent event){
		int arg = event.getKeyCode();
		if (event.getKeyCode()!= KeyEvent.VK_ALT && event.getKeyCode() != KeyEvent.VK_CONTROL) {
			// Check to see if the user wants AutoFocus shift
			if (!tWAutoFocus.getState()) {
				event.consume();
			} else {
				// First we'll send the focus to the dataIn.dataText
				DataIn.dataText.requestFocus();

				if (event.getKeyCode() == KeyEvent.VK_ENTER) {
					// The user hit 'ENTER', send the text out
					DataIn.JMSendText();
				}
	
				// Slight problem with this tactic, as X-Windows does
				// not (always) allow focus traversal between frames, so
				// we'll just try sending the event directly as well.
				String osName = (String)MuckConn.jmVars.get("OSName");
				if (osName.toLowerCase().startsWith("windows") ||  osName.toLowerCase().startsWith("os/2")) {
				// Bleah!!
				} else {
					// We'll do this all kludgy until  
					// a better way can be found
					// We just append the text to DataIn.dataText, because
					// we cannot change focus.  If we can, the 
					// 'requestFocus' from above will handle it

					DataIn.dataText.append(event.getKeyChar() + "");
					event.consume();
				}
			}
		}

		return;
	}
	
	public void keyTyped(KeyEvent event){}

	public void keyReleased(KeyEvent event){}

	public void itemStateChanged(ItemEvent event) {
		String arg = (String) event.getItem();
		
		if (arg.equals(RB("options.autoFocusInput"))) {
			MuckConn.jmVars.put("AutoFocusInput", tWAutoFocus.getState() + "");
		}

		if (arg.equals(RB("options.showMacroBar"))) {
			// Hide/Show the macro bars
			if (tWMacro.getState()) {
				// Make the frame visible
				MuckConn.jmMacros.setActiveState(true);
				MuckConn.jmMacros.setVisible(true);
				if (tWSyncWindowsItem.getState()) {
					MuckConn.jmMacros.setSync(true);
				} else {
					MuckConn.jmMacros.setSync(false);
				}
			} else {
				// Try and call the subroutine from MuMacros
				MuckConn.jmMacros.setActiveState(false);
				MuckConn.jmMacros.setVisible(false);
			}
		}

		if (arg.equals(tWSyncWindowsItem.getLabel())) {
			textWindow.setAllStates(tWSyncWindowsItem	.getState());
			if (tWSyncWindowsItem.getState()) {
				MuckConn.jmVars.put("SyncWindows", "true");
				MuckConn.syncGroup.changeState(textWindow, gui.SyncFrameGroup.SET_ALL_TRUE);
				// Now we'll make an exception for the Timers
				if (!tWTimers.getState()) {
					timerThread.setActiveState(false);
				}
			} else {
				MuckConn.jmVars.put("SyncWindows", "false");
				MuckConn.syncGroup.changeState(textWindow, gui.SyncFrameGroup.SET_ALL_FALSE);
			}
		}				

		if (arg.equals(RB("options.showTimers"))) {
			// Changed the status of the timers
			if (tWTimers.getState()) {
				// The timers have been enabled, start the timer thread
				timerThread.setActiveState(true);
				// timerThread.start();
				timerThread.resume();
				MuckConn.jmVars.remove("Timers");
			} else {
				// Kill the timer thread
				// timerThread.stop();
				timerThread.suspend();
				timerThread.setActiveState(false);
			}
						
		}

		if (arg.equals(RB("options.useUnicode"))) {
			// Changed the Unicode option
			if (tWUseUnicodeItem.getState()) {
				// Enabled
				MuckConn.jmVars.put("UseUnicode", "true");
			} else {
				// Disabled
				MuckConn.jmVars.put("UseUnicode", "false");
			}
		}

		if (arg.equals(RB("options.tinyFugueKeys"))) {
			if (tWTFKeysItem.getState()) {
				MuckConn.jmVars.put("TFKeyEmu", "true");
			} else {
				MuckConn.jmVars.put("TFKeyEmu", "false");
			}
		}

	}

	
	public void windowActivated(WindowEvent event) {
		// The text window is visible
		textWindowStatus = true;
		// Restore the original title to the window
		setWindowTitle();
	}

	public void windowClosed(WindowEvent event) {}

	public void windowClosing(WindowEvent event) {
		// Write all the user information to .jamocha.rc before closing
		MuckConn.jmVars.put("MainWindow", textWindow.getBounds());
		JMWriteRC.Content();
	}

	public void windowDeactivated(WindowEvent event) {}

	public void windowDeiconified(WindowEvent event) {
		// The text window is visible
		textWindowStatus = true;
		setWindowTitle();
		MuckConn.minimizedLineCount = 0;
	}

	public void windowIconified(WindowEvent event) {
		// Write the frame to a the Hashtable
		// MuckConn.jmVars.put("MainWindow", textWindow);
		// The text window is now hidden
		textWindowStatus = false;

		MuckConn.jmVars.put("MainWindow", textWindow.getBounds());
	}

	public void windowOpened(WindowEvent event) {}

//	public void textValueChanged(java.awt.event.TextEvent event) {
//		// Check to see if stack needs to be popped
//		// This is ugly, but will work.  This method will
//		// be deprecated when JamochaMUD goes to Java1.2
//
//		// String text = mainText.getText();
//		String jmText = mainText.getText();
//		// if (text.length() > 25000) {
//		if (jmText.length() > 25000) {
//			// remove the first 5000 characters
//			// mainText.setText(text.substring(5000));
//			// mainText.setCaretPosition((text.substring(5000)).length());
//			mainText.setText(jmText.substring(5000));
//			mainText.setCaretPosition((jmText.substring(5000)).length());
//		}
//	}

	public static void setWindowTitle() {
		// This resets the window's title, depending if the
		// client is connected to a MU* or not
		if (dFM.isEnabled()) {
			// Connection is active, so append Mu* name to title
			textWindow.setTitle(muckMainTitle + " (" + MuckConn.jmVars.get("ConnMuck") + ")");
		} else {
			// Connection is inactive, just have program's title
			textWindow.setTitle(muckMainTitle);
		}
	}

	/**
	 * Methods called when disconnected from the MUD/MUCK
	 * Here, we reset some of the menu flags to the appropriate status
	 * and give the user visual notification that they have been disconnected
	 * (This is not always called just by the user's 'Disconnect' action)
	 */
	public static void DisconnectMenu() {
		// This changes the flags on the MuckMain menu to 'disconnected'	
		MuckMain.cTM.setEnabled(true);
		MuckMain.dFM.setEnabled(false);
		MuckMain.rTM.setEnabled(true);

		// Now give visual notifier that you have been disconnected
		mainText.append("------- Disconnected from " + MuckConn.jmVars.get("ConnMuck") + " -------" + '\n'); 	
	}

	/** 
	 * The user has chosen to connect to a MUD/MUCK, so we
	 * set the menu items as appropriate, and give the a visual
	 * identifier that we are actually trying to make the connection
	 */
	public static void ConnectMenu() {
		// This changes the flags on the MuckMain menu to 'connected'
		MuckMain.cTM.setEnabled(false);
		MuckMain.dFM.setEnabled(true);
		MuckMain.rTM.setEnabled(false);
		mainText.append("------- Attempting connection to " + MuckConn.jmVars.get("ConnMuck") + " -------" + '\n'); 		
		// mainText.append("------- Attempting connection to " + '\u001b' + "[32m" + MuckConn.jmVars.get("ConnMuck") + '\u001b' + "[=l -------" + '\n'); 		

	}

	/**
	 * Set the 'pause' status on the Main window.
	 * Usually done by a single mouse-click, it will stop the
	 * text from scrolling, and set the DataBar's title to alert
	 * the user that the text is paused
	 */
	public static void PauseText() {
		// A single click signals a pause		
		// This will pause the output window, 
		// the incoming lines held in queue
		pauseStatus = true;
		DataIn.dataBar.setTitle("**" + RB("outputPaused") + "**");
	}

	public static void RefreshPlugInListener() {
		// First, remove the old listener
		// tWPlugInMenu.removeActionListener();
		
		// Now add the Listener to the new list
		// tWPlugInMenu.addActionListener();
	}
	
	/**
	 * The user has chosen to connect to a MU*, so we hide all the
	 * active windows and show the MuckConn again
	 */
	private void JMConnectToMU() {

		// Stick the current frame back into the hashtable
		MuckConn.jmVars.put("MainWindow", textWindow.getBounds());
		textWindow.setVisible(false);

		try {
			MuckConn.jmMacros.HideFrame();
		} catch (Exception nada) {}

		DataIn.dataBar.setVisible(false);
		MuckConn.jmMCFrame.setVisible(true);
		MuckConn.jmMCFrame.requestFocus();
	}

	/**
	 * Disconnect from the MU, closing the socket and stopping
	 * the thread that listens to that IP address
	 */
	private void JMDisconnectFromMU() {
		// Close the socket
		try {
			FromNet.connSock.close();
		} catch (Exception oops) {
			System.out.println(oops);
		}

		// Stop the read/write thread
		MuckConn.jmCommThread.stop();

		// FromNet.DisconnectMenu();
		DisconnectMenu();
		
		// Reset frame name
		MuckMain.textWindow.setTitle(MuckMain.muckMainTitle);
		DataIn.dataBar.setTitle(DataIn.dataBarTitle);
		mainText.append("Connection has been closed.");
	}

	/**
	 * Call the help specific to troubleshooting problems with JamochaMUD
	 */
	private void JMTroubleShooting() {
		MuckConn.jmVars.put("Okay", "true");
		MuckConn.jmVars.put("Cancel", "false");
		MuckConn.jmVars.put("Ignore", "false");

		tempVector.removeAllElements();
		tempVector.addElement("This option is not available yet");
		OKBox.RunOkay(textWindow, null, null, false, false, null, null, true, tempVector, "Troubleshooting", 200, 100);
	}

}
