/** MuckConn - Muck Connector version 2
 * Handles the different muck addresses
 * and characters, and physical connection
 * $Id: MuckConn.java 1.14 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;
import java.util.Vector;

import gui.SyncFrameGroup;
import gui.PosTools;
import gui.ResReader;

import plugins.*;

	/** MuckConn - Muck Connector version 2
	 * Handles the different muck addresses
	 * and characters, and physical connection
         * @version $Id: MuckConn.java 1.14 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class MuckConn implements ActionListener {

	private static Button connectButton;
	private static Choice jmMUNames;
	protected static Frame jmMCFrame;
	public static int minimizedLineCount;
	protected static FromNet jmCommThread;
	public static Hashtable jmVars;
	private GridBagLayout muckConnLayout;
	private GridBagConstraints constraints;
	private static Image jamochaMUDImage;
	public static MuckConn base;
	public static SyncFrameGroup syncGroup;
	public static MuMacros jmMacros;

	public MuckConn(){

		syncGroup = new SyncFrameGroup();
		muckConnLayout = new GridBagLayout();
		constraints = new GridBagConstraints();
		
		// Set new layout
		jmMCFrame = new Frame("JamochaMUD (Connector)");
		
		jmMCFrame.setLayout(muckConnLayout);

		jmMUNames = new Choice();
                        constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			muckConnLayout.setConstraints(jmMUNames, constraints);
		jmMCFrame.add(jmMUNames);

		connectButton = new Button(RB("connect"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 1;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			muckConnLayout.setConstraints(connectButton, constraints);
		jmMCFrame.add(connectButton);
		connectButton.addActionListener(this);
		connectButton.setActionCommand("ConnectToMU");

		Button b = new Button(RB("addMU"));
                        constraints.gridwidth = GridBagConstraints.RELATIVE;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 1;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			muckConnLayout.setConstraints(b, constraints);
		jmMCFrame.add(b);
		b.addActionListener(this);
		b.setActionCommand("AddMU");

		b = new Button(RB("removeMU"));
                        constraints.gridwidth = GridBagConstraints.REMAINDER;
                        constraints.gridheight = 1;   
                         constraints.gridx = 4;
			constraints.gridy = 1;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			muckConnLayout.setConstraints(b, constraints);
		jmMCFrame.add(b);
		b.addActionListener(this);
		b.setActionCommand("RemoveMU");

		b = new Button(RB("editMU"));
			constraints.gridx = 0;
			constraints.gridy = 2;
                        constraints.gridwidth = GridBagConstraints.RELATIVE;
			constraints.gridheight = 1;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 7, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
		jmMCFrame.add(b);
			muckConnLayout.setConstraints(b, constraints);
		b.addActionListener(this);
		b.setActionCommand("EditMU");

		b = new Button(RB("pingMU"));
                        constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.gridheight = GridBagConstraints.REMAINDER;
			constraints.gridx = 3;
			constraints.gridy = 2;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
		jmMCFrame.add(b);
			muckConnLayout.setConstraints(b, constraints);
		b.setActionCommand("PingMU");
		b.addActionListener(this);
		b.setEnabled(false);

		jmMCFrame.pack();

	}

	public static void main(String[] args) {

		// First thing we do is create a new instance of MuckConn
		base = new MuckConn();

		jmVars = new Hashtable(101, .75f);	

		// Do the initialisation of variables and windows
		JMStartUp();

		jmMCFrame.setSize(300, 140);
		Point centre = PosTools.findCentre();
		int x = centre.x;
		int y = centre.y;
		jmMCFrame.setLocation(x - 150, y - 70);
		// Make the frame visible
		jmMCFrame.setVisible(true);
		

	}

	public void actionPerformed(ActionEvent event){

		String arg = event.getActionCommand();

		if (arg.equals("ConnectToMU")) {
			// Connect to the MU* displayed
			JMConnectToMU();
		}		

		if (arg.equals("EditMU")) {
			// Edit the MU*
			JMEditMU();
		}

		if (arg.equals("RemoveMU")) {
			// Remove the MU*
			JMRemoveMU();
		}

		if (arg.equals("AddMU")) {
			// Add MU*
			JMAddMU();
		}

		if (arg.equals("PingMU")) {
			// Ping the MU*
		}

	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "MuckConn", itemTarget);
	}

	/**
	 * Call the methods necessary for the user to add
	 * a new MUD/MUCK to the list of worlds
	 */
	private void JMAddMU() {
		// Assign the temporary vector
		Vector editName = new Vector(0, 1);
		Vector editAddy = new Vector(0, 1);
		Vector editPort = new Vector(0, 1); 
		editName = (Vector)jmVars.get("MuckName");
		editAddy = (Vector)jmVars.get("MuckAddy");
		editPort = (Vector)jmVars.get("MuckPort");

		int i = jmMUNames.getSelectedIndex();
		jmVars.put("EditName", "");
		jmVars.put("EditAddy", "");
		jmVars.put("EditPort", "");

		// Call the AddEdit box
		AddEdit.RunIt(jmMCFrame, RB("addMU"), false);

		if ((String)jmVars.get("EditName") != null) {	
			String jmEditName = (String)jmVars.get("EditName");
			String jmEditAddy = (String)jmVars.get("EditAddy");
			String jmEditPort = (String)jmVars.get("EditPort");

			if (jmEditName.trim().equals("") | jmEditAddy.trim().equals("") | jmEditPort.trim().equals("")) { 
				// Don't make any modifications
			} else {
				// Check to see if the first entry is a 'valid'
				// MU*, or just a place-marker
				if (editName.elementAt(0).equals("None") & editAddy.elementAt(0).equals("----")) {
					jmMUNames.removeAll();
				}

				// Add the new entry to the list of available MU*s
				editName.addElement(jmEditName);
				editAddy.addElement(jmEditAddy);
				editPort.addElement(jmEditPort);
				jmMUNames.addItem(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")");
				// Put new vector into the hashtable
				jmVars.put("MuckName", editName);
				jmVars.put("MuckAddy", editAddy);
				jmVars.put("MuckPort", editPort);

				// Display new MU* in choice
				jmMUNames.select(jmMUNames.getItemCount() - 1);
				connectButton.requestFocus();
				
			}
		}

	}

	/**
	 * Remove the currently selected MUD/MUCK from the list
	 * of available worlds (and the .jamocha.rc file).
	 */
	private void JMRemoveMU() {
		// Remove MU* from list
		Vector muckName = new Vector(0, 1);
		Vector muckAddy = new Vector(0, 1);
		Vector muckPort = new Vector(0, 1);
		muckName = (Vector)jmVars.get("MuckName");
		muckAddy = (Vector)jmVars.get("MuckAddy");
		muckPort = (Vector)jmVars.get("MuckPort");
	
		muckName.removeElementAt(jmMUNames.getSelectedIndex());
		muckAddy.removeElementAt(jmMUNames.getSelectedIndex());
		muckPort.removeElementAt(jmMUNames.getSelectedIndex());
	
		if (muckName.size() < 1) {
			jmMUNames.removeAll();
			muckName.addElement("None");
			muckAddy.addElement("----");
			muckPort.addElement("----");
			jmMUNames.addItem("None" + " (" + "----" + " Port: " + 					"----" + ")");
		} else {
			jmMUNames.remove(jmMUNames.getSelectedIndex());
		}
		
		// Now place the vectors back in the Hashtable
		jmVars.put("MuckName", muckName);
		jmVars.put("MuckAddy", muckAddy);
		jmVars.put("MuckPort", muckPort);

	}

	/**
	 * The user has opted to connect to the currently selected
	 * MUD/MUCK, so we honour their wishes here!
	 */
	private void JMConnectToMU() {
		// connect to the MU*
		MuckMain.tWPlugInMenu.removeAll();		
		new EnumPlugIns();

		Vector tempAddy = new Vector(0, 1);
		Vector tempPort = new Vector(0, 1);

		tempAddy = (Vector)MuckConn.jmVars.get("MuckAddy");
		tempPort = (Vector)MuckConn.jmVars.get("MuckPort");

		// First, make sure that the MuckMain.mainText is blank (if reconnecting)
		MuckMain.mainText.setText("");

		jmMCFrame.setVisible(false);
		jmVars.put("ConnMuck", tempAddy.elementAt(jmMUNames.getSelectedIndex()).toString());
		jmVars.put("ConnPort", tempPort.elementAt(jmMUNames.getSelectedIndex()).toString());		

		// Set the text area of the databar to the proper
		// size and then display it.
		if (MuckConn.jmVars.containsKey("DataBar")) {
			DataIn.dataBar.setBounds((Rectangle)MuckConn.jmVars.get("DataBar"));
			DataIn.dataBar.setIconImage((Image)jmVars.get("JamochaMUDImage"));
			MuckConn.jmVars.remove("DataBar");
		}
		DataIn.dataBar.setVisible(true);

		if (MuckConn.jmVars.containsKey("MainWindow")) {
			MuckMain.textWindow.setBounds((Rectangle)MuckConn.jmVars.get("MainWindow"));
			MuckMain.textWindow.setIconImage((Image)jmVars.get("JamochaMUDImage"));
			MuckConn.jmVars.remove("MainWindow");
		}
		MuckMain.textWindow.setVisible(true);

		// Set the state for all the menu items
		JMSetMenuStates();
			
		// How 'bout them crazy timers?
		if (!MuckMain.timerThread.isAlive()) {
			MuckMain.timerThread.start();
		}
		if ((String)jmVars.get("TimersVisible") == "false") {
			MuckMain.timerThread.suspend();
			MuckMain.timerThread.setActiveState(false);
		} else {
			MuckMain.timerThread.setActiveState(true);
		}

		if (((String)MuckConn.jmVars.get("MacroVisible")).equals("true")) {
			jmMacros.setVisible(true);
			jmMacros.setActiveState(true);
		}
	
		// Start listening thread
		jmCommThread = new FromNet();
		jmCommThread.start();

	}

	/**
	 * Call the methods to allow the user to edit the MUD/MUCK
	 * Name/address/port of the currently selected world
	 */
	private void JMEditMU() {
		// edit current MU* entry
		// Assign the temporary vector
		Vector editName = new Vector(0, 1);
		Vector editAddy = new Vector(0, 1);
		Vector editPort = new Vector(0, 1); 
		editName = (Vector)jmVars.get("MuckName");
		editAddy = (Vector)jmVars.get("MuckAddy");
		editPort = (Vector)jmVars.get("MuckPort");

		int i = jmMUNames.getSelectedIndex();
		jmVars.put("EditName", editName.elementAt(i));
		jmVars.put("EditAddy", editAddy.elementAt(i));
		jmVars.put("EditPort", editPort.elementAt(i));

		// Call the AddEdit box
		AddEdit.RunIt(jmMCFrame, RB("editMU"), false);

		if ((String)jmVars.get("EditName") != null) {	
			String jmEditName = (String)jmVars.get("EditName");
			String jmEditAddy = (String)jmVars.get("EditAddy");
			String jmEditPort = (String)jmVars.get("EditPort");

			if (jmEditName.trim().equals("") | jmEditAddy.trim().equals("") | jmEditPort.trim().equals("")) { 
				// Don't make any modifications
			} else {
				// Replace the edited MU* info
				editName.removeElementAt(i);
				editAddy.removeElementAt(i);
				editPort.removeElementAt(i);
				
				editName.insertElementAt(jmEditName, i);
				editAddy.insertElementAt(jmEditAddy, i);
				editPort.insertElementAt(jmEditPort, i);

				// Put new vector into the hashtable
				jmVars.put("MuckName", editName);
				jmVars.put("MuckAddy", editAddy);
				jmVars.put("MuckPort", editPort);

				// Replace the choice entry
				jmMUNames.remove(i);
				jmMUNames.insert(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", i);
				jmMUNames.select(i);
				connectButton.requestFocus();
				
			}
		}
	}

	/** Initialise all the starting windows and such
	 *
	 */
	private static void JMStartUp() {

		// Read in the environmental variables
		JMSystem();

		JMParseRC.Content();

		try {
			MuckMain.Content();
		} catch (Exception oops) {
			System.out.println("Critical error starting MuckMain: " + oops);
			oops.printStackTrace();
		}				

		DataIn.Content();

		// Load the JamochaMUD icon (using a media-tracker)
		jamochaMUDImage = Toolkit.getDefaultToolkit().getImage("kehza.gif");
		jmVars.put("JamochaMUDImage", jamochaMUDImage);

		while (jamochaMUDImage == null) {
		}
		jmMCFrame.setIconImage(jamochaMUDImage);

		// set up the Muck Name variables
		JMCompileNames();

		// Now set up the windows (made visible when connected)
		
	}	

	/** 
	 * Gather system dependent variables
	 * Such as screen size, user directories, etc.
	 */
	private static void JMSystem() {
		// Set screen size
		jmVars.put("ScreenSize", jmMCFrame.getToolkit().getScreenSize());

		// Set directory variables
		String userDirectory = new String("");
		java.util.Properties systemData = System.getProperties();
		String osName = new String(systemData.getProperty("os.name"));		

		String pathSeparator = new String(java.io.File.separator);
		String sCurrentWorkingDir = new String(systemData.getProperty("user.dir") + pathSeparator);

		if (osName.toLowerCase().startsWith("windows") ||  osName.toLowerCase().startsWith("os/2")) {
			// This is a single user environment
			System.out.println("JamochaMUD, single user configuration.");
			userDirectory = new String(systemData.getProperty("user.dir") + pathSeparator);
		} else {
			// This is a multi-user environment, put the
			// rc file in the user's home directory
			System.out.println("JamochaMUD... going multiuser");
			userDirectory = new String(systemData.getProperty("user.home") + pathSeparator + "JamochaMUD" + pathSeparator);
		}

		System.out.println("OS name: " + systemData.getProperty("os.name"));
		System.out.println("OS architecture: " + systemData.getProperty("os.arch"));
		System.out.println("OS version: " + systemData.getProperty("os.version"));
		System.out.println("User name: " + systemData.getProperty("user.name"));
		System.out.println("User home: " + systemData.getProperty("user.home"));
		System.out.println("User dir: " + systemData.getProperty("user.dir"));

		// Now stick all this data into the hashtable
		jmVars.put("PathSeparator", pathSeparator);
		jmVars.put("WorkingDirectory", sCurrentWorkingDir);
		jmVars.put("UserDirectory", userDirectory);
		jmVars.put("OSName", systemData.getProperty("os.name"));
	}

	/** 
	 * Compile the MU* names
	 * and then write them into the
	 * choice of jmMCFrame
	 */
	private static void JMCompileNames() {
		// First grab the vectors
		Vector muckAddy = new Vector(0, 1);
		Vector muckName = new Vector(0, 1);
		Vector muckPort = new Vector(0, 1);

		muckName = (Vector)MuckConn.jmVars.get("MuckName");
		muckAddy = (Vector)MuckConn.jmVars.get("MuckAddy");
		muckPort = (Vector)MuckConn.jmVars.get("MuckPort");

		for (int i=0; i < muckName.size(); i++) {
			jmMUNames.addItem(muckName.elementAt(i) + " (" + muckAddy.elementAt(i) + " Port: " + muckPort.elementAt(i) + ")");
		}

	}
	
	/**
	 * Set the state of the menu items in MuckMain (the output window)
	 */
	private static void JMSetMenuStates() {
		// This sets the state of the Macro menu item (In MuckMain)
		if (((String)MuckConn.jmVars.get("MacroVisible")).equals("true")) {
			MuckMain.tWMacro.setState(true);
		} else {
			jmMacros.setSync(false);	// Make sure things don't sync wrong
		}

		// How 'bout them timers, huh?
		if ((String)MuckConn.jmVars.get("TimersVisible") == "true") {
			MuckMain.tWTimers.setState(true);
		}

		// Set AutoFocusInput
		if (((String)jmVars.get("AutoFocusInput")).equals("true")) {
			MuckMain.tWAutoFocus.setState(true);
		}

		// Set SyncFrames
		if (((String)MuckConn.jmVars.get("SyncWindows")).equals("false")) {
			MuckMain.tWSyncWindowsItem.setState(false);
		}

		// Set Use Unicode
		if (jmVars.get("UseUnicode").toString().equals("true")) {
			MuckMain.tWUseUnicodeItem.setState(true);
		}
		
		// Tinyfugue key emulation
		if (((String)MuckConn.jmVars.get("TFKeyEmu")).equals("false")) {
			MuckMain.tWTFKeysItem.setState(false);
		}

	}
}
