/**
 * ManagePlugins.java - A dialogue for managing plugins
 * $Id: ManagePlugins.java 1.11 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import java.util.Vector;

import gui.PosTools;
import gui.ResReader;

import plugins.PlugInterface;


	/**
	 * ManagePlugins.java - A dialogue for managing plugins
         * @version $Id: ManagePlugins.java 1.11 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
class ManagePlugins extends Dialog implements ActionListener, ItemListener{

	private Button gButton;
	private GridBagLayout managePluginsLayout;
	private GridBagConstraints constraints;
	private Label gLabel;
	private static List activeList, inactiveList, fullList;
	private TextArea desc;

	private ManagePlugins(Frame frameParent) {
		// Create the dialog
		
		super(frameParent, "JamochaMUD - " + RB("title"), true);

		managePluginsLayout = new GridBagLayout();
		constraints = new GridBagConstraints();
		
		// Set new layout
		
		setLayout(managePluginsLayout);

		// Display the list of selected pictures
		gLabel = new Label(RB("activePlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		gLabel = new Label(RB("inactivePlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		gLabel = new Label(RB("allPlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		// Add the 3 list items
		activeList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 0;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(activeList, constraints);
			// activeList.addItemListener(this);
		add(activeList);

		inactiveList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 2;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(inactiveList, constraints);
			// inactiveList.addItemListener(this);
		add(inactiveList);

		fullList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 4;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(fullList, constraints);
			fullList.addItemListener(this);
		add(fullList);

		// Add the button for each column
		gButton = new Button(RB("remove"));
		gButton.setActionCommand("remove");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);


		gButton = new Button(RB("add"));
		gButton.setActionCommand("add");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("refresh"));
		gButton.setActionCommand("refresh");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		// Add the Okay and Cancel buttons
		gButton = new Button(RB("properties"));
		gButton.setActionCommand("properties");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("okay"));
		gButton.setActionCommand("okay");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("cancel"));
		gButton.setActionCommand("cancel");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 10;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		desc = new TextArea("", 3, 80, TextArea.SCROLLBARS_VERTICAL_ONLY);
			constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.gridheight = GridBagConstraints.REMAINDER;
			constraints.gridx = 0;
			constraints.gridy = 11;
			constraints.weightx = 6;
			constraints.weighty = 1;
			constraints.insets = new Insets(2, 7, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(desc, constraints);
		add(desc);

		pack();
	}

	public static void RunMP(Frame parentFrame) {
		
		ManagePlugins managePluginsFrame = new ManagePlugins(parentFrame);
		managePluginsFrame.setSize(450, 250);
		managePluginsFrame.setLocation(PosTools.findCentre(parentFrame, managePluginsFrame));

		// Now set up the variables
		ListPlugins();

		managePluginsFrame.setVisible(true);

	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "ManagePlugins", itemTarget);
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();

		if (arg.equals("remove")) {
			// Removed selected from list
			// Check to see if an item is selected first
			if (activeList.getSelectedItem() != null) {
				inactiveList.add(activeList.getSelectedItem());
				activeList.remove(activeList.getSelectedItem());
			}
		}

		if (arg.equals("add")) {
			// Add selected from list
			// Check to see if an item is selected first
			if (inactiveList.getSelectedItem() != null) {
				activeList.add(inactiveList.getSelectedItem());
				inactiveList.remove(inactiveList.getSelectedItem());
			}
		}

		if (arg.equals("okay")) {
			// Change active plugins

			// Loop through the main list and
			// change all instances to false
			for (int i = 0; i < fullList.getItemCount(); i++) {
				EnumPlugIns.plugInStatus.setElementAt("false", i);
			}

			// Now set 'true', the list of active plugins
			if (activeList.getItemCount() > 0) {
				for (int j = 0; j < activeList.getItemCount(); j++) {
					EnumPlugIns.plugInStatus.setElementAt("true", j);
				}
			}

			// Write changes to the .plugins.rc file
			SetPlugInStatus();			

			setVisible(false);
			dispose();
		}

		if (arg.equals("cancel")) {
			// Close dialogue, make no changes
			setVisible(false);
			dispose();
		}

		if (arg.equals("properties")) {
			// Call the properties menu for the selected plugin
			try {
				Object plugClass = EnumPlugIns.plugInClass.elementAt(fullList.getSelectedIndex());
				((PlugInterface)plugClass).PlugInProperties();
			} catch (ArrayIndexOutOfBoundsException e) {
				// The array index was out of bounds
				// Chances are no plugin was selected
				// for properties to be viewed	
			} catch (Exception e) {
				System.out.println("(ManagePlugins) Plugin Property Exception " + e);
			}
		}

		if (arg.equals("refresh")) {
			// Call the refresh plugins method
			JMRefreshPlugIns();
		}

	}

	public void itemStateChanged(ItemEvent e) {
		int choice = 0;
		// List list = e.getItem();
		// System.out.println(list + " " + '\n' + " "+ e);

		try {
			// We'll see if anything useful was selected
			choice = fullList.getSelectedIndex();
		} catch (Exception err) {
			System.out.println("ItemStateChanged exception " + err);
		}

		// Now that we have a selected item, we can continue
		String description = EnumPlugIns.Description(fullList.getItem(choice));

		// Set the description
		desc.setText(description);
	}

	/**
	 * This reads in all the plugins and their settings (whether active/inactive)
	 * and then formats them to be displayed in the appropriate columns
	 */
	private static void ListPlugins() {
		// This will fill the 3 lists with the appropriate info
		String tempName = new String();
		Vector plugInStatus = (Vector)MuckConn.jmVars.get("PlugInStatus");
		Vector plugInName = (Vector)MuckConn.jmVars.get("PlugInName");

		// First, we empty the existing lists
		activeList.removeAll();
		inactiveList.removeAll();
		fullList.removeAll();

		// Now, loop through the names and fill the lists
		if (plugInName == null) return;

		for (int i = 0; i < plugInName.size(); i++) {
			// tempName = (String)EnumPlugIns.plugInName.elementAt(i);
			tempName = (String)plugInName.elementAt(i);
			fullList.add(tempName);

			String temp = ((String)plugInStatus.elementAt(i)).toLowerCase();
			if (temp.equals("true")) {
				// Plugin is active
				activeList.add(tempName);
			} else {
				// Plugin is inactive
				inactiveList.add(tempName);
			}	
		}
		
	}

	/** 
	 * Write the changes to the plugins to the .plugins.rc file
	 */
	public static void SetPlugInStatus() {
		// Make sure the plugInStatus vector is up to date
		String tempName;
		Vector plugInName = new Vector(0, 1);
		Vector plugInStatus = new Vector(0, 1);
		Vector activeListName = new Vector(0, 1);

		for (int i = 0; i < fullList.getItemCount(); i++) {
			tempName = fullList.getItem(i);
			plugInName.addElement(tempName);
			plugInStatus.addElement("false");

			for (int j = 0; j < activeList.getItemCount(); j++) {
				if (activeList.getItem(j).equals(tempName)) {
					activeListName.addElement(tempName);
					plugInStatus.setElementAt("true", i);
				}
			}

		}

		// Now write the changes to the .plugins.rc file
		try {
			FileOutputStream outputFile = new FileOutputStream((String)MuckConn.jmVars.get("UserDirectory") + ".plugins.rc");
			ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
			// serializeStream.writeObject(activeList);
			serializeStream.writeObject(activeListName);
			serializeStream.flush();
		} catch (Exception e) {
			System.out.println("Serialization error " + e);
		}

		// Now write the status to the hashtable
		MuckConn.jmVars.put("PlugInName", plugInName);
		MuckConn.jmVars.put("PlugInStatus", plugInStatus);
	}

	/**
	 * Refresh the list of plugins to show any changes that may have
	 * occured (adding, removing, etc).
	 */
	private void JMRefreshPlugIns() {
		// First, clear the vectors that contain the plugins

		// EnumPlugIns.plugInName.removeAllElements();
		// EnumPlugIns.plugInStatus.removeAllElements();

		// Re-read the list of plugins
		
		// Weed out non-valid entries for the plugins
		// in the active/inactive lists

		// Now call ListPlugins() to refresh the lists on screen
		new EnumPlugIns();
		ListPlugins();
	}

}
