/**
 * A thread dedicated to reading data from a socket connection.
 * $Id: FromNet.java 1.12 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.DataOutputStream;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

import java.util.Properties;
import java.util.Vector;

// JamochaMUD's very own classes!
import gui.ResReader;
import extranet.Socks5socket;

	/**
	 * A thread dedicated to reading data from a socket connection.
         * @version $Id: FromNet.java 1.12 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class FromNet extends Thread {
    boolean socks = false;
    String sockHost = "";
    int sockPort;
	Properties sP = System.getProperties();

	public Socket connectionSocket;    // the socket you are reading from
	static Socket connSock;

	protected BufferedReader inStream; // Replaces deprecated DataInputStream
	boolean empty;
	public static boolean isConnected;
	public static DataOutputStream outStream;
		
	/**
 	* Closes down the socket connection using the socket's close method
 	*/
	public void closeConnection() {
		try {
			connSock.close();
			System.out.println("Closed the socket");
			MuckMain.DisconnectMenu();
		
			// Reset frame name
			MuckMain.textWindow.setTitle(MuckMain.muckMainTitle);
                        DataIn.dataBar.setTitle(DataIn.dataBarTitle);
		} catch (Exception oops) {
			// Some sort've exception goes here
			System.out.println("FromNet exception " + oops);
		}

		stop();
	}

	public void run() {
		 
		MuckMain.ConnectMenu();
		MuckConn.minimizedLineCount = 0;
		String tempAddy = (String)MuckConn.jmVars.get("ConnMuck");
		InetAddress serverAddy;

		if (sP.get("proxySet").equals("true")) {
			socks = true;
                        sockHost = (String)sP.get("proxyHost");
                        sockPort = Integer.parseInt((String)sP.get("proxyPort"));
                }

		try {
			serverAddy = InetAddress.getByName(tempAddy);
			if (socks) {
				System.out.println("Attempt to use Socks5socket.");
				connSock = (Socket)new Socks5socket(tempAddy, Integer.parseInt((String)MuckConn.jmVars.get("ConnPort")), sockHost, sockPort);
				System.out.println("Socks5socket successfully connected");
			} else {
				connSock = new Socket(serverAddy, Integer.parseInt((String)MuckConn.jmVars.get("ConnPort")));
			}
			outStream = new DataOutputStream(connSock.getOutputStream());
		} catch (NoRouteToHostException oops) {
			// No route to host, or operation timed out
			MuckMain.DisconnectMenu();
			String tempString = new String(oops + "");
			if (tempString.endsWith("unreachable")) {
				// Host unreachable
				MuckMain.mainText.append(RB("noRouteToHostException") + '\n');		
			} else {
				MuckMain.mainText.append(RB("operationTimedOutException") + '\n');
			}
		} catch (UnknownHostException oops) {
			MuckMain.DisconnectMenu();
				MuckMain.mainText.append(RB("unknownHostException") + '\n');
		} catch (ConnectException oops) {
			MuckMain.DisconnectMenu();
				MuckMain.mainText.append(RB("connectException") + '\n');
		} catch (Exception oops) {
			MuckMain.DisconnectMenu();
			System.out.println("From Net, no socket " + oops);

			MuckMain.mainText.append(RB("exception") + '\n');
			closeConnection();
		}

		try {
			inStream = new BufferedReader(new InputStreamReader(connSock.getInputStream()));
		} catch (IOException oops) {
			System.out.println("No inStream");
		}
		
		// Change frame title
		String connMuck = new String((String)MuckConn.jmVars.get("ConnMuck"));

		DataIn.dataBar.setTitle(DataIn.dataBarTitle + " (" + connMuck + ")");
		MuckMain.textWindow.setTitle(MuckMain.muckMainTitle + " (" + connMuck + ")");
		isConnected = true; // This notifies the program of true connection
		empty = true;
	
		while (empty) {
			try {
				String str = inStream.readLine();
				// Notify the callback that you have a string
				if (str == null) {closeConnection();}
				
				// Send the string to the timer, if running
				if (MuckMain.tWTimers.getState()) {
					// Timer is running
					try {
						Timers.CompareStrings(str);
					} catch (Exception timer) {
						System.out.println("Timer exception: " + timer);
					}
				}

				// Now show the output
				if (MuckMain.pauseStatus) {
					// Text is paused, spool to 'heldResponse
					MuckMain.heldResponse.addElement(str);
				} else {
					str = EnumPlugIns.CallPlugin(str, "output");
					MuckMain.mainText.append(str + '\n');
					if (!MuckMain.textWindowStatus) {
						// Change title bar of MuckMain window
						MuckConn.minimizedLineCount++;
		
						// Check for any 'escape' characters
						int s, f;
						String temp;
						while (str.indexOf('\u001b') > -1) {
							// Remove the escape
							temp = new String(str);
							s = temp.indexOf('\u001b');
							f = temp.indexOf("m", s);
							if (f > s) {
								str = new String(temp.substring(0, s) + temp.substring(f));
							}
						}

						// Trim the str down to a managable length
						String trimmedString;
						if (str.length() > 80) {
							trimmedString = str.substring(0, 80) + "...";
						} else {
							trimmedString = str;
						}
						MuckMain.textWindow.setTitle("(" + MuckConn.minimizedLineCount +") " + trimmedString);
					}
				}
			} catch (Exception oops) {
				// Tell the callback there was an error
				System.out.println("Error " + oops);
				closeConnection();
			}
		}
	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "FromNet", itemTarget);
	}
	// This supports multi-line messages
	private static Vector RBL(String itemTarget) {
		return ResReader.LangVector("JamochaMUDBundle", "FromNet", itemTarget);
	}

}
