/** EnumPlugIns.java enumerates
 * plugins at program start-up, and
 * contains functions for managing
 * them once the program is loaded
 * $Id: EnumPlugIns.java 1.7 2000/07/24 14:01:00 jeffnik Exp $
*/

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.List;
import java.awt.event.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;

import java.util.Properties;
import java.util.Vector;

import plugins.PlugInterface;

	/** EnumPlugIns.java enumerates
	 * plugins at program start-up, and
	 * contains functions for managing
	 * them once the program is loaded
         * @version $Id: EnumPlugIns.java 1.7 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
 	 */
public class EnumPlugIns{

	String pathSeparator;
	static private String temp1, temp2;
	public static Vector plugInClass, plugInName, plugInType, plugInStatus, temp;
	public static Object plugClass;
	public static String osName, sCurrentWorkingDir, userDirectory;

	/**
	 * This is the startup class to
	 * enumerate all the plugins found
	 * in the plug-in directory
	 */
	public EnumPlugIns() {
		plugInClass = new Vector(0, 1);
		plugInName = new Vector(0, 1);
		plugInType = new Vector(0, 1);
		plugInStatus = new Vector(0, 1);
		temp = new Vector(0, 1);
		String temp1 = new String("");
		String temp2 = new String("");
		

		// Now set the plug-ins directory
		userDirectory = (String)MuckConn.jmVars.get("UserDirectory");
		File plugIns = new File(userDirectory + "plugins");

		// check and see if there is a 'plugins' directory
		if (!plugIns.exists()) {
		    // There is no plugins directory, so we'll create one
		    plugIns.mkdir();
		}
		
		// Get a list of the files in that directory
		// discarding those that aren't plug-ins.
		
		String fileList[];
		fileList = plugIns.list();
		
		// Now read this to an array, deleting any
		// non-'class' files.  This could be done
		// with a FilenameFilter, but we're going
		// to do this quick and dirty.

		try {
			// This may cause an error if the file doesn't exist
			// Specifically, this occurs on *nix-type systems

			for(int i = 0; i < fileList.length; i++) {
				if (fileList[i].toLowerCase().endsWith("class")) {
					fileList[i] = fileList[i].substring(0, (fileList[i].length()) - 6);
					// This one has made the temp list!
					// Now see if it conforms to the
					// Plug-In 'standard'
					// This must be done through 'type-casting',
					// for the plug-ins don't exist at compile time
					try {
						// First, capture the class
						plugClass = (Object)Class.forName("plugins." + fileList[i]).newInstance();
	
						// Querry to see if it's a plugin or not
						try {
							plugInClass.addElement(plugClass);	
							plugInName.addElement(((PlugInterface)plugClass).PlugInName());
							MuckMain.tWPlugInMenu.add(((PlugInterface)plugClass).PlugInName());
							plugInType.addElement(((PlugInterface)plugClass).PlugInType());
							plugInStatus.addElement("false");

							// Now call any initialisation of the plugin
							((PlugInterface)plugClass).InitialiseAtLoad();
						} catch (Exception notPlugIn) {
							// Disregarded
							System.out.println("Name failure... " + notPlugIn);
						}
					} catch (InstantiationException ie) {
						// This is a standard error, from trying
						// to instantiate the 'interface'
					} catch (Exception e) {
						System.out.println("Plugin exception: " + e);
					}					
	
				}
			}

		} catch (Exception err) {
			// This is from the 'outside' loop
			System.out.println("EnumPlugins: Non-fatal error " + err);
		}

		// Write the names and status to the hashtable
		MuckConn.jmVars.put("PlugInName", plugInName);
		MuckConn.jmVars.put("PlugInStatus", plugInStatus);

		ResetPlugInStatus();
		MuckMain.RefreshPlugInListener();
	}

	/**
	 * Analyse the input/output and cycle through the list of plugins,
	 * applying any where the input/output meets the right criteria
	 */
	public static String CallPlugin(String targetString, String plugType) {
		// This is a public routine called to parse the plugins
		for (int i = 0; i < plugInName.size(); i++) {
			// Cycle through the list of plugins
			// calling only the type appropriate (input/output/other)
			temp1 = (String)plugInType.elementAt(i);
			temp2 = (String)plugInStatus.elementAt(i);			

			if (plugType.toLowerCase().equals(temp1.toLowerCase()) && temp2.toLowerCase().equals("true")) {
				// This is what we want, call the plugin
				
				try {
					plugClass = plugInClass.elementAt(i);
				} catch (Exception e) {
					System.out.println("Plugin Exception " + e);
				}
				targetString = new String(((PlugInterface)plugClass).PlugMain(targetString));
			}
		}
	return targetString;
	}

	/** 
	 * Set the status of the plugins, whether they are active or inactive
	 */
	public static void ResetPlugInStatus() {
		// Read in the .plugins.rc file, to set the state of the plugins
		// Vector stateVector;
		// List stateList;		
		Vector stateList;

		try {
			FileInputStream inputFile = new FileInputStream(userDirectory + ".plugins.rc");
			ObjectInputStream serializeStream = new ObjectInputStream(inputFile);
			// stateList = (List) serializeStream.readObject();	
			stateList = (Vector) serializeStream.readObject();
		} catch (FileNotFoundException e) {
			// The file does not exist, but will be written later
			// This is not a bad thing	
			System.out.println(".plugins.rc file was not found.");
			return;	
		} catch (Exception e) {
			System.out.println("Error during serialization " + e);
			// The file probably does not exist
			return;
		}

		// Now that we have the vector, loop through and change
		// any needed plugins to 'true' (active)
		for (int j = 0; j < plugInName.size(); j++) {
			for (int i = 0; i < stateList.size(); i++) {
				if (plugInName.elementAt(j).equals(stateList.elementAt(i))) {
					// This matches, so we set it true
					plugInStatus.setElementAt("true", j);
				}
			}
		}
		
		// Now add the plugInStatus to the hashtable
		MuckConn.jmVars.put("PlugInName", plugInName);
		MuckConn.jmVars.put("PlugInStatus", plugInStatus);
	}
	/**
	 * Analyse the input/output and cycle through the list of plugins,
	 * applying any where the input/output meets the right criteria
	 */
	public static String Description(String targetName) {

		String targetString = "";

		// This is a public routine called to parse the plugins
		for (int i = 0; i < plugInName.size(); i++) {
			// Cycle through the list of plugins
			// calling only the type appropriate (input/output/other)
			temp1 = (String)plugInName.elementAt(i);

			if (targetName.toLowerCase().equals(temp1.toLowerCase())) {
				// This is what we want, call the plugin
				
				try {
					plugClass = plugInClass.elementAt(i);
				} catch (Exception e) {
					System.out.println("Plugin Description Exception " + e);
				}
				targetString = new String(((PlugInterface)plugClass).PlugInDescription());
			}
		}
	return targetString;
	}

}			


