/**
 * DataIn, text input window
 * $Id: DataIn.java 1.12 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;

import gui.SyncFrame;
import gui.ResReader;

	/**
	 * This is the input window where the user may type to send info
	 * to the MUCK/MUD.  In addition, if features scrolling of long messages
	 * and a 10 command 'recall' feature implemented by a right mouse-click.
         * @version $Id: DataIn.java 1.12 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class DataIn extends Frame implements ActionListener, ComponentListener, KeyListener, MouseListener, WindowListener{

	
	public static SyncFrame dataBar;
	static Panel textPanel;
	private static PopupMenu backTrack;		
	protected String typedLine, bCPopup[];
	private static String backComm[];
	public static String dataBarTitle;
	public static TextArea dataText;
	
	public DataIn(){

	// Create the windows
	dataBarTitle = new String(RB("frameTitle.label"));
	dataBar = new SyncFrame(dataBarTitle, true, MuckConn.syncGroup);
	dataBar.addComponentListener(this);
	dataBar.addWindowListener(this);

	// Set Gridbag layout
        GridBagLayout dILayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
	
        textPanel = new Panel();
	backTrack = new PopupMenu();
	backComm = new String[10];

	// Add the text field to the box.
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = GridBagConstraints.BOTH;
	dataText = new TextArea("", 3, 70, TextArea.SCROLLBARS_VERTICAL_ONLY);
	
	dataText.addKeyListener(this);
        dataBar.add(dataText);
	
	Menu testMenu = new Menu("TestMenu!");
	backTrack.addActionListener(this);
	dataText.add(backTrack); 		// Adds PopupMenu to data entry area
	dataText.addMouseListener(this);	// Adds MouseListener to data entry area
	
	pack();

	// Display macroBar

	// Set the icon
	dataBar.setIconImage((Image)MuckConn.jmVars.get("JamochaMUDImage"));

	dataText.setForeground((Color)MuckConn.jmVars.get("ForeGroundColour"));
	dataText.setBackground((Color)MuckConn.jmVars.get("BackGroundColour"));
	dataText.setFont((Font)MuckConn.jmVars.get("ScreenFont"));

	}

	
	public static void Content(){
		DataIn z = new DataIn();
		
	}

	public void keyPressed(KeyEvent event){

		int arg = event.getKeyCode();
		
		if (arg == KeyEvent.VK_ENTER) {
			JMSendText();

			event.consume();
		}

		if (arg == KeyEvent.VK_ALT) 
			MuckMain.mainText.requestFocus();

		if (arg == KeyEvent.VK_UP) {
			// Check to see if the cursor is allowed to move up
			if (dataText.getCaretPosition() <= dataText.getColumns()) {
				// Caret is on first line, can't move up
				event.consume();
			}

		}

		if ((arg == KeyEvent.VK_X) && (event.isControlDown())) {
			// 'Supervisor' key was called.
			// Minimize all the windows
			HideFramesQuick();
		}
	
		if ((arg == KeyEvent.VK_Z) && (event.isControlDown())) {
			// restore minimized windows
			RestoreMinimizedFrames();

		}

		if (event.isControlDown()) {
			// First, check to see if this is for TinyFugue emulation
			if (MuckMain.tWTFKeysItem.getState()) {
				// boolean isTFKey = false;
				// Check this for applicable TinyFugue keys
				// and if it is, it will probably consume the event
				// STUB
				if (JMTFKeys.JMTFKeyStroke(event.getKeyCode())) {
					// Well, boys and girls, it really was a TF keystroke!
					// let us make sure this event goes no further!
					event.consume();
				}
			}

			// We'll send this to MuckMain, to see if
			// it is supposed to be a menu shortcut
			MuckMain.mainText.dispatchEvent(event);
			
		}

		return;
	}

	public void keyReleased(KeyEvent event){}

	public void keyTyped(KeyEvent event){	
		// We must make one exception, if the user is using TinyFugue emulation
		// so that we do not spool out text if they're releasing the 'pause text' key
		if (MuckMain.tWTFKeysItem.getState() && event.isControlDown()) {
			event.consume();
		} else {
			// It is okay to spool out the text
			if (MuckMain.pauseStatus) {
				SpoolText();
			}				// This spools out any paused text
		}
	}
	
	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		if (arg == "^") {
			typedLine = dataText.getText();
		}

		// Determine if a popupmenu item was selected (until a better way is found)
		for (int i = 0; i < backTrack.getItemCount(); i++) {
				if (arg.equals((backTrack.getItem(i).getLabel()))) {
					// dataText.setText(backComm[i]);
					// Set text from scrollback
					JMSetFromScrollBack(i);
				}
		};
		return;
	}

	// Check for mouse actions

	public void mousePressed(MouseEvent e) {
        	checkPopup(e) ;
        }
	public void mouseReleased(MouseEvent e) {
            	checkPopup(e) ;
	}
        public void mouseClicked(MouseEvent e) {
		if (MuckMain.pauseStatus) {
			SpoolText();
		}				// This spools out any paused text
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}

	// Component listeners
	public void componentHidden(ComponentEvent e) {
	}

	public void componentMoved(ComponentEvent e) {
	}

	public void componentResized(ComponentEvent e) {
	}

	public void componentShown(ComponentEvent e) {
	}

	/**
	 * Check for PopupTrigger to display command history
	 */
	void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
			ShowPopup(this, (e.getX()) + (dataBar.getLocationOnScreen()).x, (e.getY()) + (dataBar.getLocationOnScreen()).y);
			e.consume();
		}
	}

	/** Display the pop-up menu */
	public static void ShowPopup(Component origin, int x, int y) {
		// if x and y come in as -1, then we set the popup location from just the frame
		if (x == -1 && y == -1) {
			origin = dataText;
			x = (dataBar.getLocationOnScreen()).x;
			y = (dataBar.getLocationOnScreen()).y;
		}

		backTrack.show(origin, x, y);
	}
	/**
	 * Bring the frame into focus so the user may type
	 */
	public void windowActivated(WindowEvent event) {
		// First we insert a 6 millisecond kludge to make
		// up for the requestFocus timing problem in Java 1.1.7+
		long startTime = java.lang.System.currentTimeMillis();
		long currentTime = java.lang.System.currentTimeMillis();		

		while ((currentTime - startTime) < 7) {
			// Just an empty loop
			currentTime = java.lang.System.currentTimeMillis();	
		}

		// Now request focus
		dataText.requestFocus();

		try {
		} catch (Exception e) {
			// This is nothing to worry about, it just means
			// the key was never there in the first place
		}
	}

	public void windowClosed(WindowEvent event) {}

	public void windowClosing(WindowEvent event) {}

	public void windowDeactivated(WindowEvent event) {}

	public void windowDeiconified(WindowEvent event) {}

	public void windowIconified(WindowEvent event) {
		// record the frame into the hashtable
		MuckConn.jmVars.put("DataBar", dataBar.getBounds());
	}

	public void windowOpened(WindowEvent event) {}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "DataIn", itemTarget);
	}


	/**
	* Spool out any text that may have been paused
	*/
	public static void SpoolText() {

		resetTitles();

		MuckMain.pauseStatus = false;
		while (MuckMain.heldResponse.size() > 0) {
			MuckMain.mainText.append(MuckMain.heldResponse.elementAt(0).toString() + '\n');
			MuckMain.heldResponse.removeElementAt(0);
		}	
	}

	/**
	* Method to hide all the frames.  The 'supervisor' function
	*/
	public static void HideFramesQuick() {
		// Hide all the frames, 
		// the supervisor's here!
		dataBar.setTitle(".");
		dataBar.toBack();
		MuckMain.textWindow.setVisible(false);
		// MuMacros.macroFrame.setVisible(false);
		MuckConn.jmMacros.setVisible(false);
		
		// We'll unsync the databar, otherwise bringing it up to the
		// front may result in all the other windows showing up again.  Eeek!
		dataBar.setSync(false);
	}

	/**
	* Restore frames hidden by the 'Supervisor' function
	*/
	public static void RestoreMinimizedFrames() {
		// Restore the frames that
		// were minimized by the 'supervisor' key
		MuckMain.textWindow.setVisible(true);

		// Restore frame icons
		// dataBar.setIconImage(MuckConn.jamochaMUDImage);
		// MuckMain.textWindow.setIconImage(MuckConn.jamochaMUDImage);
		
		// Querry the MuckMain **** menu, to
		// see if we should set the Macros visible
		if (MuckMain.tWMacro.getState()) {
			// tWMacro is set to 'true', so show the Macro Frame
			// MuMacros.macroFrame.setVisible(true);
			MuckConn.jmMacros.setVisible(true);
		}

		if (MuckMain.tWSyncWindowsItem.getState()) {
			dataBar.setSync(true);
		}
		// now reset the title
		resetTitles();
	}

	/**
	* Used to reset the dataBar's title
	*/
	private static void resetTitles() {
		if (MuckMain.dFM.isEnabled()) {
			// We're connected to the muck, so
			// show the muck addy in the title
			dataBar.setTitle(dataBarTitle + " (" + MuckConn.jmVars.get("ConnMuck") + ")");

		} else {
			// Not connected, just have normal title
			dataBar.setTitle(dataBarTitle);
            }
	}

	/**
	* Add an entry to the 'command history' pop-up
	*/
	private static void addPopUpEntry(String str) {
		if (backTrack.getItemCount() > 9) {
			backTrack.remove(0);  // Removes first entry to make room
			for(int i = 0; i < backTrack.getItemCount(); i++) {
				backComm[i] = backComm[i + 1];
			}
		}
	
		backComm[backTrack.getItemCount()] = str;
		if (str.length() > 30) {
			backTrack.add(str.substring(0, 30) + "...");
		} else {
			backTrack.add(str);
		}
	}

	/**
	 * Package up the data to be sent to the MU*, parsing off any
	 * yucky characters such as 'new lines', etc., also determining
	 * via user-preference whether they should be sent in Unicode
	 * or standard ASCII format
	 */
	public static void JMSendText() {

		String str = dataText.getText();

		try {
			// try to extract any tabs, form feeds
			// backspaces, new lines, and carraige returns
			str.replace('\t', '*');
			str.replace('\f', '*');
			str.replace('\b', '*');
			str.replace('\n', '*');
			str.replace('\r', '*');

			// First, check for TinyFugue emulation, and parse any of
			// those commands first
			if (str.startsWith("@/")) {
				if (MuckMain.tWTFKeysItem.getState()) {
					// We'll check this line for actual TF commands
					// STUB
				}
			}

			// Send the string to the remote host
			if (MuckMain.tWUseUnicodeItem.getState()) {
				// Use Unicode output
				FromNet.outStream.writeChars(str + "\n");
			} else {
				// Change this to work with ASCII instead of UniCode
				FromNet.outStream.writeBytes(str + '\n');			 			}

			// Reset the caret to the 0, 0 position
			dataText.setCaretPosition(0);
		} catch (Exception oops) {
			System.out.println("DataIn outStream error: " + oops);
		}
		dataText.setText("");

		// Now add the command to the Popupmenu
		addPopUpEntry(str);

		// Send string to lag timer if active
		if (MuckMain.tWTimers.getState()) {
			// Timers are running, send the string
			Timers.AddOutput(str);
		}
	
	}

	/** Set the current text from the scrollback menu */
	public static void JMSetFromScrollBack(int pos) {
		// If the integer comes in as '-1', that means to use the last string
		if (pos == -1) pos = backTrack.getItemCount() - 1;

		// First, check to see if the integer is valid
		if (pos > backTrack.getItemCount() || pos < 0) return;

		// Now we'll set the text from the menu item
		dataText.setText(backComm[pos]);
	}

}
