/**
 * AboutBox for JamochaMUD (to display license, thanks, etc...)
 * $Id: AboutBox.java 1.21 2000/07/24 14:01:00 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import gui.PosTools;
import gui.JMText;
import gui.ResReader;

	/**
	 * A Dialogue box to display licensing information and credits/thanks
	 * for the developement of JamochaMUD.
         * @version $Id: AboutBox.java 1.21 2000/07/24 14:01:00 jeffnik Exp $
         * @author Jeff Robinson
         */
public class AboutBox extends Dialog implements ActionListener, KeyListener{

	private static Button okayButton, cancelButton;
	Label lineLabel;
	// We'll just use the TextArea until problems with the vt320 are resolved
	private static JMText text;

	public AboutBox(){
		super(MuckMain.textWindow, "(JamochaMUD) About", true);
		// The "About Box" for JamochaMUD information
		
		// Design look for gridbag layout
		GridBagLayout dLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(dLayout);
		
		// Add the components to the dialog
				
		this.text = new JMText("", 80, 10, JMText.SCROLLBARS_VERTICAL_ONLY);

		text.setEditable(false);
		text.addKeyListener(this);
		constraints.insets = new Insets(7, 7, 2, 7);
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		constraints.gridheight = GridBagConstraints.RELATIVE;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.weightx = 1;
		constraints.weighty = 1;
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.CENTER;
		dLayout.setConstraints(text, constraints);
		add(text);

		okayButton = new Button(RB("credits"));
		constraints.insets = new Insets(2, 7, 7, 2);
		constraints.gridwidth = GridBagConstraints.RELATIVE;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.weightx = 0;
		constraints.weighty = 0;
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.WEST;
		dLayout.setConstraints(okayButton, constraints);
		okayButton.addActionListener(this);
		add(okayButton);
		
		cancelButton = new Button(RB("thanksalot!"));
		constraints.insets = new Insets(2, 2, 7, 7);
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.weightx = 0;
		constraints.weighty = 0;
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		dLayout.setConstraints(cancelButton, constraints);
		cancelButton.addActionListener(this);
		add(cancelButton);

		this.pack();

		text.setFont(MuckMain.mainText.getFont());
		text.setBackground(MuckMain.mainText.getBackground());
		text.setForeground(MuckMain.mainText.getForeground());

		Point sp = PosTools.findCentre();
		setLocation(sp.x - 237, sp.y - 185);
		setSize(475, 370);
		// setVisible(true);

		DisplayLicense();


	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "AboutBox", itemTarget);
	}

	/**
	 * Information pertaining to the GPL and copyright
	 */
	private void DisplayLicense() {
		// First, empty the text area
		text.setText("");

		// Write the GPL information
		text.append('\u001b' + "[32mJamochaMUD - a (Java) MUD/MUCK client" + '\n');
		// text.append("JamochaMUD - a (Java) MUD/MUCK client" + '\n');
		text.append("Copyright (C) 1998-2000  Jeff Robinson (jeffnik@anecho.mb.ca)" + '\n');
		text.append('\u001b' + "[0m" + '\n');
//		text.append("\n");
		text.append("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or any later version." + '\n');
		text.append("\n");
		text.append("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details." + '\n');
		text.append("\n");
		text.append("You should have received a copy of the GNU General Public License  along with this program; if not, write to the" + '\n');
		text.append("Free Software Foundation, Inc., 59 Temple Place - Suite 330," + '\n');
		text.append("Boston, MA  02111-1307, USA." + '\n');
		okayButton.setLabel(RB("credits"));		
	}

	/**
	 * Changes the TextArea to show the credits for JamochaMUD
	 */
	private void ShowCredits() {
		// First, empty the text area
		text.setText("");

		// Write the credits
		// In the future, perhaps this will be on a Canvas instead
		text.append("Dedicated to the memory of F. Ross Browne; uncle, instigator, inspiration, and curmudgeon." + '\n');
		text.append("\n");
		text.append('\u001b' + "[36mJeff Robinson - High(ly caffeinated) Muckymuck (jeffnik@anecho.mb.ca)" + '\n' + '\u001b' + "[0m");
		text.append("\n");
		text.append("Jason Holmgren - Annoying Vermin" + '\n');
		text.append("Sean Simpson - Head Haranguer (Strnig)" + '\n');
		text.append("Sara Palmer - Chief of Wahness" + '\n');
		text.append("Sandi Wilkinson - Wizzywizz" + '\n');
                text.append("Andrea Adams - Clue-by-four handler" + '\n');
                text.append("Bjoern Weber - Socks(5) for fox!" + '\n');
		text.append("\n");
		text.append("Translations:" + '\n');
		text.append("Miguel Estrugo - Man of many words (Spanish and Italian)" + '\n');
		text.append("Mark Straver - Dutch (No, Dutch is *NOT* baby-German!) \n");
		text.append("\n");
		text.append("A great deal of thanks to Matthias L. Jugel and Marcus Meiner for their Java telnet app (http://www.first.gmd.de/persons/leo/java/Telnet).");

		// Change the button to 'About'
		okayButton.setLabel(RB("aboutJamochaMUD"));		
	}
	
	/**
	 * Check for button presses
	 */
	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(cancelButton.getLabel())) {
			// dismiss the dialogue
			dispose();
		}

		if (arg.equals(okayButton.getLabel())) {
			// Check to see which function to call
			if (arg.equals(RB("credits"))) {
				// Change to display the credits
				ShowCredits();
			} else {
				// Change to display the license
				DisplayLicense();
			}
		}

	}

	/**
	 * Consume any keystrokes that are in the TextArea
	 */
	public void keyPressed(KeyEvent event){
		event.consume();
		return;
	}
	
	public void keyTyped(KeyEvent event){}

	public void keyReleased(KeyEvent event){}

}
